<%--
 * Copyright (c) 2001, 2007, Oracle. All rights reserved.  
 *
 *      NAME
 *       procedureStatusJobs.jsp
 *
 *      NOTES
 *       Page to check the status of jobs of a running instance.
 *
 * MODIFIED  (MM/DD/YY)  VERSION
 *  ptorreti  07/04/07 - For changing jobs tab name and log tab name
 *  ktamtoro  08/02/06 - Add log file page
 *  ktamtoro  08/02/06 - Add log file page
 *  ktamtoro  08/03/06 - Backport ktamtoro_bug-5412873 from main
 *  ktamtoro  01/23/06 - Add scheduled time
 *  ktamtoro  01/23/06 - translate instance name
 *  ktamtoro  01/23/06 - Add scheduled time
 *  ktamtoro  01/23/06 - translate instance name
 *  ktamtoro  01/24/06 - XbranchMerge ktamtoro_paf_bugfixes_3 from main 
 *  ktamtoro  12/30/05 - XbranchMerge ktamtoro_resource_translation from main 
 *  ktamtoro  12/28/05 - XbranchMerge ktamtoro_paf_exit_review_fix from main 
 *  ktamtoro  12/20/05 - XbranchMerge ktamtoro_paf_ui_fixes_2 from main 
 *  ktamtoro  12/13/05 - XbranchMerge ktamtoro_upload_script from main 
 *  ktamtoro  12/12/05 -
 *  fantic    11/14/05 - add link to custom status monitoring ui for each step
 *  fantic    10/20/05 - removing ignore and retry buttons from the jobs table
 *  ktamtoro  08/25/05 - Display error handling mode
 *  ktamtoro  08/23/05 - Update status string
 *  ktamtoro  08/18/05 - Add form value to hold instance guid
 *  ktamtoro  08/12/05 - Move status columns to left
 *  ktamtoro  08/06/05 -
 *  ktamtoro  08/04/05 -
 *  sonorato  08/04/05 -
 *  ktamtoro  07/30/05 -
 *  fantic    07/19/05 - connecting to the backend via DeploymentJobsBean
 *  sonorato  07/01/05 -
 *  ktamtoro  06/16/05 - Change JSP to using oracle.sysman.pp.paf.*
 *  ktamtoro  06/08/05 - ktamtoro_empp_paf_ui
 *  ktamtoro  04/28/05 - created
 *
--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
  <script language="javascript">
    function _submitPage(a){
      _syncIndex(a);
      submitForm('pafForm', true, {'event':'statusFilterChange'});
    }
</script>

<uix:buildTree nodeID="baseContent" scope="request">
  <uix:header textBinding="PA_STATUS_HDR@paResourceBundle">
    <uix:contents>
      <uix:rowLayout width="100%">
        <uix:contents>
          <uix:cellFormat hAlign="right">
            <%-- Buttons for page events (located on top right side) --%>
            <uix:include node="pageButtons.jsp"/>
          </uix:cellFormat>
        </uix:contents>
      </uix:rowLayout>
      <uix:spacer height="10" width="10"/>
      <%-- Instance General Status --%>
			<uix:header textBinding="PA_STATUS_GENERAL_INFO_HDR@paResourceBundle">
				<uix:contents>
          <uix:spacer height="10" width="10"/>
          <%-- Instance GUID --%>
          <uix:formValue nameBinding="PA_INSTANCE_GUID_FORM_VALUE@paResourceBundle"
                         valueBinding="instanceGUID@deploymentBean@servletRequest"/>
          <uix:messageComponentLayout rows="6"
                                      columns="2"
                                      fieldWidth="100%">
            <uix:contents>
               <%-- left column row 1 --%>
              <%-- Instance Name --%>
              <uix:messageLayout promptBinding="PA_INFO_INSTANCE_NAME_PROMPT@paResourceBundle">
                <uix:contents>
                  <uix:styledText textBinding="translatedInstanceName@deploymentBean@servletRequest"
                  								styleClass="OraDataText"/>
                </uix:contents>
              </uix:messageLayout>
              <%-- left column row 2 --%>
              <%-- Procedure Name --%>
              <uix:messageLayout promptBinding="PA_INFO_PROCEDURE_NAME_PROMPT@paResourceBundle">
                <uix:contents>
                  <uix:styledText textBinding="procedureName@deploymentBean@servletRequest"
                  								styleClass="OraDataText"/>
                </uix:contents>
              </uix:messageLayout>
              <%-- left column row 3 --%>
              <%-- Procedure Version --%>
              <uix:messageLayout promptBinding="PA_INFO_PROCEDURE_VERSION_PROMPT@paResourceBundle">
                <uix:contents>
                  <uix:styledText textBinding="procedureVersion@deploymentBean@servletRequest"
                  								styleClass="OraDataText"/>
                </uix:contents>
              </uix:messageLayout>
              <%-- left column row 4 --%>
              <%-- Error Handling Mode --%>
              <uix:messageLayout promptBinding="PA_INFO_ERROR_HANDLING_PROMPT@paResourceBundle">
                <uix:contents>
                  <uix:styledText textBinding="errorHandlingModeString@deploymentBean@servletRequest"
                  								styleClass="OraDataText"/>
                </uix:contents>
              </uix:messageLayout>
              <%-- left column row 5 --%>
              <%-- Instance Status --%>
              <uix:messageLayout promptBinding="PA_INFO_STATUS_PROMPT@paResourceBundle">
                <uix:contents>
                  <uix:styledText textBinding="statusString@deploymentBean@servletRequest"
                  								styleClass="OraDataText"/>
                </uix:contents>
              </uix:messageLayout>
              <%-- left column row 6 --%>
              <%-- Owner of the instance --%>
              <uix:messageLayout promptBinding="PA_INFO_OWNER_PROMPT@paResourceBundle">
                <uix:contents>
                  <uix:styledText textBinding="owner@deploymentBean@servletRequest"
                  								styleClass="OraDataText"/>
                </uix:contents>
              </uix:messageLayout>
              <%-- right column row 1 --%>
              <%-- Date and Time the instance is created --%>
              <uix:messageLayout promptBinding="PA_INFO_CREATED_ON_PROMPT@paResourceBundle">
                <uix:contents>
                  <uix:styledText textBinding="createdOnDateString@deploymentBean@servletRequest"
                  							  styleClass="OraDataText"/>
                </uix:contents>
              </uix:messageLayout>
              <%-- right column row 2 --%>
              <%-- Date and Time the instance is scheduled to run --%>
              <uix:messageLayout promptBinding="SUMMARY_SCHEDULED@jobsResourceBundle">
                <uix:contents>
                  <uix:styledText textBinding="scheduledDateString@deploymentBean@servletRequest"
                  								styleClass="OraDataText"/>
                </uix:contents>
              </uix:messageLayout>
              <%-- right column row 3 --%>
              <%-- Date and time the instance starts executing --%>
              <uix:messageLayout promptBinding="PA_INFO_START_DATE_PROMPT@paResourceBundle">
                <uix:contents>
                  <uix:styledText textBinding="startDateString@deploymentBean@servletRequest"
                  								styleClass="OraDataText"/>
                </uix:contents>
              </uix:messageLayout>
              <%-- right column row 4 --%>
              <%-- Last Updated date --%>
              <uix:messageLayout promptBinding="PA_INFO_LAST_UPDATED_PROMPT@paResourceBundle">
                <uix:contents>
                  <uix:styledText textBinding="lastUpdatedString@deploymentBean@servletRequest"
                  								styleClass="OraDataText"/>
                </uix:contents>
              </uix:messageLayout>
              <%-- right column row 5 --%>
              <%-- Date and time the instance is completed --%>
              <uix:messageLayout promptBinding="PA_INFO_COMPLETED_DATE_PROMPT@paResourceBundle">
                <uix:contents>
                  <uix:styledText textBinding="completedDateString@deploymentBean@servletRequest"
                  								styleClass="OraDataText"/>
                </uix:contents>
              </uix:messageLayout>
            </uix:contents>
          </uix:messageComponentLayout>
        </uix:contents>
      </uix:header>
      <uix:spacer height="10" width="10"/>
      <%-- Jobs table --%>
			<uix:header textBinding="PA_STATUS_DETAIL_INFO_HDR@paResourceBundle">
        <uix:contents>
				  <%-- Subtab links --%>
				  <uix:subTabLayout>
				    <uix:subTabBar>
				      <uix:contents>
				        <%-- steps link --%>
				        <uix:link textBinding="PA_STEPS_LINK@paResourceBundle"
				                  destinationBinding="stepsLink@servletRequest"
				                  selected="false"/>
				        <%-- Selected link: jobs link --%>
				        <uix:link textBinding="PA_JOB_DETAILS@paResourceBundle"
				                  destinationBinding="jobsLink@servletRequest"
				                  selected="true"/>
                <%-- results  link --%>
                <uix:link textBinding="PA_RESULTS_LINK@paResourceBundle"
                          destinationBinding="resultsLink@servletRequest"
                          renderedBinding="showResultsLink@servletRequest"
                          disabledBinding="enableResultsLink@servletRequest"
                          selected="false"/>
                <%-- log file link --%>
                <uix:link textBinding="PA_OMS_LOG@paResourceBundle"
                          destinationBinding="logLink@servletRequest"
                          selected="false"/>
				      </uix:contents>
				    </uix:subTabBar>
            <uix:contents>
              <%-- Jobs table --%>
              <uix:table id="jobsTable"
                         nameBinding="PA_STATUS_JOBS_TABLE@paResourceBundle"
                         alternateTextBinding="PA_TABLE_NO_ITEMS_FOUND@paResourceBundle"
                         tableDataBinding="displayedTableData@jobsTable@servletRequest"
                         blockSizeBinding="blockSize@jobsTable@servletRequest"
                         maxValueBinding="maxValue@jobsTable@servletRequest"
                         minValueBinding="minValue@jobsTable@servletRequest"
                         valueBinding="currentValue@jobsTable@servletRequest"
                         partialRenderMode="self"
                         showAll="yes"
                         formSubmitted="true"
                         width="100%">
                <uix:contents>
                  <%-- save the GUID --%>
                  <uix:formValue nameBinding="PA_JOB_GUID_FORM_VALUE@paResourceBundle"
                                 valueBinding="jobGUID"/>
                  <%-- save the GUID --%>
                  <uix:formValue nameBinding="PA_JOB_EXECUTION_GUID_FORM_VALUE@paResourceBundle"
                                 valueBinding="jobExecutionGUID"/>
                  <%-- Job ID --%>
                  <uix:column rendered="false">
                    <uix:columnHeader>
                      <uix:sortableHeader sortableBinding="PA_JOBS_JOB_GUID_CH_NAME@sortColumnHeader@jobsTable@servletRequest"
                                          valueBinding="PA_JOBS_JOB_GUID_CH_NAME@paResourceBundle"
                                          textBinding="PA_JOBS_JOB_GUID_CH@paResourceBundle"/>
                    </uix:columnHeader>
                    <uix:contents>
                      <uix:link textBinding="jobGUID"
                                destinationBinding="jobDestination"/>
<%--
                                targetFrame="_blank"/>
--%>
                    </uix:contents>
                  </uix:column>
                  <%-- Job Name --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader sortableBinding="PA_JOBS_JOB_NAME_CH_NAME@sortColumnHeader@jobsTable@servletRequest"
                                          valueBinding="PA_JOBS_JOB_NAME_CH_NAME@paResourceBundle"
                                          textBinding="PA_JOBS_JOB_NAME_CH@paResourceBundle"/>
                    </uix:columnHeader>
                    <uix:contents>
                      <uix:link textBinding="jobName"
                                destinationBinding="jobDestination"/>
<%--
                                targetFrame="_blank"/>
--%>
                    </uix:contents>
                  </uix:column>
                  <%-- step status --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader sortableBinding="PA_JOBS_STATUS_CH_NAME@sortColumnHeader@jobsTable@servletRequest"
                                          valueBinding="PA_JOBS_STATUS_CH_NAME@paResourceBundle"
                                          textBinding="PA_JOBS_STATUS_CH@paResourceBundle"/>
                    </uix:columnHeader>
                    <uix:contents>
                      <uix:link textBinding="stepStatus"
                                destinationBinding="statusDestination"
                                targetFrame="_blank"/>
                    </uix:contents>
                  </uix:column>
                  <%-- job status --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader sortableBinding="PA_JOBS_JOB_STATUS_CH_NAME@sortColumnHeader@jobsTable@servletRequest"
                                          valueBinding="PA_JOBS_JOB_STATUS_CH_NAME@paResourceBundle"
                                          textBinding="PA_JOBS_JOB_STATUS_CH@paResourceBundle"/>
                    </uix:columnHeader>
                    <uix:contents>
                      <uix:styledText textBinding="jobStatus"/>
                    </uix:contents>
                  </uix:column>
                  <%-- Job Type --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader sortableBinding="PA_JOBS_JOB_TYPE_CH_NAME@sortColumnHeader@jobsTable@servletRequest"
                                          valueBinding="PA_JOBS_JOB_TYPE_CH_NAME@paResourceBundle"
                                          textBinding="PA_JOBS_JOB_TYPE_CH@paResourceBundle"/>
                    </uix:columnHeader>
                    <uix:contents>
                      <uix:styledText textBinding="jobType"/>
                    </uix:contents>
                  </uix:column>
                  <%-- Target the job operates on --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader sortableBinding="PA_JOBS_TARGET_CH_NAME@sortColumnHeader@jobsTable@servletRequest"
                                          valueBinding="PA_JOBS_TARGET_CH_NAME@paResourceBundle"
                                          textBinding="PA_JOBS_TARGET_CH@paResourceBundle"/>
                    </uix:columnHeader>
                    <uix:contents>
                      <uix:link textBinding="targetName"/>
                    </uix:contents>
                  </uix:column>
                  <%-- Date and time the job status is last updated --%>
                 <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader sortableBinding="PA_JOBS_LAST_UPDATED_CH_NAME@sortColumnHeader@jobsTable@servletRequest"
                                          valueBinding="PA_JOBS_LAST_UPDATED_CH_NAME@paResourceBundle"
                                          textBinding="PA_JOBS_LAST_UPDATED_CH@paResourceBundle"/>
                    </uix:columnHeader>
                    <uix:contents>
                      <uix:styledText textBinding="lastUpdated"/>
                    </uix:contents>
                  </uix:column>
                </uix:contents>
                <uix:tableSelection>
                  <uix:multipleSelection rendered="false">
                    <uix:contents>
                      <%-- (not rendered) ignore a failed job--%>
                      <uix:submitButton textBinding="PA_IGNORE_BTN@paResourceBundle"
                                        name="event"
                                        valueBinding="PA_IGNORE@paResourceBundle"
                                        disabledBinding="ignoreBtnDisabled@servletRequest"
                                        renderedBinding="ignoreBtnRendered@servletRequest"/>
                      <%-- (not rendered) retry a failed job --%>
                      <uix:submitButton textBinding="PA_RETRY_BTN@paResourceBundle"
                                        name="event"
                                        valueBinding="PA_RETRY@paResourceBundle"
                                        renderedBinding="retryBtnRendered@servletRequest"/>
                    </uix:contents>
                  </uix:multipleSelection>
                </uix:tableSelection>
                <uix:tableActions>
                  <uix:rowLayout width="20">
                    <uix:contents>
                      <uix:cellFormat>
                        <uix:contents>
                          <%-- Job Status Filter Choice --%>
                          <uix:messageChoice nameBinding="PA_STATUS_FILTER_CHOICE@paResourceBundle"
                                             promptBinding="PA_STATUS_FILTER_CHOICE_PROMPT@paResourceBundle"
                                             selectedValueBinding="statusValue@servletRequest"
                                             onChange="_submitPage(this)">
                            <uix:contents childDataBinding="statusChoices@servletRequest">
                              <uix:option textBinding="text" valueBinding="value" selectedBinding="selected"/>
                            </uix:contents>
                          </uix:messageChoice>
                        </uix:contents>
                      </uix:cellFormat>
                    </uix:contents>
                  </uix:rowLayout>
                </uix:tableActions>
              </uix:table>
              <uix:rowLayout>
                <uix:tip textBinding="PA_JOB_NAME_LINK_TIP@paResourceBundle"/>
              </uix:rowLayout>
            </uix:contents>
          </uix:subTabLayout>
        </uix:contents>
      </uix:header>
      <uix:rowLayout width="100%">
        <uix:contents>
          <uix:cellFormat hAlign="right">
            <%-- Buttons for page events (located on top right side) --%>
            <uix:include node="pageButtons.jsp"/>
          </uix:cellFormat>
        </uix:contents>
      </uix:rowLayout>
    </uix:contents>
  </uix:header>
</uix:buildTree>

<%@ include file="templateBase.jspf" %>
