<%--
 * Copyright (c) 2001, 2006, Oracle. All rights reserved.  
 *
 *      NAME
 *       procedureStatusPhaseDetail.jsp
 *
 *      NOTES
 *       Page to view detailed status of a phase.
 *
 * MODIFIED  (MM/DD/YY)  VERSION
 *  ptorreti  10/06/06 - Backport ptorreti_bug5215217 from main
 *  rahgupta  08/09/06 - Backport rahgupta_bug-5247357 from main
 *  rahgupta  07/11/06 - Backport rahgupta_bug-4707884 from main
 *  ktamtoro  01/24/06 - XbranchMerge ktamtoro_paf_bugfixes_3 from main 
 *  ktamtoro  12/30/05 - XbranchMerge ktamtoro_resource_translation from main 
 *  ktamtoro  12/28/05 - XbranchMerge ktamtoro_paf_exit_review_fix from main 
 *  ktamtoro  12/13/05 - XbranchMerge ktamtoro_upload_script from main 
 *  ptorreti  07/25/06 - adding elapsed time 
 *  rahgupta  06/22/06 -
 *  ktamtoro  01/23/06 - translate instance name
 *  ktamtoro  12/12/05 -
 *  fantic    11/18/05 - adding maximum length limit for input text boxes
 *  fantic    11/14/05 - add link to custom status monitoring ui for each step
 *  rahgupta  11/18/05 - use translatedName and translatedDescription
 *  ktamtoro  09/16/05 - Add column for notes
 *  ktamtoro  08/30/05 - disable buttons if paused or aborted or completed
 *  ktamtoro  08/25/05 - display error handling mode of the phase
 *  ktamtoro  08/18/05 - add form values to hold instance guid and step guid
 *  ktamtoro  08/12/05 -
 *  ktamtoro  08/11/05 - Hide confirm button and job status column
 *  ktamtoro  08/08/05 -
 *  ktamtoro  08/05/05 -
 *  ktamtoro  08/04/05 - fix tree data binding
 *  ktamtoro  08/03/05 -
 *  ktamtoro  08/01/05 -
 *  ktamtoro  06/16/05 - Change JSP to using oracle.sysman.pp.paf.*
 *  ktamtoro  06/08/05 - ktamtoro_empp_paf_ui
 *  ktamtoro  04/28/05 - created
 *
 * Inputs:
 *   [everything expected by pageButtons.jsp]
 *   DeploymentBean deploymentBean@servletRequest
 *   [everything expected by templateBase.jspf]
--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:buildTree nodeID="baseContent" scope="request">
  <uix:header textBinding="PA_STATUS_PHASE_DETAIL_HDR@paResourceBundle">
  	<uix:contents>
  		<uix:rowLayout width="100%">
  			<uix:contents>
  				<uix:cellFormat hAlign="right">
            <%-- Buttons for page events (located on top right side) --%>
            <uix:include node="pageButtons.jsp"/>
          </uix:cellFormat>
        </uix:contents>
  		</uix:rowLayout>
      <uix:spacer height="10" width="10"/>
  		<%-- Step General Information --%>
  		<uix:header textBinding="PA_STATUS_GENERAL_INFO_HDR@paResourceBundle">
  			<uix:contents>
          <uix:spacer height="10" width="10"/>
          <%-- Instance GUID --%>
          <uix:formValue nameBinding="PA_INSTANCE_GUID_FORM_VALUE@paResourceBundle"
                         valueBinding="instanceGUID@deploymentBean@servletRequest"/>
          <%-- Step GUID --%>
          <uix:formValue nameBinding="PA_GUID_FORM_VALUE@paResourceBundle"
                         valueBinding="stepGUID@selectedStep@deploymentBean@servletRequest"/>
          <uix:labeledFieldLayout width="450" columns="1">
            <uix:contents>
              <%-- Phase name --%>
              <uix:messageStyledText promptBinding="PA_INFO_PHASE_NAME_PROMPT@paResourceBundle"
              											 textBinding="translatedStepName@selectedStep@deploymentBean@servletRequest"
              											 styleClass="OraDataText"/>
              <%-- Phase type --%>
              <uix:messageStyledText promptBinding="PA_INFO_PHASE_TYPE_PROMPT@paResourceBundle"
              											 textBinding="(stepTypeString@selectedStep@deploymentBean@servletRequest)@paResourceBundle"
              											 styleClass="OraDataText"/>
              <%-- Phase description --%>
              <uix:messageStyledText promptBinding="PA_INFO_PHASE_DESCRIPTION_PROMPT@paResourceBundle"
              											 textBinding="translatedDescription@selectedStep@deploymentBean@servletRequest"
              											 styleClass="OraDataText"/>
              <%-- Error Handling Mode --%>
              <uix:messageStyledText promptBinding="PA_INFO_ERROR_HANDLING_PROMPT@paResourceBundle"
              											 textBinding="errorHandlingModeString@selectedStep@deploymentBean@servletRequest"
              											 styleClass="OraDataText"/>
              <%-- The instance the phase belongs to --%>
              <uix:messageStyledText promptBinding="PA_INFO_INSTANCE_NAME_PROMPT@paResourceBundle"
              											 textBinding="translatedInstanceName@deploymentBean@servletRequest"
             											   destinationBinding="instanceDestinationURL@deploymentBean@servletRequest"
              											 styleClass="OraLinkText"/>
              <%-- Phase Status --%>
              <uix:messageStyledText promptBinding="PA_INFO_STATUS_PROMPT@paResourceBundle"
              											 textBinding="statusString@selectedStep@deploymentBean@servletRequest"
              											 styleClass="OraDataText"/>
              <%-- Date and time the phase is executed --%>
              <uix:messageStyledText promptBinding="PA_INFO_START_DATE_PROMPT@paResourceBundle"
              											 textBinding="dateStartedString@selectedStep@deploymentBean@servletRequest"
              											 styleClass="OraDataText"/>
              <%-- Date and time the phase execution is completed --%>
              <uix:messageStyledText promptBinding="PA_INFO_COMPLETED_DATE_PROMPT@paResourceBundle"
              											 textBinding="dateCompletedString@selectedStep@deploymentBean@servletRequest"
              											 styleClass="OraDataText"/>
              <uix:spacer height="10" width="10"/>
            </uix:contents>
          </uix:labeledFieldLayout>
        </uix:contents>
      </uix:header>
      <uix:spacer height="10" width="10"/>
  		<%-- Targets and Phase/Step HGrid --%>
  		<uix:header textBinding="PA_STATUS_TARGETS_HDR@paResourceBundle">
  			<uix:contents>
          <uix:hGrid id="targetsHGrid"
                     alternateTextBinding="PA_TABLE_NO_ITEMS_FOUND@paResourceBundle"
                     treeDataBinding="treeData@servletRequest"
                     proxyBinding="proxy@proxyBean@servletRequest"
                     formSubmitted="true"
                     width="100%">
            <uix:nodeStamp>
              <%-- Target --%>
              <uix:column>
                <uix:columnHeader>
                  <uix:sortableHeader sortable="no"
                                      textBinding="PA_TARGETS_TARGET_CH@paResourceBundle"/>
                </uix:columnHeader>
                <uix:columnFormat cellNoWrapFormat="true"/>
                <uix:contents>
                  <uix:link textBinding="name"
                            destinationBinding="destination"/>
                </uix:contents>
              </uix:column>
            </uix:nodeStamp>
            <uix:contents>
              <%-- Breakpoint --%>
              <uix:column rendered="false">
                <uix:columnHeader>
                  <uix:sortableHeader sortable="no"
                                      textBinding="PA_TARGETS_BREAKPOINT_CH@paResourceBundle"/>
                </uix:columnHeader>
                <uix:columnFormat columnDataFormat="iconButtonFormat" />
                <uix:contents>
                  <uix:image sourceBinding="breakpoint_img"/>
                </uix:contents>
              </uix:column>
              <%-- Status --%>
              <uix:column>
                <uix:columnHeader>
                  <uix:sortableHeader sortable="no"
                                      textBinding="PA_TARGETS_STATUS_CH@paResourceBundle"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:link textBinding="stepStatus"
                            destinationBinding="statusDestination"/>
<%--
                            targetFrame="_blank"/>
--%>
                </uix:contents>
              </uix:column>
              <%-- Instruction --%>
              <uix:column renderedBinding="hasInstruction@selectedStep@deploymentBean@servletRequest">
                <uix:columnHeader>
                  <uix:sortableHeader sortable="no"
                                      valueBinding="PA_TARGETS_INSTRUCTION_CH_NAME@paResourceBundle"
                                      textBinding="PA_TARGETS_INSTRUCTION_CH@paResourceBundle"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:messageTextInput nameBinding="PA_STATUS_INSTRUCTION_INPUT@paResourceBundle"
                                        prompt=""
                                        columns="50"
                                        rows="2"
                                        textBinding="instruction"
                                        renderedBinding="instructionRendered"
                                        readOnly="true"/>
                </uix:contents>
                <uix:columnFormat cellNoWrapFormat="false"/>
              </uix:column>
              <%-- Note --%>
              <uix:column>
                <uix:columnHeader>
                  <uix:sortableHeader sortable="no"
                                      valueBinding="PA_TARGETS_NOTES_CH_NAME@paResourceBundle"
                                      textBinding="PA_TARGETS_NOTES_CH@paResourceBundle"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:messageTextInput nameBinding="PA_TARGETS_NOTE_INPUT@paResourceBundle"
                                        prompt=""
                                        columns="50"
                                        rows="3"
                                        wrap="off"
                                        maximumLength="150"
                                        textBinding="note"
                                        renderedBinding="noteInputRendered"
                                        readOnlyBinding="noteInputReadOnly"/>
                </uix:contents>
                <uix:columnFormat cellNoWrapFormat="false"/>
              </uix:column>

                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader sortable="false"
                                valueBinding="elapsedTime@selectedStep@deploymentBean@servletRequest"
                                          textBinding="PAF_ELAPSED_TIME_HEAD@paResourceBundle"/>
                    </uix:columnHeader>
                    <uix:contents>
                      <uix:styledText textBinding="elapsedTime"/>
                    </uix:contents>
                  </uix:column>


              <%-- Job ID --%>
              <uix:column rendered="false">
                <uix:columnHeader>
                  <uix:sortableHeader sortable="no"
                                      textBinding="PA_TARGETS_JOB_GUID_CH@paResourceBundle"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:link textBinding="jobGUID"/>
                </uix:contents>
              </uix:column>
              <%-- Job Status --%>
<%--
              <uix:column renderedBinding="hasJobs@selectedStep@deploymentBean@servletRequest">
                <uix:columnHeader>
                  <uix:sortableHeader sortable="no"
                                      textBinding="PA_TARGETS_JOB_STATUS_CH@paResourceBundle"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:link textBinding="jobStatus"
                            destinationBinding="jobDestination"/>
                </uix:contents>
              </uix:column>
--%>
              <%-- step guid --%>
              <uix:formValue nameBinding="PA_GUID_FORM_VALUE@paResourceBundle"
                             valueBinding="guid"/>
              <%-- state guid --%>
              <uix:formValue nameBinding="PA_STATE_GUID_FORM_VALUE@paResourceBundle"
                             valueBinding="stateGUID"/>
            </uix:contents>
            <uix:tableSelection>
              <uix:multipleSelection renderedBinding="hGridSelectionRendered@servletRequest"
                                     disabledBinding="disabled"
                                     selectionBinding="selected">
                <uix:contents>
                  <%-- Ignore a failed job (only on the steps) --%>
                  <uix:submitButton textBinding="PA_IGNORE_BTN@paResourceBundle"
                                    name="event"
                                    valueBinding="PA_IGNORE@paResourceBundle"
                                    disabledBinding="ignoreDisabled@selectedStep@deploymentBean@servletRequest"
                                    renderedBinding="hasJobs@selectedStep@deploymentBean@servletRequest"
                                    unvalidated="true"/>
                  <%-- Retry a failed job (only on the steps) --%>
                  <uix:submitButton textBinding="PA_RETRY_BTN@paResourceBundle"
                                    name="event"
                                    valueBinding="PA_RETRY@paResourceBundle"
                                    disabledBinding="retryDisabled@selectedStep@deploymentBean@servletRequest"
                                    renderedBinding="hasJobs@selectedStep@deploymentBean@servletRequest"/>
                  <%-- Confirm a manual step on a particular target --%>
                  <uix:submitButton textBinding="PA_CONFIRM_BTN@paResourceBundle"
                                    name="event"
                                    valueBinding="PA_CONFIRM@paResourceBundle"
                                    disabledBinding="confirmDisabled@selectedStep@deploymentBean@servletRequest"
                                    renderedBinding="hasInstruction@selectedStep@deploymentBean@servletRequest"/>
                </uix:contents>
              </uix:multipleSelection>
            </uix:tableSelection>
          </uix:hGrid>
        </uix:contents>
      </uix:header>
      <uix:rowLayout width="100%">
        <uix:spacer width="10" height="10"/>
      </uix:rowLayout>
      <uix:rowLayout width="100%">
        <uix:contents>
          <uix:cellFormat hAlign="right">
            <%-- Buttons for page events (located on top right side) --%>
            <uix:include node="pageButtons.jsp"/>
          </uix:cellFormat>
        </uix:contents>
      </uix:rowLayout>
  	</uix:contents>
  </uix:header>
</uix:buildTree>

<%@ include file="templateBase.jspf" %>
