 <%--
 * Copyright (c) 2001, 2007, Oracle. All rights reserved.  
 *
 *      NAME
 *       provisioningAdvisor.jsp
 *
 *      NOTES
 *       Home Page for Provisioning Advisor Framework (showing deployment procedures)
 *
 * MODIFIED  (MM/DD/YY)  VERSION
 *  ptorreti  05/17/07 - XbranchMerge ptorreti_bug-5988207 from
 *                       st_empp_10.2.0.3.1db11
 *  ktamtoro  01/09/06 - XbranchMerge ktamtoro_ui_bugs_4925024_4925037_4927434 
 *                       from main 
 *  ktamtoro  12/30/05 - XbranchMerge ktamtoro_resource_translation from main 
 *  ktamtoro  12/28/05 - XbranchMerge ktamtoro_paf_exit_review_fix from main 
 *  ktamtoro  12/20/05 - XbranchMerge ktamtoro_paf_ui_fixes_2 from main 
 *  ktamtoro  12/13/05 - XbranchMerge ktamtoro_upload_script from main 
 *  ktamtoro  12/28/05 - XbranchMerge ktamtoro_paf_exit_review_fix from main 
 *  ktamtoro  12/20/05 - XbranchMerge ktamtoro_paf_ui_fixes_2 from main 
 *  ktamtoro  12/13/05 - XbranchMerge ktamtoro_upload_script from main 
 *  ktamtoro  12/12/05 -
 *  rahgupta  11/17/05 - remove test button
 *  ktamtoro  08/15/05 -
 *  clo       08/15/05 - show version
 *  ktamtoro  08/11/05 - Fix column widths and no wrap
 *  sonorato  08/09/05 -
 *  ktamtoro  08/10/05 - Add revert button
 *  sonorato  08/08/05 -
 *  ktamtoro  08/02/05 -
 *  clo       07/30/05 - Enable filters; dynamically create type list
 *  ktamtoro  07/29/05 -
 *  ktamtoro  07/26/05 -
 *  ktamtoro  07/22/05 -
 *  clo       07/13/05 - Modifying UI text
 *  ktamtoro  06/21/05 - Move Instances table to instances.jsp
 *  ktamtoro  06/16/05 - Change JSP to using oracle.sysman.pp.paf.*
 *  ktamtoro  06/08/05 - ktamtoro_empp_paf_ui
 *  ktamtoro  04/15/05 - created
 *
--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:buildTree nodeID="mainPageContent" scope="request">
  <%-- Procedures table --%>
  <uix:table id="procTable"
             nameBinding="PA_PROCEDURE_TABLE@paResourceBundle"
             alternateTextBinding="PA_TABLE_NO_ITEMS_FOUND@paResourceBundle"
             width="100%"
             blockSizeBinding="blockSize@procTable@servletRequest"
             maxValueBinding="maxValue@procTable@servletRequest"
             minValueBinding="minValue@procTable@servletRequest"
             valueBinding="currentValue@procTable@servletRequest"
             partialRenderMode="self"
             showAll="yes"
             formSubmitted="true"
             tableDataBinding="displayedTableData@procTable@servletRequest">
    <uix:contents>
      <%@ include file="proceduresTableColumns.jspf" %>
    </uix:contents>
    <uix:tableSelection>
      <uix:singleSelection selectedIndexBinding="procSelectedIndex@servletRequest"
                           primaryClientActionBinding="procClientAction@servletRequest">
        <uix:contents>
          <%-- View a procedure --%>
          <uix:submitButton textBinding="PA_VIEW_BTN@paResourceBundle"
                            name="event"
                            valueBinding="PA_VIEW_PROCEDURE@paResourceBundle"
                            disabledBinding="viewDisabled@servletRequest"
                            shortDescBinding="PA_VIEW_BTN_TIP@paResourceBundle"
                            id="viewBtn"/>
          <%-- Run a procedure --%>
          <uix:submitButton textBinding="PA_RUN_BTN@paResourceBundle"
                            name="event"
                            valueBinding="PA_RUN_PROCEDURE@paResourceBundle"
                            disabledBinding="runDisabled@servletRequest"
                            shortDescBinding="PA_RUN_BTN_TIP@paResourceBundle"
                            id="runBtn"/>
          <%-- Edit a procedure --%>
          <uix:submitButton textBinding="PA_EDIT_BTN@paResourceBundle"
                            name="event"
                            valueBinding="PA_EDIT_PROCEDURE@paResourceBundle"
                            disabledBinding="editDisabled@servletRequest"
                            shortDescBinding="editShortDesc@servletRequest"
                            id="editBtn"/>
          <%-- Create like a procedure --%>
          <uix:submitButton textBinding="PA_CREATE_LIKE_BTN@paResourceBundle"
                            name="event"
                            valueBinding="PA_CREATE_LIKE_PROCEDURE@paResourceBundle"
                            disabledBinding="createLikeDisabled@servletRequest"
                            shortDescBinding="PA_CREATE_LIKE_BTN_TIP@paResourceBundle"
                            id="createLike"/>
          <%-- Revert a procedure to a previous version --%>
          <uix:submitButton textBinding="PA_REVERT_BTN@paResourceBundle"
                            name="event"
                            valueBinding="PA_REVERT@paResourceBundle"
                            disabledBinding="revertProcedureDisabled@servletRequest"
                            shortDescBinding="revertProcedureShortDesc@servletRequest"
                            id="revert"/>
          <%-- Delete a custom procedure --%>
          <uix:submitButton textBinding="PA_DELETE_PROCEDURE_BTN@paResourceBundle"
                            name="event"
                            valueBinding="PA_DELETE_PROCEDURE@paResourceBundle"
                            disabledBinding="deleteProcedureDisabled@servletRequest"
                            shortDescBinding="deleteProcedureShortDesc@servletRequest"
                            id="deleteProcedure"/>
          <%-- test button --%>
          <%-- uix:submitButton text="test"
                            name="event"
                            value="test"
                            id="test"/--%>
        </uix:contents>
      </uix:singleSelection>
    </uix:tableSelection>
    <uix:tableActions>
      <uix:flowLayout renderedBinding="tableActionRendered@servletRequest">
        <uix:contents>
          <uix:submitButton textBinding="PA_ADMIN_UPLOAD_BTN@paResourceBundle"
                            name="event"
                            valueBinding="PA_ADMIN_UPLOAD@paResourceBundle"
                            shortDescBinding="PA_ADMIN_UPLOAD_BTN_TIP@paResourceBundle"
                            renderedBinding="uploadBtnRendered@servletRequest"/>
        </uix:contents>
      </uix:flowLayout>
    </uix:tableActions>
  </uix:table>
</uix:buildTree>

<%@ include file="templateMainPage.jspf" %>
