<%--
 * Copyright (c) 2001, 2006, Oracle. All rights reserved.  
 *
 *      NAME
 *       recycleBin.jsp
 *
 *      NOTES
 *       Home Page for Provisioning Advisor Framework
 *       (showing deleted procedures and instances)
 *
 * MODIFIED  (MM/DD/YY)  VERSION
 *  ktamtoro  01/09/06 - XbranchMerge ktamtoro_ui_bugs_4925024_4925037_4927434 
 *                       from main 
 *  ktamtoro  12/30/05 - XbranchMerge ktamtoro_resource_translation from main 
 *  ktamtoro  12/28/05 - XbranchMerge ktamtoro_paf_exit_review_fix from main 
 *  ktamtoro  12/13/05 - XbranchMerge ktamtoro_upload_script from main 
 *  ktamtoro  12/11/05 - Change delete to empty and purge all to empty all
 *  sonorato  08/18/05 -
 *  ktamtoro  08/17/05 - ktamtoro_paf_ui_050815
 *  ktamtoro  08/16/05 - created
 *
--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:buildTree nodeID="mainPageContent" scope="request">
  <uix:spacer height="10" width="10"/>
  <%-- Recycle Bin table --%>
  <uix:table id="recycleBinTable"
             nameBinding="PA_RECYCLE_BIN_TABLE@paResourceBundle"
             alternateTextBinding="PA_TABLE_NO_ITEMS_FOUND@paResourceBundle"
             blockSizeBinding="blockSize@recycleBinTable@servletRequest"
             maxValueBinding="maxValue@recycleBinTable@servletRequest"
             minValueBinding="minValue@recycleBinTable@servletRequest"
             valueBinding="currentValue@recycleBinTable@servletRequest"
             tableDataBinding="displayedTableData@recycleBinTable@servletRequest"
             partialRenderMode="self"
             showAll="yes"
             formSubmitted="true"
             width="100%">
    <uix:contents>
<%@ page import="oracle.sysman.pp.paf.ui.PAConstants" %>
<%
String viewChoice = (String)request.getAttribute (PAConstants.DELETED_VIEW_TYPE_CHOICE);
if ((viewChoice == null) || (viewChoice.equals(PAConstants.DELETED_VIEW_PROCEDURES_VALUE)))
{
%>
      <%@ include file="proceduresTableColumns.jspf" %>
<%
}
else
{
%>
      <%@ include file="instancesTableColumns.jspf" %>
<%
}
%>


    </uix:contents>
    <uix:tableSelection>
      <uix:multipleSelection disabledBinding="disabled"
                             selectionBinding="selected">
        <uix:contents>
          <%-- Restore a deleted procedure/instance --%>
          <uix:submitButton textBinding="PA_RESTORE_BTN@paResourceBundle"
                            name="event"
                            valueBinding="PA_RESTORE@paResourceBundle"
                            disabledBinding="restoreBtnDisabled@servletRequest"
                            renderedBinding="restoreBtnRendered@servletRequest"
                            shortDescBinding="restoreBtnShortDesc@servletRequest"/>
          <%-- Delete a procedure/instance permanently --%>
          <uix:submitButton textBinding="PA_EMPTY_BTN@paResourceBundle"
                            name="event"
                            valueBinding="PA_DELETE@paResourceBundle"
                            disabledBinding="deleteBtnDisabled@servletRequest"
                            renderedBinding="deleteBtnRendered@servletRequest"
                            shortDescBinding="deleteBtnShortDesc@servletRequest"/>
          <%-- Purge all deleted procedures/instances --%>
          <uix:submitButton textBinding="PA_PURGE_ALL_BTN@paResourceBundle"
                            name="event"
                            valueBinding="PA_PURGE_ALL@paResourceBundle"
                            disabledBinding="purgeAllBtnDisabled@servletRequest"
                            renderedBinding="purgeAllBtnRendered@servletRequest"
                            shortDescBinding="purgeAllBtnShortDesc@servletRequest"/>
        </uix:contents>
      </uix:multipleSelection>
    </uix:tableSelection>
  </uix:table>
</uix:buildTree>

<%@ include file="templateMainPage.jspf" %>
