<%--
 * Copyright (c) 2001, 2006, Oracle. All rights reserved.
 *
 *      NAME
 *       retryStep.jsp
 *
 *      NOTES
 *       Page to retry a failed step with different parameters.
 *
 * MODIFIED  (MM/DD/YY)  VERSION
 *  ktamtoro  07/31/06 - Retry step with different params
 *  ktamtoro  07/31/06 - created
 *
--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:buildTree nodeID="baseContent" scope="request">
  <uix:header textBinding="PA_STATUS_RETRY_STEP_HDR@paResourceBundle">
  	<uix:contents>
			<uix:rowLayout width="100%">
				<uix:contents>
					<uix:cellFormat hAlign="right">
            <%-- Buttons for page events (located on top right side) --%>
            <uix:include node="pageButtons.jsp"/>
          </uix:cellFormat>
        </uix:contents>
			</uix:rowLayout>
      <uix:spacer height="10" width="10"/>

			<%-- Step General Information --%>
			<uix:header textBinding="PA_STATUS_GENERAL_INFO_HDR@paResourceBundle">
				<uix:contents>
          <uix:spacer height="10" width="10"/>
          <%-- Instance GUID --%>
          <uix:formValue nameBinding="PA_INSTANCE_GUID_FORM_VALUE@paResourceBundle"
                         valueBinding="instanceGUID@deploymentBean@servletRequest"/>
          <%-- Step GUID --%>
          <uix:formValue nameBinding="PA_GUID_FORM_VALUE@paResourceBundle"
                         valueBinding="stepGUID@selectedStep@deploymentBean@servletRequest"/>
          <uix:labeledFieldLayout width="450" columns="1">
            <uix:contents>
              <%-- Step Name --%>
              <uix:messageStyledText promptBinding="PA_INFO_STEP_NAME_PROMPT@paResourceBundle"
              											 textBinding="translatedStepName@selectedStep@deploymentBean@servletRequest"
              											 styleClass="OraDataText"/>
              <%-- Step Type --%>
              <uix:messageStyledText promptBinding="PA_INFO_STEP_TYPE_PROMPT@paResourceBundle"
              											 textBinding="(stepTypeString@selectedStep@deploymentBean@servletRequest)@paResourceBundle"
              											 styleClass="OraDataText"/>
              <%-- Step Decription --%>
              <uix:messageStyledText promptBinding="PA_INFO_STEP_DESCRIPTION_PROMPT@paResourceBundle"
              											 textBinding="translatedDescription@selectedStep@deploymentBean@servletRequest"
              											 styleClass="OraDataText"/>
              <%-- Error Handling Mode --%>
              <uix:messageStyledText promptBinding="PA_INFO_ERROR_HANDLING_PROMPT@paResourceBundle"
              											 textBinding="errorHandlingModeString@selectedStep@deploymentBean@servletRequest"
              											 renderedBinding="errorHandlingModeRendered@selectedStep@deploymentBean@servletRequest"
              											 styleClass="OraDataText"/>
              <%-- The instance the step belongs to --%>
              <uix:messageStyledText promptBinding="PA_INFO_INSTANCE_NAME_PROMPT@paResourceBundle"
              											 textBinding="translatedInstanceName@deploymentBean@servletRequest"
              											 destinationBinding="instanceDestinationURL@deploymentBean@servletRequest"
              											 styleClass="OraLinkText"/>
              <%-- Step Status --%>
              <uix:messageStyledText promptBinding="PA_INFO_STATUS_PROMPT@paResourceBundle"
              											 textBinding="statusString@selectedStep@deploymentBean@servletRequest"
              											 destinationBinding="headerStatusDestinationURL@selectedStep@deploymentBean@servletRequest"
              											 styleClass="OraDataText"/>
              <%-- Date and time the step is executed --%>
              <uix:messageStyledText promptBinding="PA_INFO_START_DATE_PROMPT@paResourceBundle"
              											 textBinding="dateStartedString@selectedStep@deploymentBean@servletRequest"
              											 styleClass="OraDataText"/>
              <%-- Date and time the step execution is completed --%>
              <uix:messageStyledText promptBinding="PA_INFO_COMPLETED_DATE_PROMPT@paResourceBundle"
              											 textBinding="dateCompletedString@selectedStep@deploymentBean@servletRequest"
              											 styleClass="OraDataText"/>
              <uix:spacer height="10" width="10"/>
            </uix:contents>
          </uix:labeledFieldLayout>
        </uix:contents>
      </uix:header>
      <uix:spacer height="10" width="10"/>

			<%-- Parameter Tree --%>
			<uix:header textBinding="PA_STATUS_RETRY_PARAMS_HDR@paResourceBundle">
				<uix:contents>
          <uix:hGrid alternateTextBinding="PA_TABLE_NO_ITEMS_FOUND@paResourceBundle"
                     id="paramHGrid"
                     formSubmitted="true"
                     partialRenderMode="self"
                     proxyBinding="proxy@proxyBean@servletRequest"
                     treeDataBinding="parameterTree@servletRequest"
                     width="100%">
            <%-- hGrid columns --%>
            <uix:nodeStamp>
              <%-- param name column --%>
              <uix:column renderedBinding="paramNameColumn@servletRequest">
                <uix:columnHeader>
                  <uix:styledText textBinding="PA_STEP_PARAM_NAME_CH@paResourceBundle"/>
                </uix:columnHeader>
                <uix:columnFormat width="30%" cellNoWrapFormat="false"/>
                <uix:contents>
                  <uix:styledText textBinding="paramName"/>
                </uix:contents>
              </uix:column>
            </uix:nodeStamp>
            <uix:contents>
              <%-- save the parameter name  --%>
              <uix:formValue name="paramName"
                             valueBinding="paramName"/>
              <%-- save the state GUID --%>
              <uix:formValue nameBinding="PA_STATE_GUID_FORM_VALUE@paResourceBundle"
                             valueBinding="stateGUID"/>
              <%-- save the parameter ID (stateGUID + paramName) --%>
              <uix:formValue name="paramID"
                             valueBinding="paramID"/>
              <%-- param description column
              <uix:column renderedBinding="paramDescColumn@servletRequest">
                <uix:columnHeader>
                  <uix:styledText textBinding="PA_STEP_PARAM_DESC_CH@paResourceBundle"/>
                </uix:columnHeader>
                <uix:columnFormat width="25%" cellNoWrapFormat="false"/>
                <uix:contents>
                  <uix:styledText textBinding="paramDescription"/>
                </uix:contents>
              </uix:column>
              --%>
              <%-- parameter value --%>
              <uix:column renderedBinding="paramValueColumn@servletRequest">
                <uix:columnHeader>
                  <uix:styledText textBinding="PA_STEP_PARAM_VALUE_CH@paResourceBundle"/>
                </uix:columnHeader>
                <uix:columnFormat width="70%" cellNoWrapFormat="false"/>
                <uix:contents>
                  <uix:textInput nameBinding="paramID"
                                 textBinding="paramValue"
                                 renderedBinding="valueInputRendered"
                                 secretBinding="paramSecret"
                                 columns="70"/>
                </uix:contents>
              </uix:column>
            </uix:contents>
          </uix:hGrid>
        </uix:contents>
      </uix:header>
      <uix:spacer height="10" width="10"/>

      <uix:rowLayout width="100%">
        <uix:spacer width="10" height="10"/>
      </uix:rowLayout>

      <uix:rowLayout width="100%">
        <uix:contents>
          <uix:cellFormat hAlign="right">
            <%-- Buttons for page events (located on top right side) --%>
            <uix:include node="pageButtons.jsp"/>
          </uix:cellFormat>
        </uix:contents>
      </uix:rowLayout>
		</uix:contents>
  </uix:header>
</uix:buildTree>

<%@ include file="templateBase.jspf" %>
