<!---->
<%--
  - FILE
  -  review.jsp
  -
  - DESCRIPTION
  -
  - MODIFIED   (MM/DD/YY)
  -    anurao   07/23/07 - Adding help text for each field
  -    anurao   04/20/07 - 
  -    vseethar 11/28/05 - 
  -
  - SINCE
  -  10.2.4.0
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ include file="/oemNoscript.jspf" %>

<%--All page contents should be within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">

  <uix:dataScope currentDataBinding="pageData@servletRequest">
    <uix:document>
	<uix:stackLayout>
        <uix:spacer height="5" width="5"/>
      <uix:styledText textBinding="ADV_CONF_INST_TEXT@racProvisioningRB" styleClass="OraInstructionText"/>
    </uix:stackLayout> 
      <uix:rowLayout >
          <uix:cellFormat height="10">
            <uix:text text=" "/>
          </uix:cellFormat>
        </uix:rowLayout>
      <uix:header textBinding="HDR_BOND_INTF@racProvisioningRB">
        <uix:stackLayout>
        <uix:styledText textBinding="BOND_INTF_INST_TEXT@racProvisioningRB" styleClass="OraInstructionText"/>
        <uix:rowLayout >
          <uix:cellFormat height="15">
            <uix:text text=" "/>
          </uix:cellFormat>
        </uix:rowLayout>
        <uix:messageCheckBox
                        name="bondInterfaceChkBox"
                        id="bondInterfaceChkBox"
                        checkedBinding="enableBondingIntf@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
                        primaryClientActionBinding="bondingIntfClickedEvent@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
                        textBinding="LBL_CONF_BOND_INTF@racProvisioningRB"/>
                <uix:spacer width="18" height="2" />
        </uix:stackLayout>
        <%--Introduce some space--%>
        <uix:rowLayout >
          <uix:cellFormat height="15">
            <uix:text text=" "/>
          </uix:cellFormat>
        </uix:rowLayout>
        <uix:tableLayout>
        <uix:messageTextInput 
        		  promptBinding="LBL_BONDING_DEVICE_NAME@racProvisioningRB"
                  id="bondingDevName"
                  name="bondingDevName"
                  required="uiOnly"
                  textBinding="bondingDevName@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
                  disabledBinding="bondingDisabled@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
		  tipBinding="BONDING_DEVICE_NAME_DESC@racProvisioningRB"
                  rendered="true"/>
        <uix:rowLayout >
          <uix:cellFormat height="5">
            <uix:text text=" "/>
          </uix:cellFormat>
        </uix:rowLayout>
        <uix:messageTextInput 
        		  promptBinding="LBL_SUBNET_MASK@racProvisioningRB"
                  id="subnetMask"
                  name="subnetMask"
                  required="uiOnly"
                  textBinding="subnetMask@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
                  disabledBinding="bondingDisabled@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
		  tipBinding="SUBNET_MASK_DESC@racProvisioningRB"
                  rendered="true"/>
        <uix:rowLayout >
          <uix:cellFormat height="5">
            <uix:text text=" "/>
          </uix:cellFormat>
        </uix:rowLayout>
        <uix:messageTextInput 
        		  promptBinding="LBL_DEFAULT_GATEWAY@racProvisioningRB"
                  id="defaultGateway"
                  name="defaultGateway"
                  textBinding="defaultGateway@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
                  disabledBinding="bondingDisabled@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
		  tipBinding="DEFAULT_GATEWAY_DESC@racProvisioningRB"
                  rendered="true"/>
        <uix:rowLayout >
          <uix:cellFormat height="5">
            <uix:text text=" "/>
          </uix:cellFormat>
        </uix:rowLayout>
        <uix:messageTextInput 
        		  promptBinding="LBL_DNS_SERVERS@racProvisioningRB"
                  id="dnsServers"
                  name="dnsServers"
                  textBinding="dnsServers@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
                  disabledBinding="bondingDisabled@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
		  tipBinding="DNS_SERVERS_DESC@racProvisioningRB"
                  rendered="true"/>
        <uix:rowLayout >
          <uix:cellFormat height="5">
            <uix:text text=" "/>
          </uix:cellFormat>
        </uix:rowLayout>
        <uix:messageTextInput 
        		  promptBinding="LBL_SLAVE_DEV_LIST@racProvisioningRB"
                  id="slaveDevList"
                  name="slaveDevList"
                  required="uiOnly"
                  textBinding="slaveDevList@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
                  disabledBinding="bondingDisabled@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
		  tipBinding="SLAVE_DEVICES_LIST_DESC@racProvisioningRB"
                  rendered="true"/>
        <uix:rowLayout >
          <uix:cellFormat height="5">
            <uix:text text=" "/>
          </uix:cellFormat>
        </uix:rowLayout>
        <uix:messageTextInput 
        		  promptBinding="LBL_BONDING_MODE@racProvisioningRB"
                  id="bondingMode"
                  name="bondingMode"
                  required="uiOnly"
                  textBinding="bondingMode@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
                  disabledBinding="bondingDisabled@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
		  tipBinding="BONDING_MODE_DESC@racProvisioningRB"
                  rendered="true"/>
        <uix:rowLayout >
          <uix:cellFormat height="5">
            <uix:text text=" "/>
          </uix:cellFormat>
        </uix:rowLayout>
        <uix:messageTextInput 
        		  promptBinding="LBL_DOMAIN_NAME@racProvisioningRB"
                  id="domainName"
                  name="domainName"
                  textBinding="domainName@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
                  disabledBinding="bondingDisabled@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
		  tipBinding="DOMAIN_NAME_DESC@racProvisioningRB"
                  rendered="true"/>
                  </uix:tableLayout>
        <uix:rowLayout >
          <uix:cellFormat height="5">
            <uix:text text=" "/>
          </uix:cellFormat>
        </uix:rowLayout>
        <uix:header textBinding="LBL_ADD_BOND_INTF@racProvisioningRB">
        <uix:labeledFieldLayout labelWidth="0%" fieldWidth="100%">
        <uix:rowLayout >
          <uix:cellFormat height="5">
            <uix:text text=" "/>
          </uix:cellFormat>
        </uix:rowLayout>
        <uix:messageTextInput 
        		  promptBinding="LBL_PRIMARY_SLAVE_DEV@racProvisioningRB"
                  id="primarySlaveDev"
                  name="primarySlaveDev"
                  required="uiOnly"
                  textBinding="primarySlaveDev@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
                  disabledBinding="bondingDisabled@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
		  tipBinding="PRIMARY_SLAVE_DEVICE_DESC@racProvisioningRB"
                  rendered="true"/>
        <uix:rowLayout >
          <uix:cellFormat height="5">
            <uix:text text=" "/>
          </uix:cellFormat>
        </uix:rowLayout>
        <uix:messageTextInput 
        		  promptBinding="LBL_ARP_INTERVAL@racProvisioningRB"
                  id="arpInterval"
                  name="arpInterval"
                  required="uiOnly"
                  textBinding="arpInterval@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
                  disabledBinding="bondingDisabled@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
		  tipBinding="ARP_INTERVAL_DESC@racProvisioningRB"
                  rendered="true"/>
        <uix:rowLayout >
          <uix:cellFormat height="5">
            <uix:text text=" "/>
          </uix:cellFormat>
        </uix:rowLayout>
        <uix:messageTextInput 
        		  promptBinding="LBL_ARP_IP_TARGETS@racProvisioningRB"
                  id="arpIpTargets"
                  name="arpIpTargets"
                  required="uiOnly"
                  textBinding="arpIpTargets@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
                  disabledBinding="bondingDisabled@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
		  tipBinding="ARP_IP_TARGET_DESC@racProvisioningRB"
                  rendered="true"/>
        <uix:rowLayout >
          <uix:cellFormat height="5">
            <uix:text text=" "/>
          </uix:cellFormat>
        </uix:rowLayout>
        <uix:messageTextInput 
        		  promptBinding="LBL_MII_INTERVAL@racProvisioningRB"
                  id="miiInterval"
                  name="miiInterval"
                  required="uiOnly"
                  textBinding="miiInterval@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
                  disabledBinding="bondingDisabled@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
		  tipBinding="MII_INTERVAL_DESC@racProvisioningRB"
                  rendered="true"/>
        <uix:rowLayout >
          <uix:cellFormat height="5">
            <uix:text text=" "/>
          </uix:cellFormat>
        </uix:rowLayout>
        <uix:messageTextInput 
        		  promptBinding="LBL_MII_INTERVAL_DOWN_DELAY@racProvisioningRB"
                  id="miiIntervalDownDelay"
                  name="miiIntervalDownDelay"
                  required="uiOnly"
                  textBinding="miiIntervalDownDelay@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
                  disabledBinding="bondingDisabled@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
		  tipBinding="MII_INTERVALS_DOWN_DELAY_DESC@racProvisioningRB"
                  rendered="true"/>
        <uix:rowLayout >
          <uix:cellFormat height="5">
            <uix:text text=" "/>
          </uix:cellFormat>
        </uix:rowLayout>
        <uix:messageTextInput 
        		  promptBinding="LBL_MII_INTERVAL_UP_DELAY@racProvisioningRB"
                  id="miiIntervalUpDelay"
                  name="miiIntervalUpDelay"
                  required="uiOnly"
                  textBinding="miiIntervalUpDelay@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
                  disabledBinding="bondingDisabled@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
		  tipBinding="MII_INTERVALS_UP_DELAY_DESC@racProvisioningRB"
                  rendered="true"/>
        <uix:rowLayout >
          <uix:cellFormat height="5">
            <uix:text text=" "/>
          </uix:cellFormat>
        </uix:rowLayout>
        <uix:messageTextInput 
        		  promptBinding="LBL_NTP_SERVER@racProvisioningRB"
                  id="ntpServer"
                  name="ntpServer"
                  textBinding="ntpServer@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
                  disabledBinding="bondingDisabled@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
		  tipBinding="NTP_SERVER_DESC@racProvisioningRB"
                  rendered="true"/>
        </uix:labeledFieldLayout> 
        </uix:header>
                 
        </uix:header>
        
        <uix:header textBinding="LBL_SYSCTL_CONF@racProvisioningRB">
        <uix:stackLayout>
        <uix:styledText textBinding="LBL_SYSCTL_INST_TEXT@racProvisioningRB" styleClass="OraInstructionText"/>
        <uix:rowLayout >
          <uix:cellFormat height="15">
            <uix:text text=" "/>
          </uix:cellFormat>
        </uix:rowLayout>
        <uix:messageCheckBox
                        id="sysctlChkBox"
                        name="sysctlChkBox"
                        checkedBinding="enableSysctl@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
                        primaryClientActionBinding="sysctlClickedEvent@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
                        textBinding="LBL_CONF_SYSCTL@racProvisioningRB"/>
        <uix:rowLayout >
          <uix:cellFormat height="15">
            <uix:text text=" "/>
          </uix:cellFormat>
        </uix:rowLayout>
        </uix:stackLayout>
		<uix:labeledFieldLayout labelWidth="0%" fieldWidth="100%">
        <uix:messageChoice
            id="sysctlMode" 
            name="sysctlMode" 
            disabledBinding="sysctlDisabled@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
		  tipBinding="MODE_DESC@racProvisioningRB"
            selectedValueBinding="sysctlMode@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
            promptBinding="LBL_MODE@racProvisioningRB">
            <uix:option text="append" value="append"/>
            <uix:option text="replace" value="replace"/>
            <uix:option text="edit" value="edit"/>
        </uix:messageChoice>
        <uix:rowLayout >
          <uix:cellFormat height="5">
            <uix:text text=" "/>
          </uix:cellFormat>
        </uix:rowLayout>
        <uix:messageTextInput 
        		  promptBinding="LBL_REFERENCE_FILE@racProvisioningRB"
                  id="refFile"
                  name="refFile"
		          textBinding="referenceFile@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
                  disabledBinding="sysctlDisabled@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
		  tipBinding="REFERENCE_FILE_DESC@racProvisioningRB"
                  rendered="true"/>
        </uix:labeledFieldLayout>
        </uix:header>
        	
        <uix:rowLayout>
          <uix:spacer height="20" width="20"/>
          <uix:styledText styleClass="oraInstructionText" textBinding="TXT_LIB_STEP_SKIP@racProvisioningRB"/>
        </uix:rowLayout>
        
        
    </uix:document>

  </uix:dataScope>

</uix:buildTree>



<%@ include file="wizTemplate.jspf" %>

