<!---->
<%--
  - FILE
  -   CcfUpload.jsp
  -
  - DESCRIPTION
   -
  - MODIFIED   (MM/DD/YY)
  -   suravind   02/23/06  - Sample CCF link replacement 
  -   suravind   02/02/06  - CCF Upload page 
  -   suravind   01/06/06  - created
--%>

<%@ page contentType="text/html; charset=UTF-8" %>

<%--uix Tag Library--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder  id="renderingContext"/>

  <%--Common UI messages --%>
  <uix:bundle
    name="sdkUIMsg"
    class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <%--ResourceBundle for common labels/headers etc--%>
  <uix:bundle
    name="commonResourceBundle"
    class="oracle.sysman.resources.CommonResourceBundle"/>

  <%--ResourceBundle for labels/headers specific to Patch Advisor Project--%>
  <uix:bundle
    name="racProvisioningRB"
    class="oracle.sysman.pp.racprov.ui.rb.RacProvisioningRB"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:form
        name="pageForm"
        usesUpload="true"
        method="post">

        <uix:pageLayout titleBinding="HDR_CCF@racProvisioningRB">

          <%--To display the cancel and select buttons--%>
          <uix:pageButtons>
            <uix:pageButtonBar>

              <%--Cancel button--%>
              <uix:submitButton
                textBinding="CANCEL@sdkUIMsg"
                shortDescBinding="CANCEL@sdkUIMsg"
                name="event"
                value="cancel">
              </uix:submitButton>

              <%--Select Button--%>
              <uix:submitButton
                textBinding="OK@commonResourceBundle"
                name="event"
                value="uploadCCF">
              </uix:submitButton>

            </uix:pageButtonBar>
          </uix:pageButtons>

          <%-- The message box to show error/info messge etc--%>
          <uix:messageBox 
            messageTypeBinding="msgType@msgInfo@servletRequest"
            messageBinding="msg@msgInfo@servletRequest"
            rendered="false"
            renderedBinding="rendered@msgInfo@servletRequest">
          </uix:messageBox>

         <uix:rowLayout>
            <uix:messageFileUpload
                 promptBinding="LBL_CCF_NAME@racProvisioningRB"
                 tipBinding="DESC_BROWSE@racProvisioningRB"
                 name="file" />
         </uix:rowLayout>
         <uix:rowLayout>
            <uix:spacer width="20" height="10" />
         </uix:rowLayout>
         <uix:rowLayout>
            <uix:styledText
              textBinding="LBL_CCF_TEXT@racProvisioningRB"
              styleClass="OraPromptText"/>
         </uix:rowLayout>
         <uix:spacer height="10"/>
         <uix:rowLayout>
            <uix:styledText textBinding="LBL_CCF_LINK@racProvisioningRB"
                 styleClass="OraPromptText"/>
         </uix:rowLayout>
         <uix:spacer height="10"/>
         <uix:rowLayout>
            <uix:styledText text="# Cluster Configuration file"
                 styleClass="OraPromptText"/>
         </uix:rowLayout>
         <uix:rowLayout>
            <uix:styledText text="# Node information"
                 styleClass="OraPromptText"/>
         </uix:rowLayout>
<%--         <uix:rowLayout>
            <uix:rawText text="# Public Node Name Private Node Name Private IP Virtual Host Name Virtual IP"
                 styleClass="OraPromptText"/>
         </uix:rowLayout>
         <uix:rowLayout>
            <uix:rawText text="&nbsp;staju05&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;staju05int&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;10.1.0.0&nbsp;&nbsp;&nbsp;staju05v&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;-"
                 styleClass="OraPromptText"/>
         </uix:rowLayout> --%>
         <uix:tableLayout>
           <uix:rowLayout>
             <uix:styledText text="# Public Node Name" styleClass="OraPromptText"/>
             <uix:spacer height="1" width="5"/>
             <uix:styledText text=" Private Node Name" styleClass="OraPromptText"/>
             <uix:spacer height="1" width="5"/>
             <uix:styledText text=" Private IP" styleClass="OraPromptText"/>
             <uix:spacer height="1" width="5"/>
             <uix:styledText text=" Virtual Host Name" styleClass="OraPromptText"/>
             <uix:spacer height="1" width="5"/>
             <uix:styledText text=" Virtual IP" styleClass="OraPromptText"/>
           </uix:rowLayout>
           <uix:rowLayout>
             <uix:styledText text=" staju05" styleClass="OraPromptText"/>
             <uix:spacer height="1" width="5"/>
             <uix:styledText text=" staju05int" styleClass="OraPromptText"/>
             <uix:spacer height="1" width="5"/>
             <uix:styledText text=" 10.1.0.0" styleClass="OraPromptText"/>
             <uix:spacer height="1" width="5"/>
             <uix:styledText text=" staju05v" styleClass="OraPromptText"/>
             <uix:spacer height="1" width="5"/>
             <uix:styledText text=" -" styleClass="OraPromptText"/>
           </uix:rowLayout>
         </uix:tableLayout>

        </uix:pageLayout>
      </uix:form>

    </uix:body>
  </uix:document>
</uix:renderingContext>
