<%--
  - FILE
  -   setCredentials.jsp
  -
  - DESCRIPTION
  -   Page to get credentials from the user.
  -
  - MODIFIED  (MM/DD/YY)
  -    anurao  08/23/06 - XbranchMerge pkithara_creds from main
  -    pkithar 08/17/06 - Adding credentials page segment
  -    suravin 03/20/06 - Windows-specific instructions 
  -    kkhanuj 02/05/06 - Added the noscript tag 
  -    kkhanuj 01/25/06 - Remove textbinding for the password fields 
  -    suravin 01/03/06 - 
  -    suravin 01/03/06 - Grace period changes 
  -    suravin 12/22/05 - 
  -    suravin 12/21/05 - Removal of repeating option from schedule 
  -    suravin 12/14/05 - 
  -    suravin 12/12/05 - Credentials and Schedule pages collapse 
  -    suravin 12/06/05 - 
  -    suravin 12/06/05 - 
  -    suravin 12/06/05 - 
  -    suravin 12/06/05 - Changes for preferred credentials enabling 
  -    vseetha 11/27/05 - 
  -
  - SINCE
  -   10.2
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%--All page contents should be within this tag--%>

<%@ include file="/oemNoscript.jspf" %>

<uix:buildTree nodeID="pageContent" scope="request">

    <uix:script text="function enableEndAfter()
      {
        if (document.forms[0].gracePeriod[1].checked == false)
        {
          document.all['gracePeriodHourInput'].value = '';
          document.all['gracePeriodMinuteInput'].value = '';

          document.all['gracePeriodHourInput'].disabled=true;
          document.all['gracePeriodMinuteInput'].disabled=true;
        }
        else
        {
          document.all['gracePeriodHourInput'].disabled=false;
          document.all['gracePeriodMinuteInput'].disabled=false;
        }
      }"/>



  <uix:dataScope currentDataBinding="pageData@servletRequest">

   <uix:header  textBinding="CREDENTIALS@racProvisioningRB">
    <uix:stackLayout>
      <uix:switcher childNameBinding="isWindows@stepsData@servletRequest" defaultCase="false">
      <uix:case name="true">
      <uix:styledText
        textBinding="SPECIFY_CREDENTIALS_TEXT_WINDOWS@racProvisioningRB"
        renderedBinding="enablePrefCred@stepsData@servletRequest"
        styleClass="oraInstructionText"/>

      <uix:spacer height="10"/>

      <uix:styledText
        textBinding="CHOOSE_CREDENTIALS_TEXT_WINDOWS@racProvisioningRB"
        renderedBinding="disablePrefCred@stepsData@servletRequest"
        styleClass="OraInstructionText"/>
      </uix:case>

      <uix:case name="false">
      <uix:styledText
        textBinding="SPECIFY_CREDENTIALS_TEXT@racProvisioningRB"
        renderedBinding="enablePrefCred@stepsData@servletRequest"
        styleClass="oraInstructionText"/>

      <uix:spacer height="10"/>

      </uix:case>
      </uix:switcher>

      <uix:spacer height="15"/>
    </uix:stackLayout>

    <uix:tableLayout width="100%" renderedBinding="showRefHostSection@CREDENTIALS_BEAN@stepsData@servletRequest">
      <uix:rowLayout >
       <uix:stackLayout> 
        <uix:styledText
         textBinding="CHOOSE_REF_HOST_CREDENTIALS_TEXT@racProvisioningRB"
         renderedBinding="disabledRefHostPrefCred@CREDENTIALS_BEAN@stepsData@servletRequest"
         styleClass="OraInstructionText"/>
        <uix:header textBinding="CRED_FOR_REF_HOST@racProvisioningRB">
          <uix:spacer height="10"/>
          <uix:ref refID="PAGE_SEGMENT_TYPE_PROV_CREDS_CREDS_REFHOST_INSTANCE"/>
       </uix:header>  
      </uix:stackLayout> 
      </uix:rowLayout>
    </uix:tableLayout>
    <uix:tableLayout width="100%">
      <uix:rowLayout>
           
        <uix:header textBinding="CRED_FOR_TARGET@racProvisioningRB">
        <uix:stackLayout>
         <uix:spacer height="5"/>
         <uix:styledText
         textBinding="CHOOSE_CREDENTIALS_TEXT@racProvisioningRB"
         renderedBinding="disabledTgtPrefCred@CREDENTIALS_BEAN@stepsData@servletRequest"
         styleClass="OraInstructionText"/> 
          <uix:spacer height="10"/>
          <uix:ref refID="PAGE_SEGMENT_TYPE_PROV_CREDS_CREDS_TARGETS_INSTANCE"/>
         </uix:stackLayout>
        </uix:header> 
      
      </uix:rowLayout>
    </uix:tableLayout>
   </uix:header>

<%-- Schedule section of the page --%>

    <uix:header textBinding="SCHEDULE_HEADER@racProvisioningRB">
      <uix:spacer height="10"/>
      <uix:tableLayout cellSpacing="4">
        <uix:rowLayout>
          <uix:cellFormat>
            <uix:messageRadioButton name="startOption" textBinding="IMMEDIATELY@scheduleResourceBundle" selectedBinding="isStartNowSelected@scheduleSegmentBean@servletRequest" renderedBinding="isStartNowRendered@scheduleSegmentBean@servletRequest" primaryClientActionBinding="startNowFireAction@scheduleSegmentBean@servletRequest" shortDescBinding="IMMEDIATELY@scheduleResourceBundle"/>
          </uix:cellFormat>
          <uix:cellFormat>
            <uix:messageRadioButton name="startOption" textBinding="LATER@scheduleResourceBundle" selectedBinding="isStartLaterSelected@scheduleSegmentBean@servletRequest" renderedBinding="isStartLaterRendered@scheduleSegmentBean@servletRequest" primaryClientActionBinding="startLaterFireAction@scheduleSegmentBean@servletRequest" shortDescBinding="LATER@scheduleResourceBundle"/>
          </uix:cellFormat>
        </uix:rowLayout>
      </uix:tableLayout>
      <uix:tableLayout cellSpacing="4">
        <uix:rowLayout>
          <uix:cellFormat width="10%"/>
          <uix:cellFormat>
            <%-- timezone --%>
            <uix:labeledFieldLayout labelWidth="30%" fieldWidth="70%">
              <uix:messageChoice
                  name="scheduleTimezoneChoice"
                  promptBinding="TIME_ZONE@scheduleResourceBundle"
                  shortDescBinding="TIME_ZONE@scheduleResourceBundle"
                  renderedBinding="isStartLaterSelected@scheduleSegmentBean@servletRequest"
                  selectedValueBinding="selectedTimeZoneSB@scheduleSegmentBean@servletRequest">
                <uix:contents childDataBinding="timezones@servletRequest">
                  <uix:option textBinding="text" valueBinding="value"/>
                </uix:contents>
              </uix:messageChoice>
              <%-- start date --%>
              <uix:messageDateField
                  id="startDate"
                  name="scheduleStartDateField"
                  valueBinding="startDate@servletRequest"
                  promptBinding="START_DATE@scheduleResourceBundle"
                  shortDescBinding="START_DATE@scheduleResourceBundle"
                  messageTypeBinding="startDateMsgType@errors@servletRequest"
                  messageBinding="startDateInlineMsg@errors@servletRequest"
                  anchorBinding="startDateAnchor@errors@servletRequest"
                  columns="12"
                  disabledBinding="readOnlyMode@servletRequest"
                  renderedBinding="isStartLaterSelected@scheduleSegmentBean@servletRequest">
                <uix:onSubmitValidater>
                  <uix:date dateStyle="medium"/>
                  <uix:date dateStyle="medium"/>
                </uix:onSubmitValidater>
              </uix:messageDateField>
              <uix:messagePrompt
                  promptBinding="START_TIME@scheduleResourceBundle"
                  renderedBinding="isStartLaterSelected@scheduleSegmentBean@servletRequest"/>
              <uix:tableLayout renderedBinding="isStartLaterSelected@scheduleSegmentBean@servletRequest">
                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:messageTextInput name="scheduleStartHourInput" columns="2" textBinding="startHour@servletRequest" shortDescBinding="HOURS@scheduleResourceBundle" disabledBinding="readOnlyMode@servletRequest" maximumLength="2" messageTypeBinding="startHourMsgType@errors@servletRequest" messageBinding="startHourInlineMsg@errors@servletRequest" anchorBinding="startHourAnchor@errors@servletRequest" vAlign="top">
                      <uix:onSubmitValidater>
                        <uix:regExp pattern="[0-9]+"/>
                      </uix:onSubmitValidater>
                      <uix:end>
                        <uix:styledText styleClass="OraInstructionText" textBinding="TIME_SEPERATOR@scheduleResourceBundle"/>
                      </uix:end>
                    </uix:messageTextInput>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:messageTextInput name="scheduleStartMinuteInput" columns="2" maximumLength="2" textBinding="startMinute@servletRequest" shortDescBinding="MINUTES@scheduleResourceBundle" disabledBinding="readOnlyMode@servletRequest" messageTypeBinding="startMinuteMsgType@errors@servletRequest" messageBinding="startMinuteInlineMsg@errors@servletRequest" anchorBinding="startMinuteAnchor@errors@servletRequest" vAlign="top">
                      <uix:onSubmitValidater>
                        <uix:regExp pattern="[0-9]+"/>
                      </uix:onSubmitValidater>
                    </uix:messageTextInput>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:messageRadioButton name="startTimeAMPM" textBinding="AM_LABEL@scheduleResourceBundle" selectedValueBinding="startAmPm@servletRequest" value="AM_VALUE" renderedBinding="isStartAMRendered@scheduleSegmentBean@servletRequest" shortDescBinding="AM_LABEL@scheduleResourceBundle"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:messageRadioButton
                        name="startTimeAMPM"
                        textBinding="PM_LABEL@scheduleResourceBundle"
                        selectedValueBinding="startAmPm@servletRequest"
                        value="PM_VALUE"
                        renderedBinding="isStartAMRendered@scheduleSegmentBean@servletRequest"
                        shortDescBinding="PM_LABEL@scheduleResourceBundle"/>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
              <uix:messagePrompt promptBinding="GRACE_PERIOD@scheduleResourceBundle"/>
              <uix:tableLayout>
                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:messageRadioButton
                        name="gracePeriod"
                        textBinding="INDEFINITE@scheduleResourceBundle"
                        selectedValueBinding="gracePeriod@servletRequest"
                        value="indef_duration"
                        onClick="javascript:enableEndAfter();"/>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
              <uix:messagePrompt prompt=""/>
              <uix:tableLayout>
                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:rowLayout>
                      <uix:cellFormat>
                        <uix:messageRadioButton
                            name="gracePeriod"
                            textBinding="END_AFTER@scheduleResourceBundle"
                            selectedValueBinding="gracePeriod@servletRequest"
                            value="interval_duration"
                            onClick="javascript:enableEndAfter();"/>
                      </uix:cellFormat>
                      <uix:cellFormat width="1"/>
                      <uix:cellFormat>
                        <uix:messageTextInput
                            name="gracePeriodHourInput"
                            columns="2"
                            textBinding="gracePeriodHourInput@servletRequest"
                            shortDescBinding="HOURS@scheduleResourceBundle"
                            maximumLength="2">
                          <uix:onSubmitValidater>
                            <uix:regExp pattern="[0-9]+"/>
                          </uix:onSubmitValidater>
                          <uix:end>
                            <uix:styledText styleClass="OraInstructionText" textBinding="HOURS@scheduleResourceBundle"/>
                          </uix:end>
                        </uix:messageTextInput>
                      </uix:cellFormat>
                      <uix:cellFormat width="1"/>
                      <uix:cellFormat>
                        <uix:messageTextInput
                            name="gracePeriodMinuteInput"
                            columns="2"
                            maximumLength="2"
                            textBinding="gracePeriodMinuteInput@servletRequest"
                            shortDescBinding="MINUTES@scheduleResourceBundle">
                          <uix:onSubmitValidater>
                            <uix:regExp pattern="[0-9]+"/>
                          </uix:onSubmitValidater>
                          <uix:end>
                            <uix:styledText styleClass="OraInstructionText" textBinding="MINUTES@scheduleResourceBundle"/>
                          </uix:end>
                        </uix:messageTextInput>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:labeledFieldLayout>
          </uix:cellFormat>
        </uix:rowLayout>
      </uix:tableLayout>
    </uix:header>





  </uix:dataScope>

</uix:buildTree>

<%@ include file="wizTemplate.jspf" %>
