
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ include file="/oemNoscript.jspf" %>

<script>

    function myCallBack(lovWindow, event)
    {
        return true;
    }

    function launchRfs()
    {
        openWindow(top, "../page/rfs/postBackWithEvent$event=handleRfsLaunch", "lovWindow", {width:750, height:550}, true, "dialog", "");
    }
	function launchCrsHomeRfs()
    {
        openWindow(top, "../page/rfs/postBackWithEvent$event=handleCrsHomeRfsLaunch", "lovWindow", {width:750, height:550}, true, "dialog", "");
    }
	function launchAsmHomeRfs()
    {
        openWindow(top, "../page/rfs/postBackWithEvent$event=handleAsmHomeRfsLaunch", "lovWindow", {width:750, height:550}, true, "dialog", "");
    }
	function launchRacHomeRfs()
    {
        openWindow(top, "../page/rfs/postBackWithEvent$event=handleRacHomeRfsLaunch", "lovWindow", {width:750, height:550}, true, "dialog", "");
    }
	function launchRacBaseRfs()
    {
        openWindow(top, "../page/rfs/postBackWithEvent$event=handleRacBaseRfsLaunch", "lovWindow", {width:750, height:550}, true, "dialog", "");
    }
	function launchAsmBaseRfs()
    {
        openWindow(top, "../page/rfs/postBackWithEvent$event=handleAsmBaseRfsLaunch", "lovWindow", {width:750, height:550}, true, "dialog", "");
    }
    function launchStorage()
    {
        openWindow(top, 'EditStorageInfo$event=editStorage', 'lovWindow', {width:750, height:550}, true, 'dialog', '');
    }

</script>


<%--All page contents should be within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">
<uix:dataScope currentDataBinding="pageData@servletRequest">


<uix:document >

<uix:switcher childNameBinding="processingComplete@stepsData@servletRequest">

<%-- display processing page only if processing incomplete --%>
<uix:case name="false">
  <uix:stackLayout>

    <uix:contents>
      <uix:spacer height="5" />
      <uix:styledText
          styleClass="OraInstructionTextStrong"
          textBinding="PROCESSING_HW_INFO_MAINMSG@racProvisioningRB" />
      <uix:spacer height="5" />
      <uix:styledText
          styleClass="OraInstructionText"
          textBinding="PROCESSING_HW_INFO_MSG@racProvisioningRB" />
      <uix:spacer height="20" />

      <uix:processing timeInterval="5000">
        <uix:contents>
          <uix:styledText
              styleClass="OraProcessingStatusFixed"
              textBinding="PROCESSING_HW_INFO_STATUS@racProvisioningRB" />
        </uix:contents>
      </uix:processing>
    
    </uix:contents>

    <uix:contents>
      <uix:spacer height="20" />
      <uix:tip>
        <uix:contents>
          <uix:styledText textBinding="NO_CANCEL_PROCESSING_TIP@racProvisioningRB" />
        </uix:contents>
      </uix:tip>
    </uix:contents>

  </uix:stackLayout>
</uix:case>

<%-- show data if not processing, or if processing state not known --%>
<uix:default>
<uix:stackLayout>
<uix:header  textBinding="HDR_USER_INPUT@racProvisioningRB">
  <uix:styledText
    textBinding="INSTR_USER_INPUT@racProvisioningRB"
    styleClass="oraInstructionText">
  </uix:styledText>

  <uix:labeledFieldLayout  width="60%" 
    labelWidth="0%"
    fieldWidth="100%"
    columns="1">
		<uix:spacer height="20" />
		<uix:messageTextInput
                        name="clusterName"
                        promptBinding="LBL_CLUSTER_NAME@racProvisioningRB"
                        textBinding="clusterName@INSTALL_INPUT_BEAN@stepsData@servletRequest"
                        tipBinding="CLUSTER_NAME_TIP@racProvisioningRB"
                        required="uiOnly"
                        maximumLength="255"/>
		<uix:spacer height="5" />
		<uix:messageLovField name="crsHomeLoc"
                        promptBinding="LBL_CRS_HOME_LOC@racProvisioningRB"
                        textBinding="crsHomeLocation@INSTALL_INPUT_BEAN@stepsData@servletRequest"
                        shortDescBinding="DESC_BROWSE@racProvisioningRB"
						messageBinding="TIP_CRS_HOME_NOT_UNDER_RAC_ASM_BASE@racProvisioningRB"
                        searchDescBinding="DESC_BROWSE@racProvisioningRB"
                        columns="30"
                        required="uiOnly"
                        onClick="launchCrsHomeRfs();" />
                <uix:messageLovField name="racBaseLoc"
                        promptBinding="LBL_DB_BASE_LOC@racProvisioningRB"
                        textBinding="racBaseLocation@INSTALL_INPUT_BEAN@stepsData@servletRequest"
                        shortDescBinding="DESC_BROWSE@racProvisioningRB"
                        searchDescBinding="DESC_BROWSE@racProvisioningRB"
                        columns="30"
                        required="uiOnly"
                        onClick="launchRacBaseRfs();" />
                <uix:messageLovField name="racHomeLoc"
                        promptBinding="LBL_DB_HOME_LOC@racProvisioningRB"
                        textBinding="oraHomeLocation@INSTALL_INPUT_BEAN@stepsData@servletRequest"
                        shortDescBinding="DESC_BROWSE@racProvisioningRB"
						messageBinding="TIP_RAC_HOME_UNDER_RAC_BASE@racProvisioningRB"
                        searchDescBinding="DESC_BROWSE@racProvisioningRB"
                        columns="30"
                        required="uiOnly"
                        onClick="launchRacHomeRfs();" />
                <uix:messageLovField name="asmBaseLoc"
                        promptBinding="LBL_ASM_BASE_LOC@racProvisioningRB"
                        textBinding="asmBaseLocation@INSTALL_INPUT_BEAN@stepsData@servletRequest"
                        renderedBinding="configureAsmHomes@INSTALL_INPUT_BEAN@stepsData@servletRequest"
                        shortDescBinding="DESC_BROWSE@racProvisioningRB"
                        searchDescBinding="DESC_BROWSE@racProvisioningRB"
                        columns="30"
                        required="uiOnly"
                        onClick="launchAsmBaseRfs();" />
                <uix:messageLovField name="asmHomeLoc"
                        promptBinding="LBL_ASM_HOME_LOC@racProvisioningRB"
                        textBinding="asmHomeLocation@INSTALL_INPUT_BEAN@stepsData@servletRequest"
                        renderedBinding="configureAsmHomes@INSTALL_INPUT_BEAN@stepsData@servletRequest"
						messageBinding="TIP_ASM_HOME_UNDER_ASM_BASE@racProvisioningRB"
                        shortDescBinding="DESC_BROWSE@racProvisioningRB"
                        searchDescBinding="DESC_BROWSE@racProvisioningRB"
                        columns="30"
                        required="uiOnly"
                        onClick="launchAsmHomeRfs();" />
				<uix:messageLovField name="scratchLocation"
                        promptBinding="LBL_SCRATCH_LOC@racProvisioningRB"
                        textBinding="scratchLocation@INSTALL_INPUT_BEAN@stepsData@servletRequest"
                        shortDescBinding="DESC_BROWSE@racProvisioningRB"
                        searchDescBinding="DESC_BROWSE@racProvisioningRB"
                        columns="30"
                        required="uiOnly"
                        onClick="launchRfs();" />
				<uix:messageTextInput
                        name="addParams"
                        promptBinding="LBL_ADDITIONAL_PARAMS@racProvisioningRB"
                        tipBinding="TIP_ADDITIONAL_PARAMS@racProvisioningRB"
                        textBinding="additionalParams@INSTALL_INPUT_BEAN@stepsData@servletRequest"/>
<%--                <uix:messageCheckBox
                        name="configIndHomes"
                        checkedBinding="configureIndHomes@INSTALL_INPUT_BEAN@stepsData@servletRequest"
                        primaryClientActionBinding="configureIndHomesClicked@INSTALL_INPUT_BEAN@stepsData@servletRequest"
                        text="Configure Individual Homes"/>--%>

  </uix:labeledFieldLayout>

  <uix:spacer height="5"/>

  <uix:rowLayout>
    <uix:contents>
        <uix:cellFormat hAlign="left" vAlign="top">
            <uix:contents>
                <uix:messageCheckBox
                        name="swonly"
                        checkedBinding="checkCreateDb@INSTALL_INPUT_BEAN@stepsData@servletRequest"
                        onClick="submitForm('testingForm',true,{'event':'createDb'})"
                        textBinding="LBL_STARTER_DB@racProvisioningRB"/>
                <uix:spacer width="18" height="2" />
            </uix:contents>
        </uix:cellFormat>
    </uix:contents>
  </uix:rowLayout>

  <uix:labeledFieldLayout  width="60%"
              labelWidth="0%"
              fieldWidth="100%"
              columns="1">
		<uix:spacer height="10"/>
                <uix:messageTextInput
                        name="gdbName"
                        disabledBinding="disableDb@INSTALL_INPUT_BEAN@stepsData@servletRequest"
			promptBinding="LBL_GDB_NAME@racProvisioningRB"
                        textBinding="gdbName@INSTALL_INPUT_BEAN@stepsData@servletRequest"
                        tipBinding="TIP_GLOBAL_DATABASE_NAME_FORMAT@racProvisioningRB"
                        required="uiOnly"
                        maximumLength="255">
                </uix:messageTextInput>
                <uix:spacer height="5"/>
                <uix:messageTextInput
                        name="dbPassword"
                        disabledBinding="disableDb@INSTALL_INPUT_BEAN@stepsData@servletRequest"
			promptBinding="PASSWORD@racProvisioningRB"
                        secret="true"
                        noAutoComplete="true"
                        required="uiOnly"
                        />
                <uix:spacer height="5"/>
                <uix:messageTextInput
                        name="confirmPassword"
                        disabledBinding="disableDb@INSTALL_INPUT_BEAN@stepsData@servletRequest"
			promptBinding="CFM_PASSWORD@racProvisioningRB"
                        secret="true"
                        noAutoComplete="true"
                        required="uiOnly"
                        messageBinding="TIP_DB_PASSWORD@racProvisioningRB"/>
  </uix:labeledFieldLayout>
</uix:header>

<%-- FOR DEVICE STORAGE --%>

<uix:header  textBinding="HDR_SHARED_STORAGE@racProvisioningRB">
<uix:styledText
            textBinding="DESC_SHARED_STORAGE@racProvisioningRB"
            styleClass="oraInstructionText">
    </uix:styledText>
    <uix:spacer height="10"/>
    <uix:rowLayout>
	<uix:spacer height="10"/>
    </uix:rowLayout>

    <uix:rowLayout>
	<uix:contents>
        <uix:switcher
          childNameBinding="dpPlatform@DEVICE_STORAGE_BEAN@stepsData@servletRequest">
        <uix:case name="windows">
        <uix:table width="90%"
                   nameBinding="tableName@DEVICE_STORAGE_BEAN@stepsData@servletRequest"
                   id="DEVICEstorage"
                   summary="DEVstorage info"
                   partialRenderMode="self"
                   formSubmitted="true"
                   tableDataBinding="rows@DEVICE_STORAGE_BEAN@stepsData@servletRequest"
                   alternateTextBinding="NO_DATA_AVAILABLE@racProvisioningRB"
                   minValueBinding="1"
                   blockSizeBinding="3"
                   maxValueBinding="6"
		   nameTransformed="false"
                   columnHeaderDataBinding="columnHeaders@DEVICE_STORAGE_BEAN@stepsData@servletRequest">

            <uix:tableFormat tableBanding="rowBanding"/>
            <%--COL HEADERS TO BE ADDED HERE>--%>
            <uix:columnHeaderStamp>
                <uix:text
                        textBinding="text"/>

            </uix:columnHeaderStamp>
	    <uix:styledText  textBinding="diskNumber"/>
		<uix:styledText  textBinding="partitionNumber"  />
	    <uix:column>
		<uix:columnFormat columnDataFormat="iconButtonFormat"/>
           <uix:contents>
			<uix:choice renderedBinding="isRendered" nameBinding="partitionComboLbl" primaryClientActionBinding="firePartialAction" selectedValueBinding="partitionLtr">
			    <uix:contents childDataBinding="partitionLtrList" >
               		<uix:option textBinding="optionTxt" valueBinding="optionTxt"/>
           	    </uix:contents>
	    	</uix:choice>
		   </uix:contents>
        </uix:column>

	    <uix:styledText  textBinding="mountFormat"  />
	    <uix:styledText  textBinding="diskStamp" renderedBinding="provAsm@SOURCE_SELECTION_BEAN@stepsData@servletRequest" />
        <uix:styledText  textBinding="mountSize"  />
	    
            <%-- uix:styledText  textBinding="driveLetter@DEVICE_STORAGE_BEAN@stepsData@servletRequest"  /--%>
	    <uix:column>
                <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                <uix:contents>
		    <uix:messageRadioButton name="ocr" valueBinding="rowNumber" selectedBinding="isOcrSelected" renderedBinding="isRendered" shortDescBinding="LBL_OCR_PRIMARY_LOC@racProvisioningRB"/>
		</uix:contents>
            </uix:column>
	    <uix:column>
                <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                <uix:contents>
            	    <uix:messageRadioButton name="ocrm" valueBinding="rowNumber" selectedBinding="isOcrmSelected" shortDescBinding="LBL_OCR_MIRROR_LOC@racProvisioningRB"/>
		</uix:contents>
            </uix:column>
	    <uix:column>
                <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                <uix:contents>
            	    <uix:messageRadioButton name="vdsk" valueBinding="rowNumber" selectedBinding="isVdskSelected" renderedBinding="isRendered" shortDescBinding="LBL_VDSK_PRIMARY_LOC@racProvisioningRB"/>
		</uix:contents>
            </uix:column>
	    <uix:column>
                <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                <uix:contents>
            	    <uix:messageRadioButton name="vdsk1" valueBinding="rowNumber" selectedBinding="isVdsk1Selected" shortDescBinding="LBL_VDSK_MIRROR_LOC1@racProvisioningRB"/>
		</uix:contents>
            </uix:column>
	    <uix:column>
                <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                <uix:contents>
            	    <uix:messageRadioButton name="vdsk2" valueBinding="rowNumber" selectedBinding="isVdsk2Selected" shortDescBinding="LBL_VDSK_MIRROR_LOC2@racProvisioningRB"/>
		</uix:contents>
            </uix:column>
	    <uix:column>
                <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                <uix:contents>
            	    <uix:messageRadioButton name="datafiles" valueBinding="rowNumber" selectedBinding="isOradataSelected" renderedBinding="isRendered" shortDescBinding="LBL_ORADATA_LOC@racProvisioningRB"/>
		</uix:contents>
            </uix:column>
        </uix:table>
        </uix:case>

        <uix:default>
        <uix:table width="100%"
                   nameBinding="tableName@DEVICE_STORAGE_BEAN@stepsData@servletRequest"
                   id="DEVICEstorage"
                   summary="DEVstorage info"
                   partialRenderMode="self"
                   formSubmitted="true"
                   tableDataBinding="rows@DEVICE_STORAGE_BEAN@stepsData@servletRequest"
                   minValueBinding="1"
                   blockSizeBinding="3"
                   maxValueBinding="6"
		   nameTransformed="false"
                   columnHeaderDataBinding="columnHeaders@DEVICE_STORAGE_BEAN@stepsData@servletRequest">

            <uix:tableFormat tableBanding="rowBanding"/>
            <uix:tableFormat tableBanding="rowBanding"/>
            
            <uix:columnHeaderStamp>
                <uix:text textBinding="text"/>
            </uix:columnHeaderStamp>
	    	<uix:switcher childNameBinding="dummy">
	    	    	<uix:case name="true">
                      <uix:rowLayout vAlign="middle">
						<uix:textInput nameBinding="partitionNameLbl" textBinding="partitionName" shortDescBinding="LBL_PARTITION_NAME@racProvisioningRB"/>
                      </uix:rowLayout>
	    	    	</uix:case>
	    	    	<uix:default>
					  <uix:styledText  textBinding="partitionName"  />
	    	    	</uix:default>
	    	    </uix:switcher>
	    	<uix:switcher childNameBinding="dummy">
            <uix:case name="true">
               <uix:rowLayout vAlign="middle">
                <uix:textInput nameBinding="mountLocationLbl" textBinding="mountLocation" shortDescBinding="LBL_MOUNT_LOC@racProvisioningRB"/>
               </uix:rowLayout>
            </uix:case>
            <uix:default>
                <uix:styledText  textBinding="mountLocation"  />
            </uix:default>
            </uix:switcher>
	    <uix:switcher childNameBinding="dummy">
            <uix:case name="true">
              <uix:rowLayout vAlign="middle">
		
                <uix:choice 
                        nameBinding="formatComboName" 
                        shortDescBinding="MOUNT_FORMAT_HEADER@racProvisioningRB"
                        selectedValueBinding="mountFormat">

                <uix:contents childDataBinding="newMntFmtList@@DEVICE_STORAGE_BEAN@stepsData@servletRequest">
                    <uix:option 
                        textBinding="optionTxt" 
                        valueBinding="optionTxt"/>
                </uix:contents>
                </uix:choice>
              </uix:rowLayout>
            </uix:case>
            <uix:default>
                <uix:styledText  textBinding="mountFormat"  />
            </uix:default>
            </uix:switcher>
	    <uix:switcher childNameBinding="dummy">
            <uix:case name="true">
		<uix:styledText text=""/>
            </uix:case>
            <uix:default>
                <uix:styledText  textBinding="mountSize"  />
            </uix:default>
            </uix:switcher>
            <uix:rowLayout hAlign="center" vAlign="middle">
	        <uix:messageRadioButton name="ocr" valueBinding="rowNumber" selectedBinding="isOcrSelected" renderedBinding="isRendered" shortDescBinding="LBL_OCR_PRIMARY_LOC@racProvisioningRB"/>
            </uix:rowLayout>
            <uix:rowLayout hAlign="center" vAlign="middle">
		<uix:messageRadioButton name="ocrm" valueBinding="rowNumber" selectedBinding="isOcrmSelected" shortDescBinding="LBL_OCR_MIRROR_LOC@racProvisioningRB"/>
            </uix:rowLayout>
            <uix:rowLayout hAlign="center" vAlign="middle">
	    	<uix:messageRadioButton name="vdsk" valueBinding="rowNumber" selectedBinding="isVdskSelected" renderedBinding="isRendered" shortDescBinding="LBL_VDSK_PRIMARY_LOC@racProvisioningRB"/>
            </uix:rowLayout>
            <uix:rowLayout hAlign="center" vAlign="middle">
	    	<uix:messageRadioButton name="vdsk1" valueBinding="rowNumber" selectedBinding="isVdsk1Selected" shortDescBinding="LBL_VDSK_MIRROR_LOC1@racProvisioningRB"/>
            </uix:rowLayout>
            <uix:rowLayout hAlign="center" vAlign="middle">
		<uix:messageRadioButton name="vdsk2" valueBinding="rowNumber" selectedBinding="isVdsk2Selected" shortDescBinding="LBL_VDSK_MIRROR_LOC2@racProvisioningRB"/>
            </uix:rowLayout>
            <uix:rowLayout hAlign="center" vAlign="middle">
		<uix:messageRadioButton name="datafiles" valueBinding="rowNumber" selectedBinding="isOradataSelected" renderedBinding="isRendered"  shortDescBinding="LBL_ORADATA_LOC@racProvisioningRB"/>
            </uix:rowLayout>
	    <uix:switcher childNameBinding="dummy">
            	<uix:case name="true">
                  <uix:rowLayout hAlign="center" vAlign="middle">
		    <uix:image
                    source="/em/images/deleteicon_enabled.gif"
                    shortDescBinding="REMOVE@racProvisioningRB"
                    primaryClientActionBinding="deleteRow"/>
                  </uix:rowLayout>
            	</uix:case>
            	<uix:default>
            	    <uix:styledText  text=""  />
            	</uix:default>
            </uix:switcher>
	    <uix:footer>
              <uix:rowLayout hAlign="end">
	        <uix:addTableRow />
              </uix:rowLayout>
	    </uix:footer>
          </uix:table>
        </uix:default>
     </uix:switcher> 
     </uix:contents>
    </uix:rowLayout>
        <uix:spacer height="3%"/>
        <uix:rowLayout>
         <uix:hideShowHeader 
             id="asmOptionsHideShow"
             partialRenderMode="self"
             partialTargets="asmOption"
             formSubmitted="true"  
             renderedBinding="asmSelected@DEVICE_STORAGE_BEAN@stepsData@servletRequest"
             textBinding="ADVANCED_OPTIONS@racProvisioningRB"
             disclosedBinding="hideShowDisclosed@INSTALL_INPUT_BEAN@stepsData@servletRequest">
          <uix:spacer width="100%" height="10"/>
          <uix:header textBinding="ASM_RED_MODE_HEADER@racProvisioningRB">
            <uix:messageRadioButton
                 id="asmOption1"
                 name="asmOption"
                 value="0"
                 textBinding="BEST_FIT@racProvisioningRB"
                 tipBinding="BEST_FIT_TIP@racProvisioningRB"
                 renderedBinding="hideShowDisclosed@INSTALL_INPUT_BEAN@stepsData@servletRequest"
                 selectedValueBinding="asmOptionSelVal@INSTALL_INPUT_BEAN@stepsData@servletRequest"/>
            <uix:messageRadioButton
                 id="asmOption2"
                 name="asmOption"
                 value="1"
                 textBinding="NONE@racProvisioningRB"
                 tipBinding="NONE_TIP@racProvisioningRB"
                 renderedBinding="hideShowDisclosed@INSTALL_INPUT_BEAN@stepsData@servletRequest"
                 selectedValueBinding="asmOptionSelVal@INSTALL_INPUT_BEAN@stepsData@servletRequest"/>
            <uix:messageRadioButton
                 id="asmOption3"
                 name="asmOption"
                 value="2"
                 textBinding="NORMAL@racProvisioningRB"
                 tipBinding="NORMAL_TIP@racProvisioningRB"
                 renderedBinding="hideShowDisclosed@INSTALL_INPUT_BEAN@stepsData@servletRequest"
                 selectedValueBinding="asmOptionSelVal@INSTALL_INPUT_BEAN@stepsData@servletRequest"/>
            <uix:messageRadioButton
                 id="asmOption4"
                 name="asmOption"
                 value="3"
                 textBinding="HIGH@racProvisioningRB"
                 tipBinding="HIGH_TIP@racProvisioningRB"
                 renderedBinding="hideShowDisclosed@INSTALL_INPUT_BEAN@stepsData@servletRequest"
                 selectedValueBinding="asmOptionSelVal@INSTALL_INPUT_BEAN@stepsData@servletRequest"/>
           </uix:header>
            <uix:spacer height="4%"/>
            <uix:tip>
              <uix:contents>
                 <uix:styledText textBinding="SPACE_PER_ASM_DISK@racProvisioningRB"
                 renderedBinding="hideShowDisclosed@INSTALL_INPUT_BEAN@stepsData@servletRequest"/>
              </uix:contents>
            </uix:tip>
            <uix:spacer height="4%"/>
            <uix:tip>
              <uix:contents>
                 <uix:styledText textBinding="MIN_SPACE_NOT_AVLBL@racProvisioningRB" 
                 renderedBinding="hideShowDisclosed@INSTALL_INPUT_BEAN@stepsData@servletRequest"/>
              </uix:contents>
            </uix:tip>
            <uix:tip>
            <uix:spacer height="4%"/>
              <uix:contents>
                 <uix:styledText textBinding="MIN_DISKS_NOT_AVLBL@racProvisioningRB" 
                 renderedBinding="hideShowDisclosed@INSTALL_INPUT_BEAN@stepsData@servletRequest"/>
              </uix:contents>
            </uix:tip>
            <uix:spacer height="4%"/>
         </uix:hideShowHeader>
       
            <uix:spacer height="4%"/>
        </uix:rowLayout>
       
</uix:header>



<%-- DEVICE STORAGE END HERE --%>

    <%-- NETWORK INTERFACE CONFIGURATION FOR WINDOWS --%>
         <uix:hideShowHeader 
             id="NICTableHideShow"
             partialRenderMode="self"
             partialTargets="InterfaceTable"
             formSubmitted="true"  
             textBinding="HDR_NETWORK_INTERFACE@racProvisioningRB"
             disclosedBinding="showInterfaceTable@stepsData@servletRequest"
             renderedBinding="showInterfaceTable@stepsData@servletRequest">

         <uix:rowLayout width="100%">
          <uix:styledText
              textBinding="DESC_NETWORK_INTERFACE@racProvisioningRB"
              styleClass="oraInstructionText" />
         </uix:rowLayout>
         <uix:rowLayout>
          <uix:spacer height="10" />
         </uix:rowLayout>
          <uix:rowLayout width="90%">
              <uix:table
                  width="40%"
                  nameBinding="tableName@INTERFACE_BEAN@stepsData@servletRequest"
                  id="InterfaceTable"
                  summary="Network Interface Information"
                  partialRenderMode="self"
                  formSubmitted="true"
                  tableDataBinding="rows@INTERFACE_BEAN@stepsData@servletRequest"
                  alternateTextBinding="NO_DATA_AVAILABLE@racProvisioningRB"
                  minValueBinding="1"
                  blockSizeBinding="5"
                  maxValueBinding="10"
                  columnHeaderDataBinding="columnHeaders@INTERFACE_BEAN@stepsData@servletRequest">
    
                <uix:tableFormat tableBanding="rowBanding"/>
 
                <uix:columnHeaderStamp>
                  <uix:text textBinding="text"/>
                </uix:columnHeaderStamp>
                <uix:choice
                    name="interfaceType"
                    selectedValueBinding="interfaceType@INTERFACE_BEAN@stepsData@servletRequest">
                  <uix:contents childDataBinding="interfaceTypeList@INTERFACE_BEAN@stepsData@servletRequest">
                    <uix:option
                        textBinding="optionTxt"
                        valueBinding="optionVal" />
                  </uix:contents>
                </uix:choice>
                <uix:styledText textBinding="interfaceName@INTERFACE_BEAN@stepsData@servletRequest"  />
                <uix:styledText textBinding="subnet@INTERFACE_BEAN@stepsData@servletRequest"  />
                <uix:formValue
                    name="interfaceName"
                    valueBinding="interfaceName@INTERFACE_BEAN@stepsData@servletRequest"  />
                <uix:formValue
                    name="subnet"
                    valueBinding="subnet@INTERFACE_BEAN@stepsData@servletRequest"  />
              </uix:table>
          </uix:rowLayout> 
         </uix:hideShowHeader>
 
</uix:stackLayout>
</uix:default>

</uix:switcher>
</uix:document >
</uix:dataScope>
</uix:buildTree>

<%@ include file="wizTemplateForProcessing.jspf" %>
