<!---->
<%--
  - FILE
  -   InstalledHome.jsp
  -
  - DESCRIPTION
   -
  - MODIFIED   (MM/DD/YY)
  -    pkithara 08/08/06 - Creation
--%>

<%@ page contentType="text/html; charset=UTF-8" %>

<%--uix Tag Library--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder  id="renderingContext"/>

  <%--Common UI messages --%>
  <uix:bundle
    name="sdkUIMsg"
    class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <%--ResourceBundle for common labels/headers etc--%>
  <uix:bundle
    name="commonResourceBundle"
    class="oracle.sysman.resources.CommonResourceBundle"/>

  <%--ResourceBundle for labels/headers specific to Patch Advisor Project--%>
  <uix:bundle
    name="racProvisioningRB"
    class="oracle.sysman.pp.racprov.ui.rb.RacProvisioningRB"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:form
        name="pageForm" method="post">

        <uix:pageLayout titleBinding="RAC_HOME_SELECTION@racProvisioningRB">

          <%--To display the cancel and select buttons--%>
          <uix:pageButtons>
            <uix:pageButtonBar>

              <%--Cancel button--%>
              <uix:submitButton
                textBinding="CANCEL@sdkUIMsg"
                shortDescBinding="CANCEL@sdkUIMsg"
                name="event"
                value="cancel">
              </uix:submitButton>

              <%--Select Button--%>
              <uix:submitButton
                textBinding="OK@commonResourceBundle"
                name="event"
                value="select">
              </uix:submitButton>

            </uix:pageButtonBar>
          </uix:pageButtons>

          <%-- The message box to show error/info messge etc--%>
          <uix:messageBox 
            messageTypeBinding="msgType@msgInfo@servletRequest"
            messageBinding="msg@msgInfo@servletRequest"
            rendered="false"
            renderedBinding="rendered@msgInfo@servletRequest">
          </uix:messageBox>
      	  <uix:header textBinding="CLUSTER_IDENTIFICATION_HEADER@racProvisioningRB">
        	<uix:spacer width="100%" height="10"/>
        	<uix:styledText 
             	  textBinding="CLUSTER_IDENTIFICATION_TEXT@racProvisioningRB"
             	  styleClass="OraInstructionText"/>
        	<uix:spacer width="100%" height="10"/>
		<uix:ref refID="PAGE_SEGMENT_TYPE_RAC_REG_CLUSTERS"/>
	  </uix:header>
        </uix:pageLayout>
      </uix:form>

    </uix:body>
  </uix:document>
</uix:renderingContext>
