<%@ page contentType="text/html; charset=UTF-8" %>

<%--uix Tag Library--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder  id="renderingContext"/>

  <%--Common UI messages --%>
  <uix:bundle
    name="sdkUIMsg"
    class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <%--ResourceBundle for common labels/headers etc--%>
  <uix:bundle
    name="commonResourceBundle"
    class="oracle.sysman.resources.CommonResourceBundle"/>

  <%--ResourceBundle for labels/headers specific to Patch Advisor Project--%>
  <uix:bundle
    name="racProvisioningRB"
    class="oracle.sysman.pp.racprov.ui.rb.RacProvisioningRB"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:form
        name="pageForm"
        method="post"> 
        <uix:pageLayout titleBinding="NETWORK_SEL_POPUP_TITLE@racProvisioningRB">

	<uix:pageButtons>
	     <uix:pageButtonBar>

		<uix:rowLayout hAlign="right">
        	<uix:flowLayout>	
		<uix:cellFormat height="25">
            <%--Cancel button--%>
              <uix:submitButton
                textBinding="CANCEL@sdkUIMsg"
                shortDescBinding="CANCEL@sdkUIMsg"
                name="event"
                value="cancel">
              </uix:submitButton>
		</uix:cellFormat>
	
		<uix:cellFormat height="25">
		 <uix:spacer width="10" height="10"/>        	  
	        </uix:cellFormat>

              <%--Select Button--%>
	<uix:cellFormat height="25">
              <uix:submitButton
                textBinding="OK@commonResourceBundle"
                name="event"
                value="select">
              </uix:submitButton>
	</uix:cellFormat>

	        </uix:flowLayout>
		</uix:rowLayout>
            </uix:pageButtonBar>
          </uix:pageButtons>


	<uix:header textBinding="SELECT_PUB_INTF_LBL@racProvisioningRB">

	<uix:stackLayout> 
	<uix:rowLayout>
		<uix:radioButton name="showallpub" id="showallpub" 
	                 valueBinding="ALL_INTERFACES_SEL_HOSTS_LBL@racProvisioningRB"
	                 textBinding="ALL_INTERFACES_SEL_HOSTS_LBL@racProvisioningRB"
	                 selectedBinding="pubShowAllRadioButton@INTERFACE_BEAN@servletRequest"
	                 primaryClientActionBinding="pubinterfacePartialAction@servletRequest"/>
	                 
		<uix:radioButton name="showallpub" id="showallpub" 
	                 valueBinding="COMMON_INTERFACES_SEL_HOSTS_LBL@racProvisioningRB"
	                 textBinding="COMMON_INTERFACES_SEL_HOSTS_LBL@racProvisioningRB"
	                 selectedBinding="pubShowCommonRadioButton@INTERFACE_BEAN@servletRequest"
	                 primaryClientActionBinding="pubinterfacePartialAction@servletRequest"/>
	</uix:rowLayout>

	<uix:spacer height="5" />	


	<uix:tableLayout id="rdbtn">
	
	
	 <uix:rowLayout>
	 <uix:cellFormat width="5%">
              <uix:text text=" "/>
         </uix:cellFormat>

	<uix:cellFormat>
	<uix:stackLayout>
	<uix:radioButton name="pubcreatenew" id="pubcreatenew"
                         valueBinding="CREATE_NEW_INTF_LBL@racProvisioningRB"
                         textBinding="CREATE_NEW_INTF_LBL@racProvisioningRB"
			 selectedBinding="pubShowCreateNewRadioButton@INTERFACE_BEAN@servletRequest"
                         primaryClientActionBinding="partialAction@servletRequest"/>

	        

	<uix:radioButton name="pubcreatenew" id="pubcreatenew"
                         valueBinding="SHOW_INTERFACE_LIST_LBL@racProvisioningRB"
                         textBinding="SHOW_INTERFACE_LIST_LBL@racProvisioningRB"
		 	 selectedBinding="pubShowInterfaceListRadioButton@INTERFACE_BEAN@servletRequest"
                         primaryClientActionBinding="partialAction@servletRequest"/>
	<uix:spacer height="10"/>
	</uix:stackLayout>
	 </uix:cellFormat>
	 </uix:rowLayout>

	</uix:tableLayout>
		<uix:tableLayout id="pubinterfaceselectiont">
			<uix:rowLayout>
				<uix:cellFormat width="10%">
					<uix:text text="  "/>
					</uix:cellFormat>
					<uix:cellFormat  hAlign="left">
					<uix:messageRadioGroup name="pubinterfaceselection"
					id="pubinterfaceselection"
					promptBinding="SELECT_PUB_INTF_LBL@racProvisioningRB"
					selectedValueBinding ="pubSelectedInterface@INTERFACE_BEAN@servletRequest"
					renderedBinding="notPubNewInterfaceControls@INTERFACE_BEAN@servletRequest"
					type="choice"
					childDataBinding="valid_pub_interfaceslist@INTERFACE_BEAN@servletRequest"
					textBinding="INTERFACENAME"
					valueBinding="INTERFACENAME"/>

				</uix:cellFormat>
			</uix:rowLayout>
		</uix:tableLayout>

	 <uix:spacer height="5"/>
	 
		<uix:tableLayout id="pubinterfacename">
			<uix:rowLayout renderedBinding="pubNewInterfaceControls@INTERFACE_BEAN@servletRequest">
			<uix:cellFormat>
				<uix:text text="    "/>
				</uix:cellFormat>
				<uix:cellFormat hAlign="left"> 
				<uix:labeledFieldLayout>
					<uix:messageTextInput 
						id = "ipubname" name="ipubname"
						promptBinding="LBL_INTERFACE@racProvisioningRB"
						required="uiOnly">
					</uix:messageTextInput>
					<uix:messageTextInput 
						id = "ipubsubnet" name="ipubsubnet"
						promptBinding="LBL_SUBNET@racProvisioningRB"
						required="uiOnly">
					</uix:messageTextInput>
					<uix:messageTextInput 
						id = "ipubsubnetmask" name="ipubsubnetmask"
						promptBinding="LBL_SUBNETMASK@racProvisioningRB"
						required="uiOnly">
					</uix:messageTextInput>
				</uix:labeledFieldLayout>     

				</uix:cellFormat>
			</uix:rowLayout>            
		</uix:tableLayout> 
	</uix:stackLayout>  
	</uix:header>	

	<uix:spacer height="5"/>


	
	<uix:header textBinding="SELECT_PRIV_INTF_LBL@racProvisioningRB">

	<uix:stackLayout>
	<uix:rowLayout>
	  <uix:cellFormat>
		<uix:spacer height="2" width="2" />	
	  </uix:cellFormat>
		<uix:radioButton name="showallpriv" id="showallpriv" 
	                 valueBinding="ALL_INTERFACES_SEL_HOSTS_LBL@racProvisioningRB"
	                 textBinding="ALL_INTERFACES_SEL_HOSTS_LBL@racProvisioningRB"
	                 selectedBinding="privShowAllRadioButton@INTERFACE_BEAN@servletRequest"
	                 primaryClientActionBinding="interfacePartialAction@servletRequest"/>

		         
		<uix:radioButton name="showallpriv" id="showallpriv" 
	                 valueBinding="COMMON_INTERFACES_SEL_HOSTS_LBL@racProvisioningRB"
	                 textBinding="COMMON_INTERFACES_SEL_HOSTS_LBL@racProvisioningRB"
	                 selectedBinding="privShowCommonRadioButton@INTERFACE_BEAN@servletRequest"
	                 primaryClientActionBinding="interfacePartialAction@servletRequest"/>
	</uix:rowLayout>

	
	<uix:spacer height="5" />	

	<uix:tableLayout id="rbtn2">
	 <uix:rowLayout>
			 <uix:cellFormat width="5%">
              <uix:text text=" "/>
         </uix:cellFormat>

	<uix:cellFormat>
	<uix:stackLayout>
		<uix:radioButton name="privcreatenew" id="privcreatenew"
                         valueBinding="CREATE_NEW_INTF_LBL@racProvisioningRB"
                         textBinding="CREATE_NEW_INTF_LBL@racProvisioningRB"
			 selectedBinding="privShowCreateNewRadioButton@INTERFACE_BEAN@servletRequest"
                         primaryClientActionBinding="partialAction@servletRequest"/>
	

	<uix:radioButton name="privcreatenew" id="privcreatenew"
                         valueBinding="SHOW_INTERFACE_LIST_LBL@racProvisioningRB"
                         textBinding="SHOW_INTERFACE_LIST_LBL@racProvisioningRB"
			 selectedBinding="privShowInterfaceListRadioButton@INTERFACE_BEAN@servletRequest"
                         primaryClientActionBinding="partialAction@servletRequest"/>
 	<uix:spacer height="10"/>
	</uix:stackLayout>
	 </uix:cellFormat>
	 </uix:rowLayout>
	</uix:tableLayout>
	
	<uix:tableLayout id="interfaceselectiont">
	<uix:rowLayout>
				<uix:cellFormat width="10%">
					<uix:text text="  "/>
					</uix:cellFormat>
					<uix:cellFormat  hAlign="left">
		<uix:messageRadioGroup name="interfaceselection"
	        	           id="interfaceselection"
	               		   selectedValueBinding ="selectedInterface@INTERFACE_BEAN@servletRequest"
            			   renderedBinding="notNewInterfaceControls@INTERFACE_BEAN@servletRequest"
 			           promptBinding="SELECT_PRIV_INTF_LBL@racProvisioningRB"
		                   type="choice"		
	     		           childDataBinding="valid_priv_interfaceslist@INTERFACE_BEAN@servletRequest"
	                	   textBinding="INTERFACENAME"
			           valueBinding="INTERFACENAME"/>

	</uix:cellFormat>
	</uix:rowLayout>
	
        
	</uix:tableLayout>

	<uix:spacer height="5" />	
	<%--Introduce some space--%>

	<uix:tableLayout id="interfacename">
          <uix:rowLayout renderedBinding="newInterfaceControls@INTERFACE_BEAN@servletRequest">

            <uix:cellFormat width="70%"  hAlign="left">
                 <uix:labeledFieldLayout labelWidth="25%" fieldWidth="80%">
                  <uix:messageTextInput 
                         id = "iname" name="iname"
                         promptBinding="LBL_INTERFACE@racProvisioningRB"
				required="uiOnly">
	          </uix:messageTextInput>
		<uix:messageTextInput 
			 id = "isubnet" name="isubnet"
                         promptBinding="LBL_SUBNET@racProvisioningRB"
		         required="uiOnly">
                  </uix:messageTextInput>
		<uix:messageTextInput 
			 id = "isubnetmask" name="isubnetmask"
                         promptBinding="LBL_SUBNETMASK@racProvisioningRB"
			 required="uiOnly">
                  </uix:messageTextInput>

                </uix:labeledFieldLayout>     
              
            </uix:cellFormat>
	 </uix:rowLayout>            
	  <uix:rowLayout renderedBinding="newInterfaceControls@INTERFACE_BEAN@servletRequest">
		<uix:cellFormat width="70%" hAlign="left">
		<uix:labeledFieldLayout labelWidth="55%" fieldWidth="80%">
		<uix:checkBox  id="ibondcheck" name="ibondcheck"
                	         checked="false" textBinding="LBL_BONDINGINTERFACE@@racProvisioningRB"/>
		 </uix:labeledFieldLayout>
		 </uix:cellFormat>
          </uix:rowLayout>            
        </uix:tableLayout>
      </uix:stackLayout>	
    </uix:header>




	

 </uix:pageLayout>
     </uix:form> 

    </uix:body>
  </uix:document>
</uix:renderingContext>
