<!---->
<%--
  - FILE
  -  review.jsp
  -
  - DESCRIPTION
  -  The review step of the Patch Advisor Interview Wizard. It displays the
  -  deployment procedure with all the phases/steps/declarations along with
  -  the data the user has specified in the interview steps.
  -
  - MODIFIED   (MM/DD/YY)
  -    vsagar   09/18/07 - 
  -    anurao   07/25/07 - 
  -    ipall    06/14/07 - 
  -    aime     04/19/07 - Adding the Advanced Config parameters for display
  -    anurao   10/16/06 - Adding a column to source table
  -    akaul    09/13/06 - 
  -    pkithara 09/11/06 - 
  -    root     08/29/06 - 
  -    pkithara 07/28/06 - Changes for asm source selection 
  -    kkhanuja 03/21/06 - Locale fix 
  -    pkithara 03/15/06 - XbranchMerge audupi_racprov_win from main 
  -    kkhanuja 02/06/06 - ADA fixes 
  -    bpaliwal 01/13/06 - XbranchMerge kkhanuja_sumfix from main 
  -    audupi   03/12/06 - Windows RAC Provisioning 
  -    kkhanuja 01/03/06 - 
  -    suravind 12/06/05 - Enabling the table with summary of selected targets 
  -    vseethar 11/28/05 - 
  -    vseethar 11/28/05 - 
  -    vseethar 11/28/05 - 
  -
  - SINCE
  -  10.2+
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ include file="/oemNoscript.jspf" %>

<%--All page contents should be within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">

  <uix:dataScope currentDataBinding="pageData@servletRequest">

    <%-- Identify page summary --%>
    <uix:switcher childNameBinding="is10203@SETUP_SHIPHOME_BEAN@stepsData@servletRequest">
    <uix:case name="true">

    <uix:header      
      textBinding="SOURCE_SELECTION_PAGE@racProvisioningRB">
        <uix:switcher childNameBinding="sourceSftLib@SETUP_SHIPHOME_BEAN@stepsData@servletRequest">
         <uix:case name="true">
          <uix:header  textBinding="HDR_SH_SWLIB@racProvisioningRB">
            <uix:header textBinding="SOURCE_FOR_CRS@racProvisioningRB">
              <uix:labeledFieldLayout width="0" fieldWidth="0" labelWidth="0" columns="1">
                <uix:messageStyledText promptBinding="SOFTWARE_NAME@racProvisioningRB" textBinding="crsShiphomeName@SOURCE_SELECTION_BEAN@stepsData@servletRequest" styleClass="OraDataText"/>
                <uix:messageStyledText promptBinding="SOFTWARE_FILE@racProvisioningRB" textBinding="crsShiphomeFileName@SOURCE_SELECTION_BEAN@stepsData@servletRequest" styleClass="OraDataText"/>
                <uix:messageStyledText promptBinding="SOURCE_LOCATION_COL@racProvisioningRB" textBinding="crsShiphomeLocation@SOURCE_SELECTION_BEAN@stepsData@servletRequest" styleClass="OraDataText"/>
              </uix:labeledFieldLayout>
            </uix:header>
            <uix:header textBinding="SOURCE_FOR_RAC@racProvisioningRB">
              <uix:labeledFieldLayout width="0" fieldWidth="0" labelWidth="0" columns="1">
                <uix:messageStyledText promptBinding="SOFTWARE_NAME@racProvisioningRB" textBinding="racShiphomeName@SOURCE_SELECTION_BEAN@stepsData@servletRequest" styleClass="OraDataText"/>
                <uix:messageStyledText promptBinding="SOFTWARE_FILE@racProvisioningRB" textBinding="racShiphomeFileName@SOURCE_SELECTION_BEAN@stepsData@servletRequest" styleClass="OraDataText"/>
                <uix:messageStyledText promptBinding="SOURCE_LOCATION_COL@racProvisioningRB" textBinding="racShiphomeLocation@SOURCE_SELECTION_BEAN@stepsData@servletRequest" styleClass="OraDataText"/>
              </uix:labeledFieldLayout>
            </uix:header>
            <uix:header textBinding="SOURCE_FOR_ASM@racProvisioningRB" renderedBinding="provAsm@SOURCE_SELECTION_BEAN@stepsData@servletRequest">
              <uix:labeledFieldLayout width="0" fieldWidth="0" labelWidth="0" columns="1">
                <uix:messageStyledText promptBinding="SOFTWARE_NAME@racProvisioningRB" textBinding="asmShiphomeName@SOURCE_SELECTION_BEAN@stepsData@servletRequest" styleClass="OraDataText"/>
                <uix:messageStyledText promptBinding="SOFTWARE_FILE@racProvisioningRB" textBinding="asmShiphomeFileName@SOURCE_SELECTION_BEAN@stepsData@servletRequest" styleClass="OraDataText"/>
                <uix:messageStyledText promptBinding="SOURCE_LOCATION_COL@racProvisioningRB" textBinding="asmShiphomeLocation@SOURCE_SELECTION_BEAN@stepsData@servletRequest" styleClass="OraDataText"/>
              </uix:labeledFieldLayout>
            </uix:header>
          </uix:header>
          </uix:case>
          <uix:default>
          <uix:header  textBinding="HDR_INST_HOME@racProvisioningRB">
          <uix:table width="80%"
                nameBinding="tableName@SETUP_SHIPHOME_BEAN@stepsData@servletRequest"
                id="SoftwareLibraryID"
                summary="SOFT_COMP_TABLE_SUMMARY"
                tableDataBinding="rows@SETUP_SHIPHOME_BEAN@stepsData@servletRequest"
                columnHeaderDataBinding="columnHeaders@SETUP_SHIPHOME_BEAN@stepsData@servletRequest">

              <uix:tableFormat tableBanding="tableBanding"/>
                  <uix:columnHeaderStamp>
                    <uix:text textBinding="text"/>
                  </uix:columnHeaderStamp>

                <uix:styledText textBinding="SOURCE_PRODUCT_COL" />
                <uix:styledText textBinding="HOME_NAME" />
                <uix:styledText textBinding="HOME_LOC"/>
                <uix:styledText textBinding="WORKING_DIR"/>
                <uix:styledText textBinding="REF_TARGET_NAME"/>
                <uix:styledText textBinding="platform"/>
                <uix:styledText textBinding="VENDOR"/>
                <uix:styledText textBinding="VERSION"/>

           </uix:table>
           </uix:header>
          </uix:default>
         </uix:switcher>
    </uix:header>
    </uix:case>
    </uix:switcher>
    <uix:header      
      textBinding="IDENTIFY_PAGE@racProvisioningRB">
        <uix:switcher childNameBinding="is10203@SETUP_SHIPHOME_BEAN@stepsData@servletRequest">
         <uix:case name="false">
          <uix:header  textBinding="HDR_SH_SWLIB@racProvisioningRB">
	  <uix:table width="80%"
		nameBinding="tableName@SETUP_SHIPHOME_BEAN@stepsData@servletRequest"
		id="SoftwareLibraryID"
		summary="SOFT_COMP_TABLE_SUMMARY"
		tableDataBinding="rows@SETUP_SHIPHOME_BEAN@stepsData@servletRequest"
		columnHeaderDataBinding="columnHeaders@SETUP_SHIPHOME_BEAN@stepsData@servletRequest">

	      <uix:tableFormat tableBanding="tableBanding"/>
	      
		  <uix:columnHeaderStamp>
		    <uix:text textBinding="text"/>
		  </uix:columnHeaderStamp>

                <uix:styledText textBinding="SOFTWARE_NAME"/>
                <uix:styledText textBinding="SOFTWARE_FILE"/>
                <uix:styledText textBinding="CREATED_ON"/>
                <uix:styledText textBinding="SOFTWARE_TYPE"/>
                <uix:styledText textBinding="SOFTWARE_PRODUCT"/>
                <uix:styledText textBinding="RELEASE_PLATFORM"/>
                <uix:styledText textBinding="SOFTWARE_DESCRIPTION"/>

           </uix:table>
          </uix:header>	
          </uix:case>
         </uix:switcher>
       <uix:header  textBinding="HDR_SEL_TARGETS@racProvisioningRB">
	  <uix:tableLayout>
	    <uix:rowLayout>
              <uix:table width="100%"
                  nameBinding="tableName@SUMMARY_SETUP_BEAN@pageData@servletRequest"
                  id="hostTable"
                  summary="hostTable"
                  tableDataBinding="rows@SUMMARY_SETUP_BEAN@pageData@servletRequest"
                  columnHeaderDataBinding="columnHeaders@SUMMARY_SETUP_BEAN@pageData@servletRequest">	    
   	          <uix:columnHeaderStamp>
                    <uix:text textBinding="text">
                    </uix:text>
                  </uix:columnHeaderStamp>
                  <uix:styledText textBinding="pubHostname"/>
                  <uix:styledText textBinding="privHostname"/>
                  <uix:styledText textBinding="privHostIp"/>
                  <uix:styledText textBinding="vipHostname"/>
                  <uix:styledText textBinding="vipHostIp"/>
		</uix:table>
	    </uix:rowLayout>
          </uix:tableLayout>
       </uix:header>	
    </uix:header>
    
    <uix:header textBinding="CREDENTIALS@racProvisioningRB">
        
	  <uix:labeledFieldLayout width="0" fieldWidth="0" labelWidth="0" columns="1">
              
              <uix:styledText
                textBinding="CREDENTIALS_TYPE@racProvisioningRB"
                styleClass="OraPromptText"/>
              <uix:rowLayout>              
              <uix:styledText
                textBinding="hostCredsTypeText@stepsData@servletRequest"
                styleClass="OraDataText"/>
              </uix:rowLayout>
                            
              <uix:styledText
                     renderedBinding="hostCredsToUse@stepsData@servletRequest"
                     textBinding="USERNAME@racProvisioningRB"
                     styleClass="OraPromptText"/>
              <uix:rowLayout>
              <uix:styledText
                     renderedBinding="hostCredsToUse@stepsData@servletRequest" 
                     textBinding="username@stepsData@servletRequest"
                     styleClass="OraDataText"/>
              </uix:rowLayout>
              
          </uix:labeledFieldLayout>
      </uix:header>    
    
    <uix:header textBinding="SCHEDULE@racProvisioningRB">
      <uix:tableLayout>
        <uix:rowLayout vAlign="top">
          <uix:styledText
            textBinding="SCHEDULED@racProvisioningRB"
            styleClass="OraPromptText">
          </uix:styledText>
          <uix:spacer width="5"/>
          <uix:formattedText
            textBinding="scheduleInfo@pageData@servletRequest"
            styleClass="OraDataText">
          </uix:formattedText>
        </uix:rowLayout>
      </uix:tableLayout>
    </uix:header>

    <uix:header      
      textBinding="INSTALL_INPUTS_PAGE@racProvisioningRB">
	<uix:header  
	  textBinding="HDR_USER_INPUT@racProvisioningRB">
	
	  <uix:labeledFieldLayout width="0" fieldWidth="0" labelWidth="0" columns="1">
	
	    
	      <uix:styledText
                  textBinding="LBL_CLUSTER_NAME@racProvisioningRB"
                  styleClass="OraPromptText">
              </uix:styledText>
              <uix:rowLayout>
              <uix:styledText
                  textBinding="clusterName@INSTALL_INPUT_BEAN@stepsData@servletRequest"
                  styleClass="OraDataText">
              </uix:styledText>
              </uix:rowLayout>

  	      
	      <uix:styledText
		textBinding="LBL_CRS_HOME_LOC@racProvisioningRB"
		styleClass="OraPromptText">
	      </uix:styledText>
	      <uix:rowLayout>
	      <uix:styledText
	      	textBinding="crsHomeLocation@INSTALL_INPUT_BEAN@stepsData@servletRequest"
	      	styleClass="OraDataText">
	      </uix:styledText>
	      </uix:rowLayout>
      
	     <uix:styledText
		textBinding="LBL_DB_BASE_LOC@racProvisioningRB"
		styleClass="OraPromptText">
	      </uix:styledText>
	      <uix:rowLayout>
	      <uix:styledText
	      	textBinding="racBaseLocation@INSTALL_INPUT_BEAN@stepsData@servletRequest"
	      	styleClass="OraDataText">
	      </uix:styledText>
	      </uix:rowLayout>
  	    
	      <uix:styledText
		textBinding="LBL_DB_HOME_LOC@racProvisioningRB"
		styleClass="OraPromptText">
	      </uix:styledText>
	      <uix:rowLayout>
	      <uix:styledText
	      	textBinding="oraHomeLocation@INSTALL_INPUT_BEAN@stepsData@servletRequest"
	      	styleClass="OraDataText">
	      </uix:styledText>
	      </uix:rowLayout>      
              <uix:switcher childNameBinding="provAsm@SOURCE_SELECTION_BEAN@stepsData@servletRequest">
              <uix:case name="true"> 
              <uix:styledText
                textBinding="LBL_ASM_HOME_LOC@racProvisioningRB"
                renderedBinding="provAsm@SOURCE_SELECTION_BEAN@stepsData@servletRequest"
                styleClass="OraPromptText">
              </uix:styledText>
              </uix:case>
              </uix:switcher>
              <uix:switcher childNameBinding="provAsm@SOURCE_SELECTION_BEAN@stepsData@servletRequest">
              <uix:case name="true"> 
              <uix:rowLayout>
              <uix:styledText
                textBinding="asmHomeLocation@INSTALL_INPUT_BEAN@stepsData@servletRequest"
                renderedBinding="provAsm@SOURCE_SELECTION_BEAN@stepsData@servletRequest"
                styleClass="OraDataText">
              </uix:styledText>
              </uix:rowLayout>
              </uix:case>
              </uix:switcher>

			 <uix:switcher childNameBinding="provAsm@SOURCE_SELECTION_BEAN@stepsData@servletRequest">
              <uix:case name="true"> 
              <uix:styledText
                textBinding="LBL_ASM_BASE_LOC@racProvisioningRB"
                renderedBinding="provAsm@SOURCE_SELECTION_BEAN@stepsData@servletRequest"
                styleClass="OraPromptText">
              </uix:styledText>
              </uix:case>
              </uix:switcher>
              <uix:switcher childNameBinding="provAsm@SOURCE_SELECTION_BEAN@stepsData@servletRequest">
              <uix:case name="true"> 
              <uix:rowLayout>
              <uix:styledText
                textBinding="asmBaseLocation@INSTALL_INPUT_BEAN@stepsData@servletRequest"
                renderedBinding="provAsm@SOURCE_SELECTION_BEAN@stepsData@servletRequest"
                styleClass="OraDataText">
              </uix:styledText>
              </uix:rowLayout>
              </uix:case>
              </uix:switcher>

	     <uix:styledText
		  textBinding="LBL_SCRATCH_LOC@racProvisioningRB"
		  styleClass="OraPromptText">
	      </uix:styledText>
	      <uix:rowLayout>
	      <uix:styledText
	      	textBinding="scratchLocation@INSTALL_INPUT_BEAN@stepsData@servletRequest"
	      	styleClass="OraDataText">
	      </uix:styledText>
	      </uix:rowLayout>

		  <%-- <uix:styledText
			  textBinding="INSTALL_IP_LABEL_INVENTORY_LOC@racProvisioningRB"
			  styleClass="OraPromptText">
		  </uix:styledText>
		  <uix:rowLayout>
		  <uix:styledText
			  textBinding="inventoryLoc@INSTALL_INPUT_BEAN@stepsData@servletRequest"
			  styleClass="OraDataText">
		  </uix:styledText>
		  </uix:rowLayout>--%>

	      <uix:styledText
		textBinding="LBL_ADDITIONAL_PARAMS@racProvisioningRB"
		styleClass="OraPromptText">
	      </uix:styledText>
	      <uix:rowLayout>
	      <uix:styledText
	      	textBinding="additionalParams@INSTALL_INPUT_BEAN@stepsData@servletRequest"
	      	styleClass="OraDataText">
	      </uix:styledText>
	      </uix:rowLayout>
		  



  	    
	      <uix:styledText
		textBinding="LBL_GDB_NAME@racProvisioningRB"
		renderedBinding="showgdbName@stepsData@servletRequest"
		styleClass="OraPromptText">
	      </uix:styledText>
	      <uix:rowLayout>
	      <uix:styledText
	      	textBinding="gdbName@INSTALL_INPUT_BEAN@stepsData@servletRequest"
	      	styleClass="OraDataText">
	      </uix:styledText> 
	      </uix:rowLayout>	    
          </uix:labeledFieldLayout>	  
	</uix:header>	

	<uix:header  
	  textBinding="HDR_DEV_STORAGE@racProvisioningRB">
        <uix:switcher
            childNameBinding="dpPlatform@DEVICE_STORAGE_BEAN@stepsData@servletRequest">

          <uix:case name="windows">
            <uix:table width="80%"
                       nameBinding="assignedTableName@INSTALL_INPUT_BEAN@stepsData@servletRequest"
                       id="DEVICEstorage"
                       summary="DEVstorage info"
                       tableDataBinding="assignedDeviceRows@INSTALL_INPUT_BEAN@stepsData@servletRequest"
                       minValueBinding="1"
                       blockSizeBinding="3"
                       maxValueBinding="6"
                       columnHeaderDataBinding="assignedDeviceColumnHeaders@INSTALL_INPUT_BEAN@stepsData@servletRequest">
    
                <uix:tableFormat tableBanding="rowBanding"/>
                <uix:columnHeaderStamp>
                    <uix:text textBinding="text"/>
                </uix:columnHeaderStamp>
    
                <uix:styledText  textBinding="assignedDiskNumber@INSTALL_INPUT_BEAN@stepsData@servletRequest"  />
                <uix:styledText  textBinding="assignedPartitionNumber@INSTALL_INPUT_BEAN@stepsData@servletRequest"  />
                <uix:styledText  textBinding="assignedMountSize@INSTALL_INPUT_BEAN@stepsData@servletRequest"  />
                <uix:styledText  textBinding="assignedDriveLetter@INSTALL_INPUT_BEAN@stepsData@servletRequest"  />
                <uix:styledText  textBinding="assignedUsage@INSTALL_INPUT_BEAN@stepsData@servletRequest"  />
            </uix:table>
          </uix:case>

          <uix:default>
	  <uix:labeledFieldLayout width="0" fieldWidth="0" labelWidth="0" columns="1">
            <uix:messageStyledText
                promptBinding="LBL_OCR_PRIMARY_LOC@racProvisioningRB"
          	    textBinding="ocrLocation@INSTALL_INPUT_BEAN@stepsData@servletRequest"
            styleClass="OraDataText"/>
            <uix:messageStyledText
                renderedBinding="showOcrMirror@stepsData@servletRequest"
                promptBinding="LBL_OCR_MIRROR_LOC@racProvisioningRB"
              textBinding="ocrMirrorLocation@INSTALL_INPUT_BEAN@stepsData@servletRequest"
            styleClass="OraDataText"/>
            <uix:messageStyledText
                promptBinding="LBL_VDSK_PRIMARY_LOC@racProvisioningRB"
              textBinding="vdskLocation@INSTALL_INPUT_BEAN@stepsData@servletRequest"
            styleClass="OraDataText"/>
            <uix:messageStyledText
                renderedBinding="showVdskMirror@stepsData@servletRequest"
                promptBinding="LBL_VDSK_MIRROR_LOC1@racProvisioningRB"
              textBinding="vdskMirrorLocation1@INSTALL_INPUT_BEAN@stepsData@servletRequest"
            styleClass="OraDataText"/>
            <uix:messageStyledText
                renderedBinding="showVdskMirror@stepsData@servletRequest"
                promptBinding="LBL_VDSK_MIRROR_LOC2@racProvisioningRB"
              textBinding="vdskMirrorLocation2@INSTALL_INPUT_BEAN@stepsData@servletRequest"
            styleClass="OraDataText"/>
            <uix:messageStyledText
                promptBinding="LBL_ORADATA_LOC@racProvisioningRB"
              textBinding="oraDataLocation@INSTALL_INPUT_BEAN@stepsData@servletRequest"
            styleClass="OraDataText"/>
            <uix:messageStyledText
                promptBinding="ASM_RED_MODE_HEADER@racProvisioningRB"
              textBinding="asmOptionDisplayString@INSTALL_INPUT_BEAN@stepsData@servletRequest"
              renderedBinding="asmSelected@DEVICE_STORAGE_BEAN@stepsData@servletRequest"
            styleClass="OraDataText"/>
	  </uix:labeledFieldLayout>

        </uix:default>
        </uix:switcher>
	</uix:header>

      <%--  <uix:switcher
            childNameBinding="dpPlatform@DEVICE_STORAGE_BEAN@stepsData@servletRequest">
           <uix:case name="windows"> --%>
            <uix:header textBinding="HDR_NETWORK_INTERFACE@racProvisioningRB">
              <uix:rowLayout width="90%">
                <uix:contents>
                  <uix:table
                      width="90%"
                      nameBinding="tableName@INTERFACE_BEAN@stepsData@servletRequest"
                      id="NICinfo"
                      summary="Network Interface Information"
                      tableDataBinding="rows@INTERFACE_BEAN@stepsData@servletRequest"
                      minValueBinding="1"
                      blockSizeBinding="5"
                      maxValueBinding="10"
                      columnHeaderDataBinding="columnHeaders@INTERFACE_BEAN@stepsData@servletRequest">

                    <uix:tableFormat tableBanding="rowBanding"/>

                    <uix:columnHeaderStamp>
                      <uix:text textBinding="text"/>
                    </uix:columnHeaderStamp>

                    <uix:styledText textBinding="interfaceType@INTERFACE_BEAN@stepsData@servletRequest" />
                    <uix:styledText textBinding="interfaceName@INTERFACE_BEAN@stepsData@servletRequest"  />
                    <uix:styledText textBinding="subnet@INTERFACE_BEAN@stepsData@servletRequest"  />

                  </uix:table>
                </uix:contents>
              </uix:rowLayout>
            </uix:header>
         <%-- </uix:case> --%>
       <%-- </uix:switcher> --%>
    </uix:header>      

	<uix:header      
         textBinding="ADVANCED_CONFIG_PAGE@racProvisioningRB"
         renderedBinding="showAdvConf@ADVANCED_CONFIG_BEAN@stepsData@servletRequest">
	<uix:header  
	  renderedBinding="enableBondingIntf@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
	  textBinding="LBL_BONDINGINTERFACE@racProvisioningRB">
	
	  <uix:labeledFieldLayout width="0" fieldWidth="0" labelWidth="0" columns="1">
	
	    
	      <uix:styledText
                  textBinding="LBL_BONDING_DEVICE_NAME@racProvisioningRB"
                  styleClass="OraPromptText">
              </uix:styledText>
              <uix:rowLayout>
              <uix:styledText
                  textBinding="bondingDevName@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
                  styleClass="OraDataText">
              </uix:styledText>
              </uix:rowLayout>

  	      
	      <uix:styledText
                  textBinding="LBL_SUBNET_MASK@racProvisioningRB"
                  styleClass="OraPromptText">
              </uix:styledText>
              <uix:rowLayout>
              <uix:styledText
                  textBinding="subnetMask@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
                  styleClass="OraDataText">
              </uix:styledText>
              </uix:rowLayout>
              
	      <uix:styledText
                  textBinding="LBL_DEFAULT_GATEWAY@racProvisioningRB"
                  styleClass="OraPromptText">
              </uix:styledText>
              <uix:rowLayout>
              <uix:styledText
                  textBinding="defaultGateway@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
                  styleClass="OraDataText">
              </uix:styledText>
              </uix:rowLayout>
          
	      <uix:styledText
                  textBinding="LBL_DNS_SERVERS@racProvisioningRB"
                  styleClass="OraPromptText">
              </uix:styledText>
              <uix:rowLayout>
              <uix:styledText
                  textBinding="dnsServers@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
                  styleClass="OraDataText">
              </uix:styledText>
              </uix:rowLayout>

	      <uix:styledText
                  textBinding="LBL_SLAVE_DEV_LIST@racProvisioningRB"
                  styleClass="OraPromptText">
              </uix:styledText>
              <uix:rowLayout>
              <uix:styledText
                  textBinding="slaveDevList@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
                  styleClass="OraDataText">
              </uix:styledText>
              </uix:rowLayout>

	      <uix:styledText
                  textBinding="LBL_BONDING_MODE@racProvisioningRB"
                  styleClass="OraPromptText">
              </uix:styledText>
              <uix:rowLayout>
              <uix:styledText
                  textBinding="bondingMode@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
                  styleClass="OraDataText">
              </uix:styledText>
              </uix:rowLayout>

	      <uix:styledText
                  textBinding="LBL_DOMAIN_NAME@racProvisioningRB"
                  styleClass="OraPromptText">
              </uix:styledText>
              <uix:rowLayout>
              <uix:styledText
                  textBinding="domainName@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
                  styleClass="OraDataText">
              </uix:styledText>
              </uix:rowLayout>

	      <uix:styledText
                  textBinding="LBL_PRIMARY_SLAVE_DEV@racProvisioningRB"
                  styleClass="OraPromptText">
              </uix:styledText>
              <uix:rowLayout>
              <uix:styledText
                  textBinding="primarySlaveDev@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
                  styleClass="OraDataText">
              </uix:styledText>
              </uix:rowLayout>

	      <uix:styledText
                  textBinding="LBL_ARP_INTERVAL@racProvisioningRB"
                  styleClass="OraPromptText">
              </uix:styledText>
              <uix:rowLayout>
              <uix:styledText
                  textBinding="arpInterval@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
                  styleClass="OraDataText">
              </uix:styledText>
              </uix:rowLayout>

	      <uix:styledText
                  textBinding="LBL_ARP_IP_TARGETS@racProvisioningRB"
                  styleClass="OraPromptText">
              </uix:styledText>
              <uix:rowLayout>
              <uix:styledText
                  textBinding="arpIpTargets@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
                  styleClass="OraDataText">
              </uix:styledText>
              </uix:rowLayout>

	      <uix:styledText
                  textBinding="LBL_MII_INTERVAL@racProvisioningRB"
                  styleClass="OraPromptText">
              </uix:styledText>
              <uix:rowLayout>
              <uix:styledText
                  textBinding="miiInterval@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
                  styleClass="OraDataText">
              </uix:styledText>
              </uix:rowLayout>

	      <uix:styledText
                  textBinding="LBL_MII_INTERVAL_DOWN_DELAY@racProvisioningRB"
                  styleClass="OraPromptText">
              </uix:styledText>
              <uix:rowLayout>
              <uix:styledText
                  textBinding="miiIntervalDownDelay@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
                  styleClass="OraDataText">
              </uix:styledText>
              </uix:rowLayout>

	      <uix:styledText
                  textBinding="LBL_MII_INTERVAL_UP_DELAY@racProvisioningRB"
                  styleClass="OraPromptText">
              </uix:styledText>
              <uix:rowLayout>
              <uix:styledText
                  textBinding="miiIntervalUpDelay@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
                  styleClass="OraDataText">
              </uix:styledText>
              </uix:rowLayout>
              
          <uix:styledText
                  textBinding="LBL_NTP_SERVER@racProvisioningRB"
                  styleClass="OraPromptText">
              </uix:styledText>
              <uix:rowLayout>
              <uix:styledText
                  textBinding="ntpServer@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
                  styleClass="OraDataText">
              </uix:styledText>
              </uix:rowLayout>
	      </uix:labeledFieldLayout>
              </uix:header>
	      <uix:header  
	  renderedBinding="enableSysctl@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
	  textBinding="LBL_SYSCTL_CONF@racProvisioningRB">
	
	  <uix:labeledFieldLayout width="0" fieldWidth="0" labelWidth="0" columns="1">
	
	    
	      <uix:styledText
                  textBinding="LBL_MODE@racProvisioningRB"
                  styleClass="OraPromptText">
              </uix:styledText>
              <uix:rowLayout>
              <uix:styledText
                  textBinding="mode@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
                  styleClass="OraDataText">
              </uix:styledText>
              </uix:rowLayout>

  	      
	      <uix:styledText
                  textBinding="LBL_REFERENCE_FILE@racProvisioningRB"
                  styleClass="OraPromptText">
              </uix:styledText>
              <uix:rowLayout>
              <uix:styledText
                  textBinding="referenceFile@ADVANCED_CONFIG_BEAN@stepsData@servletRequest"
                  styleClass="OraDataText">
              </uix:styledText>
              </uix:rowLayout>
              
              </uix:labeledFieldLayout>
	      </uix:header>
	      
	      </uix:header>
<%-- Page Segment for library steps --%>

    <%--Library Step Parameters--%>
    <uix:header
      renderedBinding="showLibStep@stepsData@servletRequest"
      textBinding="LIBRARY_STEP_PROPERTIES@racProvisioningRB">      
      
      <uix:ref refID="PAGE_SEGMENT_TYPE_PROV_LIB_STEP"/>
<%--uix:hGrid
        id="libPropHGrid"
        width="500"
        partialRenderMode="self"
        alternateTextBinding="MSG_NO_LIB_STEP_PORPS_FOUND@racProvisioningRB"
        summaryBinding="LIBRARY_STEP_PROPERTIES@racProvisioningRB"
        treeDataBinding="hGridData@stepsData@servletRequest"
        proxyBinding="hGridProxy@pageData@servletRequest"
        formSubmitted="true">
        <uix:nodeStamp>
          <uix:column>
            <uix:columnFormat width="70%"/>
            <uix:columnHeader>
              <uix:styledText textBinding="LIB_STEP@racProvisioningRB"/>
            </uix:columnHeader>
            <uix:styledText textBinding="text"/>
          </uix:column>
        </uix:nodeStamp>

        <%--Property col--%>
        <%--uix:column>
          <uix:columnHeader>
            <uix:styledText textBinding="PROP_VALUE@racProvisioningRB"/>
          </uix:columnHeader>
          <uix:styledText textBinding="propNodeValue"/>
        </uix:column>
      </uix:hGrid>
      <uix:spacer height="5"/>
      <uix:separator/--%>
    </uix:header>


  </uix:dataScope>

</uix:buildTree>



<%@ include file="wizTemplate.jspf" %>

