<%--
  - FILE
  -   sidbSrcSel.jsp
  -
  - DESCRIPTION
  -   Source  selection page
  -
  - MODIFIED    (MM/DD/YY)
  -  svijayar    06/06/07   - Created
  -
  --%>
  <%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
  <%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
  <%@ include file="/oemNoscript.jspf"%>
  
  <%--All page contents should be within this tag--%>
  <uix:buildTree nodeID="sidbContent" scope="request">
    <uix:stackLayout>
    <uix:header textBinding="SIDB_DB_CONFIG_DETAILS_HDR@sidbResourceBundle">
    <uix:rowLayout>
      <uix:cellFormat width="50%" vAlign="top">
        <uix:labeledFieldLayout labelWidth="0%" fieldWidth="100%">
                <uix:messageTextInput 
                  columns="30"
                  name="sidbSid"
                  promptBinding="SIDB_DB_CONFIG_SID_NAME@sidbResourceBundle"
                  textBinding = "sidbSid_txt_val@servletRequest"
                  required = "true"
                  messageTypeBinding="sidErrType@servletRequest"
                  messageBinding="SIDB_DB_CONFIG_SID_SHORT_DESC@sidbResourceBundle"
        				  shortDescBinding="SIDB_DB_CONFIG_SID_SHORT_DESC@sidbResourceBundle"/>
                <uix:messageLovField 
                  columns="30"
                  name="sidbDataFileLoc"
                  promptBinding="SIDB_DB_CONFIG_DATA_FILE_LOC@sidbResourceBundle"
                  textBinding = "sidbDataFileLoc_txt_val@servletRequest"
                  required = "true"
                  messageTypeBinding="dataFileLocErrType@servletRequest"
                  messageBinding="dataFileLocErrMsg@servletRequest"
        				  shortDescBinding="SIDB_DB_CONFIG_SID_SHORT_DESC@sidbResourceBundle"/>
                <uix:messageTextInput 
                  columns="30"
                  name="sidbDbPassword"
                  promptBinding="SIDB_DB_CONFIG_DB_PASSWD@sidbResourceBundle"
                  textBinding = "sidbDbPassword_txt_val@servletRequest"
                  required = "true"
                  noAutoComplete="true"
                  secret="true"
                  messageTypeBinding="dbPasswordErrType@servletRequest"
                  messageBinding="SIDB_DB_CONFIG_DB_PASSWD_SHORT_DESC@sidbResourceBundle"
          			  shortDescBinding="SIDB_DB_CONFIG_DB_PASSWD_SHORT_DESC@sidbResourceBundle"/>
                <uix:messageTextInput 
                  columns="30"
                  name="sidbConfDbPassword"
                  promptBinding="SIDB_DB_CONFIG_CONF_DB_PASSWD@sidbResourceBundle"
                  textBinding = "sidbConfDbPassword_txt_val@servletRequest"
                  required = "true"
                  secret="true"
                  noAutoComplete="true"
                  messageTypeBinding="dbConfPasswordErrType@servletRequest"
                  messageBinding="dbConfPasswordErrMsg@servletRequest"/>
          </uix:labeledFieldLayout>
        </uix:cellFormat>                        
        <uix:cellFormat width="50%" vAlign="top">
          <uix:contentContainer background="light" width="100%" 
          textBinding="SIDB_DB_CONFIG_INFORMATION@sidbResourceBundle">                
            <uix:bulletedList>
              <uix:styledText styleClass="OraInstructionText" textBinding="SIDB_DB_CONFIG_SID_DESC@sidbResourceBundle"/>
              <uix:styledText styleClass="OraInstructionText" textBinding="SIDB_DB_CONFIG_DATA_FILE_LOC_DESC@sidbResourceBundle"/>
              <uix:styledText styleClass="OraInstructionText" textBinding="SIDB_DB_CONFIG_DB_PASSWD_DESC@sidbResourceBundle"/>
            </uix:bulletedList>
          </uix:contentContainer>
        </uix:cellFormat>                        
      </uix:rowLayout>        
    </uix:header>
  </uix:stackLayout>            
</uix:buildTree>
<%@ include file="sidbTemplate.jspf"%>
  
