<%--
  - FILE
  -   properties.jsp
  -
  - DESCRIPTION
  -   Unbound properties page
  -
  - MODIFIED   (MM/DD/YY)
  -  svijayar   06/12/07 - Created
  - SINCE
  -  10.2+
  --%>
  <%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
  <%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
  <%@ include file="/oemNoscript.jspf"%>
  <%--All page contents should be within this tag--%>
  <uix:buildTree nodeID="sidbContent" scope="request">
    <uix:spacer height="10"/>
    <uix:inlineMessage messageTypeBinding="msgType@servletRequest" messageBinding="msg@servletRequest">
      <%--the hGrid--%>
      <uix:hGrid 
          id="libPropHGrid" 
          partialRenderMode="self" 
          alternateTextBinding="MSG_NO_LIB_STEP_PROPS_FOUND@sidbResourceBundle" 
          summaryBinding="LIBRARY_STEP_PROPERTIES@sidbResourceBundle" 
          treeDataBinding="hGridData@servletRequest" 
          proxyBinding="hGridProxy@servletRequest" 
          formSubmitted="true"
          >
        <uix:nodeStamp>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="LIB_STEP@sidbResourceBundle"/>
            </uix:columnHeader>
            <uix:columnFormat cellNoWrapFormat="true" width="30%"/>
              <uix:contents>
                <uix:styledText textBinding="text" styleClass="OraInstructionText"/>
              </uix:contents>
            </uix:column>
        </uix:nodeStamp>   

        <%--Property col--%>
        <uix:column>
          <uix:columnHeader>
            <uix:styledText textBinding="PROP_VALUE@sidbResourceBundle"/>
          </uix:columnHeader>
          <uix:contents>
                  <uix:messageTextInput 
                      name="propNodeField" 
                      textBinding="propNodeValue" 
                      messageTypeBinding="propNodeFieldMsgType"
                      tipBinding="UNBOUND_TIP_DESC"
                      required="uiOnly"
                      messageBinding="propNodeFieldMsg"
                      shortDescBinding="PROP_VALUE@sidbResourceBundle"
                      renderedBinding="node_rendered"
                      noAutoCompleteBinding="issecret"
                      secretBinding="issecret"/>
          </uix:contents>
        </uix:column>
      </uix:hGrid>
    </uix:inlineMessage>
  </uix:buildTree>
<%@ include file="sidbTemplate.jspf"%>
