<%--
  - FILE
  -   sidbReview.jsp
  -
  - DESCRIPTION
  -   Review page
  -
  - MODIFIED    (MM/DD/YY)
  -  svijayar    06/06/07   - Created
  -
  --%>
  <%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
  <%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
  <%@ include file="/oemNoscript.jspf"%><%--All page contents should be within this tag--%>

  <uix:buildTree nodeID="sidbContent" scope="request">
    <uix:stackLayout>
      <%--Source and target settings page --%>
      <uix:header textBinding="SIDB_SRC_SEL_SEC_HDR@sidbResourceBundle" id="sidbsrcselhdr">
      <uix:rowLayout>
        <uix:messageTextInput readOnly="true"
              contentStyleClass="OraInstructionTextStrong"
              textBinding="sourceSelected@servletRequest"/>
      </uix:rowLayout>    
      <uix:switcher 
      childNameBinding="sourceSelected@sidb_src_sel_page_bean@stepMap@servletRequest">
      <uix:case name="srcSelSftLibSel">
        <uix:labeledFieldLayout id="sftLibOptDetails"  labelWidth="0%" fieldWidth="100%">
          <uix:messageTextInput  readOnly="true"
              textBinding="componentName@sidb_src_sel_page_bean@stepMap@servletRequest"
              contentStyleClass="OraInstructionTextStrong"
              promptBinding="SIDB_SRC_SEL_SFT_LIB_CMPT_LBL@sidbResourceBundle">
          </uix:messageTextInput>
          <uix:messageTextInput  readOnly="true"
              textBinding="componentLocation@sidb_src_sel_page_bean@stepMap@servletRequest"
              contentStyleClass="OraInstructionTextStrong"
              promptBinding="SIDB_SRC_SEL_SFT_LIB_CMPT_LOC_LBL@sidbResourceBundle">
          </uix:messageTextInput>
        </uix:labeledFieldLayout>
      </uix:case>
      <uix:case name="srcInstHomeSel">
        <uix:labeledFieldLayout id="insthomedetails"  labelWidth="0%" fieldWidth="100%">
          <uix:messageTextInput  readOnly="true"
              textBinding="srcHostName@sidb_src_sel_page_bean@stepMap@servletRequest"
              contentStyleClass="OraInstructionTextStrong"
              promptBinding="SIDB_SRC_SEL_INST_HOME_SRCHOST_LBL@sidbResourceBundle"/>
          <uix:messageTextInput  readOnly="true"
              textBinding="oracleHome@sidb_src_sel_page_bean@stepMap@servletRequest"
              contentStyleClass="OraInstructionTextStrong"
              promptBinding="SIDB_SRC_SEL_INST_HOME_ORHOME_LBL@sidbResourceBundle"/>
          <uix:messageTextInput  readOnly="true"
              textBinding="workingDirectory@sidb_src_sel_page_bean@stepMap@servletRequest"
              contentStyleClass="OraInstructionTextStrong"
              promptBinding="SIDB_SRC_SEL_INST_HOME_WORKDIR_LBL@sidbResourceBundle"/>
          <uix:messageTextInput  readOnly="true"
              textBinding="filesToExclude@sidb_src_sel_page_bean@stepMap@servletRequest"
              contentStyleClass="OraInstructionTextStrong"
              promptBinding="SIDB_SRC_SEL_INST_HOME_FIL_TO_EXCL_LBL@sidbResourceBundle"/>
        </uix:labeledFieldLayout>
      </uix:case>
      </uix:switcher>
      </uix:header>
      
      <%-- Target Details --%>
      <uix:header textBinding="SIDB_TGT_SEL_SEC_HDR@sidbResourceBundle" id="sidbsrcselhdr">
        <uix:stackLayout id="tgtDetails">
              <uix:table id="sidbTgtTableId"
               width="100%"
               name="sidbTgtTable"
               formSubmitted="true"
               partialRenderMode="self"
               tableDataBinding="rows@sidb_tgt_sel_page_bean@stepMap@servletRequest"
               valueBinding="currVal@sidb_tgt_sel_page_bean@stepMap@servletRequest"
               minValueBinding="minVal@sidb_tgt_sel_page_bean@stepMap@servletRequest"
               blockSizeBinding="blockSize@sidb_tgt_sel_page_bean@stepMap@servletRequest"
               alternateTextBinding="SIDB_NO_TGT_SELECTED@sidbResourceBundle"
               maxValueBinding="maxVal@sidb_tgt_sel_page_bean@stepMap@servletRequest"
               columnHeaderDataBinding="columnHeaders@sidb_tgt_sel_page_bean@stepMap@servletRequest">
        <uix:tableActions>
          <uix:rowLayout width="100%">
            <uix:messageTextInput  promptBinding="SIDB_TBL_PATH_DD_LBL@sidbResourceBundle"
                textBinding="pathselval@servletRequest"
                contentStyleClass="OraInstructionTextStrong"
                readOnly="true"/>
            <uix:formattedText text="&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"/>    
            <uix:messageTextInput  promptBinding="SIDB_TBL_CRED_DD_LBL@sidbResourceBundle"
                textBinding="credselval@servletRequest"
                contentStyleClass="OraInstructionTextStrong"
                readOnly="true"/>
          </uix:rowLayout>
        </uix:tableActions>
        <uix:columnHeaderStamp>
          <uix:sortableHeader
            textBinding="text"
            sortableBinding="sortable">
          </uix:sortableHeader>
        </uix:columnHeaderStamp>
          <uix:styledText 
               textBinding="TARGET_SELECTION_TABLE_COLUMN_HOST"/>
          <uix:styledText  
               textBinding="TARGET_SELECTION_TABLE_COLUMN_ORACLE_BASE"/>
          <uix:styledText 
               textBinding="TARGET_SELECTION_TABLE_COLUMN_ORACLE_HOME"/>
          <uix:styledText 
               textBinding="TARGET_SELECTION_TABLE_COLUMN_WORKING_DIR"/>
          <uix:styledText 
               textBinding="TARGET_SELECTION_TABLE_COLUMN_ORACLE_USER_NAME"/>
          <uix:styledText 
               textBinding="TARGET_SELECTION_TABLE_COLUMN_ORACLE_PASSWORD"
               rendered="false"/>
          <uix:styledText 
               textBinding="TARGET_SELECTION_TABLE_COLUMN_AGENT_USR_NAME"/>
          <uix:styledText 
               rendered="false"
               textBinding="TARGET_SELECTION_TABLE_COLUMN_AGENT_PASSWORD"/>
          <uix:image
               rendered="false"
               source="/em/images/deleteicon_enabled.gif"/>
         </uix:table>
        
        </uix:stackLayout>
      </uix:header>
      
    <%--Starter db options 
    <uix:header textBinding="SIDB_STARTER_DB_DETAILS_HDR@sidbResourceBundle">
        <uix:messageTextInput readOnly="true"
              contentStyleClass="OraInstructionTextStrong"
              textBinding="starterDbType@servletRequest"/>
     </uix:header>    
    <uix:header textBinding="SIDB_DB_CONFIG_DETAILS_HDR@sidbResourceBundle"
      renderedBinding="renderDbConf@servletRequest">
      <uix:labeledFieldLayout labelWidth="0%" fieldWidth="100%">    
          <uix:messageTextInput  readOnly="true"
              textBinding = "dbSid@sidb_db_conf_page_bean@servletRequest"
              contentStyleClass="OraInstructionTextStrong"
              promptBinding="SIDB_DB_CONFIG_SID_NAME@sidbResourceBundle"/>
          <uix:messageTextInput  readOnly="true"
              textBinding="dataFileLoc@sidb_db_conf_page_bean@servletRequest"
              contentStyleClass="OraInstructionTextStrong"
              promptBinding="SIDB_DB_CONFIG_DATA_FILE_LOC@sidbResourceBundle"/>
      </uix:labeledFieldLayout>
    </uix:header>--%>
    
    
   <uix:header textBinding="PROPERTIES_HEADER@sidbResourceBundle" 
      renderedBinding="renderPropPage@servletRequest">
    <uix:cellFormat width="5%"/>
    <uix:cellFormat>
      <uix:hGrid 
          id="libPropHGrid" 
          partialRenderMode="self" 
          alternateTextBinding="MSG_NO_LIB_STEP_PROPS_FOUND@sidbResourceBundle" 
          summaryBinding="LIBRARY_STEP_PROPERTIES@sidbResourceBundle" 
          treeDataBinding="libStepsPropsHGrid@sidb_prop_page_bean@servletRequest"    
          proxyBinding="hGridProxy@servletRequest" 
          formSubmitted="true">
        <uix:nodeStamp>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="LIB_STEP@sidbResourceBundle"/>
            </uix:columnHeader>
            <uix:columnFormat cellNoWrapFormat="false"/>
            <uix:contents>
              <uix:styledText textBinding="text"/>
            </uix:contents>                
          </uix:column>
        </uix:nodeStamp>        

        <%--Property col--%>
        <uix:column>
          <uix:columnHeader>
            <uix:styledText textBinding="PROP_VALUE@sidbResourceBundle"/>
          </uix:columnHeader>
          <%--
          <uix:switcher childNameBinding="expandable">
            <uix:case name="no">
              <%-- prop value input box is placed inside the tableLayout, so
               - that the input boxes are properly aligned, when erorr message
               - is displayed
               
              <uix:tableLayout width="100%">
                <uix:rowLayout>--%>
                <uix:contents> 
                  <uix:messageTextInput 
                      name="propNodeField" 
                      textBinding="reviewPageText"
                      readOnly="true"
                      contentStyleClass="OraInstructionTextStrong"
                      />
                 </uix:contents>     
               <%--       
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:case>
            <uix:default>
              <uix:text text=""/>
            </uix:default>
          </uix:switcher>
          --%>
        </uix:column>

      </uix:hGrid>
    </uix:cellFormat>
  </uix:header>

        <uix:header
           textBinding="REVIEW_HEADER_SCHEDULE@sidbResourceBundle">
        <uix:labeledFieldLayout labelWidth="0%" fieldWidth="100%">

          <uix:messageTextInput
              promptBinding="START_DATE@scheduleResourceBundle"
              textBinding="startDate@servletRequest"
              readOnly="true"
              contentStyleClass="OraInstructionTextStrong"/>
          <uix:messageTextInput
              promptBinding="GRACE_PERIOD@scheduleResourceBundle"
              textBinding="gracePeriodVal@servletRequest"
              readOnly="true"
              contentStyleClass="OraInstructionTextStrong"/>
        </uix:labeledFieldLayout>
      </uix:header>

      
      

     
    </uix:stackLayout>
  </uix:buildTree>

<%@ include file="sidbTemplate.jspf"%>
  
