/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.welcomepage;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AscLinkBean {
    private final String EMURL = "<a href=\"%ASCLINK%\" target=\"_blank\">Launch</a> Application Server Control";
    private final String ERRORSTRING_NOTDEPLOYED = "Application Server Control is not deployed on this OC4J instance";
    private final String ERRORSTRING_NOTSTARTED = "Application Server Control is not started on this OC4J instance";
    private final String ERRORSTRING_NOTBOUND = "Application Server Control is not bound on this OC4J instance";
    private final String ERRORSTRING_GENERAL = "Application Server Control is not available on this OC4J instance";
    private static final boolean DEBUG = false;
    private static final String SEP = System.getProperty("file.separator");
    private static final String J2EE_HOME = System.getProperty("oracle.j2ee.home");
    private static final String CONFIG_DIR = J2EE_HOME + SEP + "config";
    private static final String DEFAULTCONFIGFILE = CONFIG_DIR + SEP + "server.xml";
    private static final String AJP_REQUEST_MARKER = "com.evermind.server.http.AJPHttpServletRequest";
    private String m_Servername = null;
    private String m_RequestClassname = null;
    private String m_Filename = null;
    private boolean m_Valid = true;
    private String m_EMRoot = null;
    private String m_EMServer = null;
    private String m_EMPort = null;
    private NodeList m_WebSites = null;
    private NodeList m_Applications = null;

    public AscLinkBean() {
        this(DEFAULTCONFIGFILE);
    }

    public AscLinkBean(String xmlfile) {
        this.log("constructor(" + xmlfile + ")");
        this.setFilename(xmlfile);
    }

    private void parseServerXML() {
        boolean cont = true;
        this.log("parseServerXML, filename=" + this.getFilename());
        try {
            this.setValid(true);
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new File(this.getFilename()));
            this.setApplicationSet(doc.getElementsByTagName("application"));
            this.setWebSiteSet(doc.getElementsByTagName("web-site"));
        }
        catch (Exception e) {
            this.setValid(false);
            this.log(e);
        }
    }

    private boolean isBehindOHS() {
        this.log("isBehindOHS, getRequestClassname=" + this.getRequestClassname());
        return AJP_REQUEST_MARKER.equals(this.getRequestClassname());
    }

    private boolean isASCDeployed() {
        NodeList applications = this.getApplicationSet();
        boolean cont = true;
        boolean ret = false;
        if (applications == null) {
            return ret;
        }
        for (int i = 0; cont && i < applications.getLength(); ++i) {
            Node node = applications.item(i);
            NamedNodeMap attrs = node.getAttributes();
            Node name = attrs.getNamedItem("name");
            if (!name.getNodeValue().equalsIgnoreCase("ascontrol")) continue;
            ret = true;
            cont = false;
        }
        return ret;
    }

    private boolean isASCStarted() {
        boolean cont = true;
        boolean ret = false;
        NodeList applications = this.getApplicationSet();
        if (applications == null) {
            return ret;
        }
        for (int i = 0; cont && i < applications.getLength(); ++i) {
            Node node = applications.item(i);
            NamedNodeMap attrs = node.getAttributes();
            if (attrs == null) continue;
            Node name = attrs.getNamedItem("name");
            Node start = attrs.getNamedItem("start");
            if (name == null || start == null || !name.getNodeValue().equalsIgnoreCase("ascontrol") || !start.getNodeValue().equalsIgnoreCase("true")) continue;
            this.log("Found application ascontrol and start=true");
            cont = false;
            ret = true;
        }
        return ret;
    }

    private boolean isASCBound() {
        NodeList websites = this.getWebSiteSet();
        boolean ret = false;
        boolean cont = true;
        if (websites == null) {
            return ret;
        }
        for (int i = 0; cont && i < websites.getLength(); ++i) {
            Node path;
            Node node = websites.item(i);
            this.log(node.getNodeName());
            NamedNodeMap attrs = node.getAttributes();
            if (attrs == null || (path = attrs.getNamedItem("path")) == null || !this.isASCPublishedOnWebSite(path)) continue;
            this.log("Found ascontrol in a website definition, path=" + path.getNodeValue());
            ret = true;
            cont = false;
        }
        return ret;
    }

    private boolean isASCPublishedOnWebSite(Node path) {
        boolean ret = false;
        boolean cont = true;
        String port = null;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new File(this.constructWebSiteFilePath(path.getNodeValue())));
            port = doc.getDocumentElement().getAttribute("port");
            this.log("Found website, path=" + path.getNodeValue() + ", port=" + port);
            if (this.isASCDefaultWebApp(doc) || this.isASCWebApp(doc)) {
                this.setEMPort(port);
                return true;
            }
        }
        catch (Exception e) {
            this.setValid(false);
            this.log(e);
        }
        return ret;
    }

    private boolean isASCWebApp(Document doc) {
        boolean ret = false;
        boolean cont = true;
        NodeList webapps = doc.getElementsByTagName("web-app");
        for (int i = 0; cont && i < webapps.getLength(); ++i) {
            NamedNodeMap attrs = webapps.item(i).getAttributes();
            Node application = attrs.getNamedItem("application");
            Node name = attrs.getNamedItem("name");
            Node root = attrs.getNamedItem("root");
            this.log("application=" + application.getNodeValue() + ", name=" + name.getNodeValue() + ", root=" + root.getNodeValue());
            if (!application.getNodeValue().equalsIgnoreCase("ascontrol") || !name.getNodeValue().equalsIgnoreCase("ascontrol")) continue;
            this.setEMRoot(root.getNodeValue());
            cont = false;
            ret = true;
        }
        return ret;
    }

    private boolean isASCDefaultWebApp(Document doc) {
        Node defaultWebAppNode = doc.getElementsByTagName("default-web-app").item(0);
        String defaultWebAppName = defaultWebAppNode.getAttributes().getNamedItem("name").getNodeValue();
        String defaultWebAppApplication = defaultWebAppNode.getAttributes().getNamedItem("application").getNodeValue();
        this.log("default-web-app, application=" + defaultWebAppApplication + ", name=" + defaultWebAppName);
        if (defaultWebAppApplication.equalsIgnoreCase("ascontrol") && defaultWebAppName.equalsIgnoreCase("ascontrol")) {
            this.log("Found ascontrol in the default-web-app");
            this.setEMRoot("/");
            return true;
        }
        return false;
    }

    public String getLaunchLocation() {
        this.parseServerXML();
        if (this.isValid()) {
            if (this.isASCDeployed()) {
                if (this.isASCStarted()) {
                    if (this.isASCBound()) {
                        return this.constructEMURL();
                    }
                    return "Application Server Control is not bound on this OC4J instance";
                }
                return "Application Server Control is not started on this OC4J instance";
            }
            return "Application Server Control is not deployed on this OC4J instance";
        }
        return "Application Server Control is not available on this OC4J instance";
    }

    private String constructEMURL() {
        String emurl = "<a href=\"%ASCLINK%\" target=\"_blank\">Launch</a> Application Server Control";
        StringBuffer asclink = new StringBuffer();
        if (this.isBehindOHS()) {
            asclink.append(this.getEMRoot());
        } else {
            asclink.append("http://").append(this.getServername()).append(":").append(this.getEMPort()).append(this.getEMRoot());
        }
        this.log("getEMURL, asclink=" + asclink.toString());
        emurl = emurl.replaceAll("%ASCLINK%", asclink.toString());
        return emurl;
    }

    private String constructWebSiteFilePath(String filename) {
        String path = CONFIG_DIR + SEP + filename;
        return path;
    }

    private void displayAttributes(NamedNodeMap attrs) {
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node attr = attrs.item(i);
                this.log(attr.getNodeName() + " " + attr.getNodeValue());
            }
        }
    }

    private void log(String msg) {
    }

    private void log(Exception e) {
    }

    public String getServername() {
        return this.m_Servername;
    }

    public void setServername(String serverName) {
        this.m_Servername = serverName;
    }

    public String getRequestClassname() {
        return this.m_RequestClassname;
    }

    public void setRequestClassname(String classname) {
        this.m_RequestClassname = classname;
    }

    private void setFilename(String xmlfile) {
        this.m_Filename = xmlfile;
    }

    private String getFilename() {
        return this.m_Filename;
    }

    private void setValid(boolean value) {
        this.m_Valid = value;
    }

    private boolean isValid() {
        return this.m_Valid;
    }

    String getEMRoot() {
        return this.m_EMRoot;
    }

    void setEMRoot(String emRoot) {
        this.m_EMRoot = emRoot;
    }

    String getEMPort() {
        return this.m_EMPort;
    }

    void setEMPort(String emPort) {
        this.m_EMPort = emPort;
    }

    NodeList getApplicationSet() {
        return this.m_Applications;
    }

    void setApplicationSet(NodeList applications) {
        this.m_Applications = applications;
    }

    NodeList getWebSiteSet() {
        return this.m_WebSites;
    }

    void setWebSiteSet(NodeList webSites) {
        this.m_WebSites = webSites;
    }

    private void run(String[] args) {
        if (J2EE_HOME == null) {
            System.out.println("Error: oracle.j2ee.home is not set, run with:\n");
            System.out.println("       java -Doracle.j2ee.home=<J2EE_HOME_DIR> " + this.getClass().getName() + "\n");
            System.exit(-1);
        }
        this.setServername("fred.example.com");
        System.out.println("*** TEST ONE ***");
        System.out.println("Launch location: " + this.getLaunchLocation());
        System.out.println("*** /TEST ONE *** ");
        System.out.println("*** TEST TWO ***");
        System.out.println("is AJP? : " + this.isBehindOHS());
        this.setRequestClassname("com.evermind.server.http.HttpServletRequest");
        System.out.println("setting requestclassname to com.evermind.server.http.HttpServletRequest");
        System.out.println("is AJP? : " + this.isBehindOHS());
        this.setRequestClassname(AJP_REQUEST_MARKER);
        System.out.println("setting requestclassname to com.evermind.server.http.AJPHttpServletRequest");
        System.out.println("is AJP? : " + this.isBehindOHS());
        System.out.println("*** /TEST TWO ***");
    }

    public static void main(String[] args) {
        AscLinkBean bean = new AscLinkBean();
        bean.run(args);
    }
}

