create or replace package wmp_favorites_pages as

	procedure show (
		p_page	in varchar2  := wmp_api_session.FAVORITES,
		p_group_id in varchar2 := null,
		p_action in varchar2 := null,
		p_repository in varchar2 := null,
		p_role_name in varchar := null,
		p_type in varchar := null,
		p_search in varchar := null,
		p_find_button in varchar2 := null,
		p_is_portlet in varchar2 := null,
		p_back_url in varchar2 := null, 
		p_reference_path in varchar2 := null,
		p_preference_path in varchar2 := null
		);
	
	procedure favorite_customize(
		p_request in varchar2 := null,
		p_repository in varchar2 := null,
		p_role_name  in varchar2 := null,
		p_type	in varchar2 := null,
		p_display_count in varchar2 := null,
		p_display_limit in varchar2 := null,
		p_display_desc	in varchar2 := null,
		p_display_path	in varchar2 := null,
		p_is_portlet in varchar2 := null,
		p_back_url in varchar2 := null,
		p_reference_path in varchar2 :=null
		
 		);
 		

	procedure show_customize (
		p_page	in varchar2  := wmp_api_session.FAVORITES,
		p_group_id in varchar2 := null,
		p_action in varchar2 := null,
		p_repository in varchar2 := null,
		p_role_name in varchar := null,
		p_type in varchar := null,
		p_search in varchar := null,
		p_find_button in varchar2 := null,
		p_is_portlet in varchar2 := null,
		p_back_url in varchar2 := null, 
		p_reference_path in varchar2 := null,
		p_first_show in boolean := false
		);

	procedure show_edit_favorite(
		p_favorite_id in number, 
		p_is_portlet in varchar2 := null,
		p_back_url in varchar2 := null, 
		p_reference_path in varchar2 := null
		);


	procedure redirect (
		p_group_id in varchar2 := null,
		p_action in varchar2 := null,
		p_back_url in varchar2, 
		p_reference_path in varchar2
		);
	
	procedure save_display_options (
		p_request in varchar2,
		P_DISPLAY_COUNT in varchar2,
		P_DISPLAY_LIMIT in varchar2 := null,
		P_DISPLAY_DESC in varchar2 := null,
		P_DISPLAY_PATH in varchar2 := null,
		P_minimize_navigation in varchar2 := null,
		P_minimize_report in varchar2 := null,
		p_repository in varchar2 := null,
		p_role_name in varchar := null,
		p_type in varchar := null,
		p_search in varchar := null,
		p_is_portlet in varchar2 := null,
		p_back_url in varchar2 := null, 
		p_reference_path in varchar2 := null
		);

	function path(p_repository_id in number, p_role in varchar2, p_type_name in varchar2, p_id in number)	
	return varchar2;
	
  	function navigation_hlink(p_repository_id in number, p_role in varchar2, p_type_name in varchar2, p_id in number) 
	return varchar2;

	function report_hlink(p_repository_id in number, p_role in varchar2, p_type_name in varchar2, p_id in number, p_report_helper in varchar2, p_report_category in varchar2, p_report_name in varchar2, p_nls_flag in varchar2 := wmp_api_session.YES) 
	return varchar2;	

	procedure show_edit_page (
		p_page  in varchar2  := wmp_api_session.EDIT,
		p_group_id in varchar2 := null,
		p_action in varchar2 := null,
		p_repository in varchar2 := null,
		p_role_name in varchar := null,
		p_type in varchar := null,
		p_find_button in varchar2 := null,
		p_is_portlet in varchar2 := null,
		p_back_url in varchar2 := null, 
		p_reference_path in varchar2 := null,
		p_preference_path in varchar2 := null
		);

end wmp_favorites_pages;