begin 

declare 
	l_username varchar2(100) := '~logicalUser';
	l_portalSchema_public varchar2(100);

	procedure populate_person(p_user_name in varchar2) 
	is
		l_sso_schema varchar2(100) := null;
	begin
		select wwctx_api.get_sso_schema into l_sso_schema from dual;

		execute immediate '
      insert into wwsec_person
      (
      DISPLAY_PERSONAL_INFO          ,
      NOTIFICATION_PREFERENCE        ,
      USER_NAME                      ,
      DB_USER                        ,
      EMPNO                          ,
      LAST_NAME                      ,
      FIRST_NAME                     ,
      MIDDLE_NAME                    ,
      KNOWN_AS                       ,
      MAIDEN_NAME                    ,
      DATE_OF_BIRTH                  ,
      EMAIL                          ,
      WORK_PHONE                     ,
      HOME_PHONE                     ,
      MOBILE_PHONE                   ,
      PAGER                          ,
      FAX                            ,
      OFFICE_ADDR1                   ,
      OFFICE_ADDR2                   ,
      OFFICE_ADDR3                   ,
      OFFICE_CITY                    ,
      OFFICE_STATE                   ,
      OFFICE_ZIP                     ,
      OFFICE_COUNTRY                 ,
      HOME_ADDR1                     ,
      HOME_ADDR2                     ,
      HOME_ADDR3                     ,
      HOME_CITY                      ,
      HOME_STATE                     ,
      HOME_ZIP                       ,
      HOME_COUNTRY                   ,
      IMAGE                          ,
      ORGANIZATION                   ,
      TITLE                          ,
      SPENDING_LIMIT                 ,
      HIREDATE                       ,
      SOURCE                         ,
      MANAGER                        ,
      DEFAULT_GROUP                  
      )
      select 
      DISPLAY_PERSONAL_INFO          ,
      NOTIFICATION_PREFERENCE        ,
      USER_NAME                      ,
      DB_USER                        ,
      EMPNO                          ,
      LAST_NAME                      ,
      FIRST_NAME                     ,
      MIDDLE_NAME                    ,
      KNOWN_AS                       ,
      MAIDEN_NAME                    ,
      DATE_OF_BIRTH                  ,
      EMAIL                          ,
      WORK_PHONE                     ,
      HOME_PHONE                     ,
      MOBILE_PHONE                   ,
      PAGER                          ,
      FAX                            ,
      OFFICE_ADDR1                   ,
      OFFICE_ADDR2                   ,
      OFFICE_ADDR3                   ,
      OFFICE_CITY                    ,
      OFFICE_STATE                   ,
      OFFICE_ZIP                     ,
      OFFICE_COUNTRY                 ,
      HOME_ADDR1                     ,
      HOME_ADDR2                     ,
      HOME_ADDR3                     ,
      HOME_CITY                      ,
      HOME_STATE                     ,
      HOME_ZIP                       ,
      HOME_COUNTRY                   ,
      IMAGE                          ,
      ORGANIZATION                   ,
      TITLE                          ,
      SPENDING_LIMIT                 ,
      HIREDATE                       ,
      SOURCE                         ,
      MANAGER                        ,
      DEFAULT_GROUP                  
      from ' || l_sso_schema  || '.wwsec_person$
      where upper(user_name) = ''' || upper(p_user_name) || '''';
	end;

begin
	if l_username is not null and l_username <> chr(126) || 'logicalUser'
	then
		select wwctx_api.get_public_schema into l_portalSchema_public from dual;

		populate_person(p_user_name => l_username );

		~portalSchema.wwsec_api.modify_portal_user(
			p_user_name => l_username, 
			p_db_user => l_portalSchema_public,
			p_portal_user => 'Y', 
			p_display => 'Y', 
			p_Notification_Preference => 'MAILHTML');
	end if;

exception
	when others then
		null;
end;

end;