begin 

declare
	l_username varchar2(500) := '~logicalUser';
	l_passwd varchar2(500) := '~logicalPwd';
	l_sso_schema varchar2(100) := null;
	l_old_version boolean := false;
	
	procedure exec(p_stmt in varchar2)
	is
	begin
		execute immediate p_stmt;
	exception
		when others then null;
	end;
begin
	if l_username is not null and l_username <> chr(126) || 'logicalUser'
	then
		begin
			execute immediate '
	 			declare 
					l_guid varchar2(32);
				begin
					l_guid := wwsec_oid.create_user_entry (
						p_base => wwsec_oid.get_user_search_base,
						p_user_name => :1,
						p_password => :2
						);	
				end;'
			using l_username, lower(l_passwd);
		
		exception
			when others then
				l_old_version := true;
		end;
		
		if l_old_version 
		then
			select wwctx_api.get_sso_schema into l_sso_schema from dual;
			exec('declare
				v_err number;
				v_user ' || l_sso_schema  || '.sso_user_type;
			begin
				' || l_sso_schema || '.wwsso_ls_private.get_default_user_config (v_user); 
				v_user.ssousername := ''' || l_username || ''';
				v_user.hashed_password := ''' || l_passwd || ''';
				v_user.ssorole := ''USER'';
				' || l_sso_schema || '.wwsso_ls_private.ls_create_user(p_newuser => v_user, p_err => v_err);
			end;
			');
		end if;	
		
	end if;
 exception
	when others then
	null;
end;      

end;