declare
	v_err number;
	l_username varchar2(500) := '~logicalUser';
	l_sso_schema varchar2(100) := null;
	l_old_version boolean := false;
 
	procedure exec(p_stmt in varchar2)
	is
	begin
		execute immediate p_stmt;
	exception
		when others then null;
	end;
begin
	if l_username is not null and l_username <> chr(126) || 'logicalUser'
	then
		begin       
    			execute immediate '
	 			declare
	 				l_id number; 
	 				l_dn varchar2(4000);
	 			begin
					l_id := wwsec_api.id( p_user_name =>:1, p_userguid=>null );
					l_dn := wwsec_api_private.get_local_user_DN( l_id );
					wwsec_oid.delete_entry (
					p_dn => l_dn
					);	
	 			end;' 
	 		using l_username;
	 	exception
			when others then
				l_old_version := true;
		end;
		 
		if l_old_version
		then
			select wwctx_api.get_sso_schema into l_sso_schema from dual;

			exec('	declare
					v_err number;
				begin
					' || l_sso_schema  || '.wwsso_ls_private.ls_delete_user(
					p_ssouser => ''' || l_username  || ''', 
					p_error => v_err
				);					
				end;
			');
		end if;
	end if;	
exception
	when others then null;
end;
