declare 
	type CurType is ref cursor;

	procedure lp_drop_style(p_style in varchar2)
	is
		l_style_id number := 0;
		l_count number := 0;
		l_cur CurType;
	begin
		begin
			open l_cur for '
				select	a.id
				from	~portalSchema.wwpob_style$ a
					,~portalSchema.wwnls_strings$ b
				where	a.title_id = b.id
				and	b.text_string = ''' || p_style || ''' 
				and	b.language = ''' || wwnls_api.AMERICAN || '''
				';
			fetch l_cur into l_style_id;
			close l_cur;
			
		exception
			when others then
				l_style_id := -1;
		end;
		
		if l_style_id >= 0 
		then
			execute immediate 'begin wwpob_api_style.delete_style (:1); end;' using l_style_id;
		else
			execute immediate 
				 '
				 declare 
				 	l_id number := 0;
				 begin	
				 	l_id := wwv_settingsdb.GetSettingsSetID(
						p_settingssetname=> :1,
						p_siteid =>0
						);
					wwv_settingsdb.delete_style(l_id, 0);
				 end;'
				 using upper(p_style);
		end if;
		
		exception
		when others then
		return;
	end;
begin
	lp_drop_style('OWB_Browser_Navigation_Style_~userSchema');
	lp_drop_style('OWB_Browser_Report_Style_~userSchema');
	-- null;
	
end;
