declare
	l_user_id number;
	l_repository_id number;
	l_username varchar2(500) := '~logicalUser';
begin	
	if l_username is not null and l_username <> chr(126) || 'logicalUser'
	then
		begin
			select repository_id into l_repository_id from wmp_repositories where name = 'Warehouse Builder';
		exception
			when others then
				return;
		end;
		l_user_id := ~portalSchema.wwsec_api.id('~logicalUser');

		wmp_api_administration.grant_repository_to_user(l_repository_id, l_user_id);
		wmp_api_administration.grant_role_to_user('wmp_user', l_user_id);
		wmp_api_administration.grant_portlet_to_user('wmp_launcher_portlet', l_user_id);
		wmp_api_administration.grant_portlet_to_user('wmp_navigator_portlet', l_user_id);
		wmp_api_administration.grant_portlet_to_user('wmp_reports_portlet', l_user_id);
		wmp_api_administration.grant_portlet_to_user('wmp_favorites_portlet', l_user_id);
		wmp_api_administration.grant_portlet_to_user('wmp_administrator_portlet', l_user_id);
	end if;
exception
	when others then
		null;
end;
