declare
    l_prov_rec     wwpro_api_provider_registry.provider_record;
    l_prov_id      integer;
begin
    --|browser provider: DATABASE provider
    begin
      l_prov_rec.name                 := upper('~userSchema') || '_Design_Provider';
      l_prov_rec.display_name         := upper('~userSchema') || ' Warehouse Builder Design Provider';
      l_prov_rec.timeout              := 100;
      l_prov_rec.timeout_msg          := 'The provider timed out';
      l_prov_rec.implementation_style := wwpro_api_provider_registry.DATABASE_IMPL;
      l_prov_rec.implementation_owner := '~userSchema';
      l_prov_rec.implementation_name  := 'wmp_provider';
      l_prov_rec.language             := 'us';
      l_prov_rec.enable_distribution  := true;
      l_prov_rec.login_frequency      := wwpro_api_provider_registry.LOGIN_FREQUENCY_NEVER;
      l_prov_rec.created_on           := sysdate;
      l_prov_rec.created_by           := '~userSchema';
      l_prov_rec.last_updated_on      := sysdate;
      l_prov_rec.last_updated_by      := '~userSchema';

      l_prov_id := wwpro_api_provider_registry.register_provider(l_prov_rec);
    exception
      when others 
        null;
    end;

    --|runtime provider: WEB provider
    begin
      l_prov_rec.name                 := upper('~userSchema') || '_Runtime_Provider';
      l_prov_rec.display_name         := upper('~userSchema') || ' Warehouse Builder Runtime Provider';
      l_prov_rec.timeout              := 100;
      l_prov_rec.timeout_msg          := 'The provider timed out';
      l_prov_rec.implementation_style := wwpro_api_provider_registry.WEB_IMPL;
      l_prov_rec.implementation_owner := '~userSchema';
      l_prov_rec.implementation_name  := 'wmp_provider';
      l_prov_rec.language             := 'us';
      l_prov_rec.enable_distribution  := true;
      l_prov_rec.login_frequency      := wwpro_api_provider_registry.LOGIN_FREQUENCY_NEVER;
      l_prov_rec.created_on           := sysdate;
      l_prov_rec.created_by           := '~userSchema';
      l_prov_rec.last_updated_on      := sysdate;
      l_prov_rec.last_updated_by      := '~userSchema';

      l_prov_id := wwpro_api_provider_registry.register_provider(l_prov_rec);
    exception
      when others 
        null;
    end;
    
end;
