Rem
Rem $Header: ctx_src_2/src/dr/admin/ctx_beta2up_112.sql /main/4 2009/06/03 11:28:22 surman Exp $
Rem
Rem ctx_beta2up_112.sql
Rem
Rem Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved. 
Rem
Rem    NAME
Rem      ctx_beta2up_112.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      This script upgrades from 11.2BETATWO to 11.2 Production
Rem
Rem    NOTES
Rem      This script is currently empty
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    surman      06/01/09 - 8323978: Ignore ORA-4080 error
Rem    surman      05/28/09 - 8323978: Drop map triggers on upgrade
Rem    wclin       05/14/09 - execute as ctxsys
Rem    shorwitz    04/01/09 - Bug 4860137
Rem    rpalakod    03/30/09 - 11.2Beta2 upgrade
Rem    rpalakod    03/30/09 - Created
Rem

REM ===================================================================
REM This script is ALWAYS run as SYS,  must set current_schema to CTXSYS 
REM before upgrading CTX
REM ===================================================================
ALTER SESSION SET CURRENT_SCHEMA = CTXSYS; 


REM ===================================================================
REM WILDCARD_MAXTERMS
REM ===================================================================

update dr$object_attribute
  set oat_val_min = 0
  where oat_id = 70106;
commit;

REM ==================================================================
REM 8323978: Drop map triggers
REM ==================================================================
set serveroutput on

declare
  cursor all_indexes is
    select username, idx_name, idx_id,
           ixp_name, ixp_id
      from dba_users u, ctxsys.dr$index i, ctxsys.dr$index_partition p
      where i.idx_id = p.ixp_idx_id (+)
        and u.user_id = i.idx_owner#;

  sql_string varchar2(400);
begin
  for rec in all_indexes loop
    if (ctxsys.drixmd.IndexHasPTable(rec.idx_id)) then
      if rec.ixp_name is null then
        dbms_output.put_line('dropping trigger for index ' || rec.username ||
        '.' || rec.idx_name);
      else
        dbms_output.put_line('dropping trigger for index ' || rec.username ||
        '.' || rec.idx_name || ', partition ' || rec.ixp_name);
      end if;

      sql_string := 'drop trigger ' ||
        ctxsys.driutl.make_pfx(rec.username, rec.idx_name, 'T', rec.ixp_id) ||
        'M"';
      begin
        execute immediate sql_string;
      exception
        when others then
          if sqlcode != -4080 then
            -- ignore "trigger does not exist" error
            raise;
          end if;
      end;
    end if;
  end loop;
end;
/

REM =======================================================================
REM must reset current_schema to SYS
REM =======================================================================
ALTER SESSION SET CURRENT_SCHEMA = SYS;

