Rem
Rem $Header: ctxu1100.sql 09-jun-2008.13:51:47 rpalakod Exp $
Rem
Rem ctxu1100.sql
Rem
Rem Copyright (c) 2005, 2008, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ctxu1100.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      upgrade from 11.0.0.0 to latest version
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rpalakod    06/07/08 - 11.2
Rem    rpalakod    01/10/08 - add ent_ext_dict_obj 
Rem    gkaminag    10/16/05 - 
Rem    gkaminag    10/10/05 - gkaminag_fixlrg_051010
Rem    gkaminag    10/10/05 - Created
Rem

REM ========================================================================
REM set schema, Registry to upgrading state
REM ========================================================================

ALTER SESSION SET CURRENT_SCHEMA = CTXSYS;

begin
dbms_registry.upgrading('CONTEXT','Oracle Text','validate_context','CTXSYS');
end;
/

REM ========================================================================
REM 
REM ******************* Begin SYS changes **********************************
REM
REM ========================================================================

ALTER SESSION SET CURRENT_SCHEMA = SYS;
@@s1100000.sql
ALTER SESSION SET CURRENT_SCHEMA = CTXSYS;

REM ========================================================================
REM 
REM ******************* End SYS changes ************************************
REM
REM ========================================================================

REM ========================================================================
REM 
REM ******************* Begin CTXSYS schema changes ************************
REM
REM ========================================================================

REM ========================================================================
REM Pre-upgrade steps
REM ========================================================================

@@ctxpreup.sql

REM ========================================================================
REM 11.0 to 11.2
REM ========================================================================

@@u1100000.sql
@@t1100000.sql

REM ========================================================================
REM Post-upgrade steps
REM ========================================================================

@@ctxposup.sql

ALTER SESSION SET CURRENT_SCHEMA = CTXSYS;

REM ========================================================================
REM special case; default policy ENT_EXT_DICT_OBJ
REM ========================================================================

PROMPT creating default policy for ent_ext_dict_obj

declare
  errnum number;
begin
  CTX_DDL.create_policy('CTXSYS.ENT_EXT_DICT_OBJ',
    filter        => 'CTXSYS.NULL_FILTER',
    section_group => 'CTXSYS.NULL_SECTION_GROUP',
    lexer         => 'CTXSYS.BASIC_LEXER',
    stoplist      => 'CTXSYS.EMPTY_STOPLIST',
    wordlist      => 'CTXSYS.BASIC_WORDLIST'
);
exception
  when others then
    errnum := SQLCODE;
    if (errnum = -20000) then
      null;
    else
      raise;
    end if;
end;
/


REM ========================================================================
REM
REM ****************  End CTXSYS schema change *****************************
REM
REM ========================================================================

REM ========================================================================
REM Registry to upgraded state, reset schema
REM ========================================================================

begin
  dbms_registry.loaded('CONTEXT');
  dbms_registry.valid('CONTEXT');
end;
/

ALTER SESSION SET CURRENT_SCHEMA = SYS;

