Rem
Rem Copyright (c) 2000 by Oracle Corporation
Rem

begin
  declare
    procedure wait_for_not_available 
    is
      l_available number := 1;
      l_count number := 0;
    begin
      service_available(l_available);
      while l_available <> 0 and l_count < 32
      loop
        dbms_lock.sleep(2);
        service_available(l_available);
        l_count := l_count + 1;
      end loop;    
    end;
  begin
    wb_rt_service_management.disable_all;
    wait_for_not_available;
  exception
    when others
    then
      null;
  end;
end;
/

BEGIN
  dbms_aqadm.stop_queue(
    queue_name => 'WB_RT_SERVICE_QUEUE');
exception
  when others
  then
    null;
END;
/

BEGIN
  dbms_aqadm.stop_queue(
    queue_name => 'WB_RT_NOTIFY_QUEUE');
exception
  when others
  then
    null;
END;
/

BEGIN
  dbms_aqadm.stop_queue(
    queue_name => 'WB_RT_ACK_QUEUE');
exception
  when others
  then
    null;
END;
/

BEGIN
  dbms_aqadm.drop_queue(
    queue_name => 'WB_RT_SERVICE_QUEUE');
exception
  when others
  then
    null;
END;
/

BEGIN
  dbms_aqadm.drop_queue(
    queue_name => 'WB_RT_NOTIFY_QUEUE');
exception
  when others
  then
    null;
END;
/

BEGIN
  dbms_aqadm.drop_queue(
    queue_name => 'WB_RT_ACK_QUEUE');
exception
  when others
  then
    null;
END;
/

BEGIN
  dbms_aqadm.drop_queue_table (
    queue_table => 'WB_RT_SERVICE_QUEUE_TAB',
    force => true);
exception
  when others
  then
    null;
END;
/

BEGIN
  dbms_aqadm.drop_queue_table (
    queue_table => 'WB_RT_NOTIFY_QUEUE_TAB',
    force => true);   
exception
  when others
  then
    null;
END;
/

BEGIN
  dbms_aqadm.drop_queue_table (
    queue_table => 'WB_RT_ACK_QUEUE_TAB',
    force => true);   
exception
  when others
  then
    null;
END;
/

begin
  execute immediate 'drop trigger wb_rt_database_startup_trigger';
exception
  when others
  then
    null;
end;
/
commit;

begin
  for l in 
  (
    select 
      db_link 
    from 
      user_db_links 
    where 
      db_link like '%@WB_RT_SELF_LINK'
  )
  loop
    execute immediate 'drop database link ' || l.db_link;
  end loop;
end;
/
commit;


begin
  execute immediate 'drop sequence wb_rt_notify_priority_seq';
exception
  when others
  then
    null;
end;
/
commit;

begin
  execute immediate 'drop type wb_rt_acknowledge_t';
exception
  when others
  then
    null;
end;
/
commit;

begin
  execute immediate 'drop type wb_rt_notify_t';
exception
  when others
  then
    null;
end;
/
commit;

begin
  execute immediate 'drop type wb_rt_service_request_t';
exception
  when others
  then
    null;
end;
/
commit;

begin
  execute immediate 'drop sequence wb_rt_notification_seq';
exception
  when others
  then
    null;
end;
/
commit;

begin
  execute immediate 'drop sequence wb_rt_node_seq';
exception
  when others
  then
    null;
end;
/
commit;

begin
  execute immediate 'drop table wb_rt_service_job_logs cascade constraints';
exception
  when others
  then
    null;
end;
/
commit;

begin
  execute immediate 'drop table wb_rt_service_control_flags cascade constraints';
exception
  when others
  then
    null;
end;
/
commit;

begin
  execute immediate 'drop table wb_rt_notification_streams cascade constraints';
exception
  when others
  then
    null;
end;
/
commit;

begin
  execute immediate 'drop table wb_rt_notification_components cascade constraints';
exception
  when others
  then
    null;
end;
/
commit;

begin
  execute immediate 'drop table wb_rt_notification_acks cascade constraints';
exception
  when others
  then
    null;
end;
/
commit;

begin
  execute immediate 'drop table wb_rt_binary_context_attrs cascade constraints';
exception
  when others
  then
    null;
end;
/
commit;

begin
  execute immediate 'drop table wb_rt_textual_context_attrs cascade constraints';
exception
  when others
  then
    null;
end;
/
commit;

begin
  execute immediate 'drop table wb_rt_service_nodes cascade constraints';
exception
  when others
  then
    null;
end;
/
commit;

begin
  execute immediate 'drop table wb_rt_nls_messages cascade constraints';
exception
  when others
  then
    null;
end;
/
commit;

begin
  execute immediate 'drop table wb_rt_temporary_clobs';
exception
  when others
  then
    null;
end;
/
commit;
