grant connect to %user;
grant owb_a_%repo_user to %user;

begin
  declare
    l_this_role varchar2(30) := upper('owb_a_%repo_user');
    l_default_roles varchar2(4000);
    l_this_user varchar2(30) := upper('%user');
  begin
    for r in (
      select 
        granted_role 
      from
        dba_role_privs 
      where 
        grantee = l_this_user and
        default_role = 'YES' and
        granted_role <> l_this_role
    )
    loop

      if l_default_roles is null
      then
        l_default_roles := r.granted_role;
      else
        l_default_roles := l_default_roles || ',' || r.granted_role;
      end if;

    end loop;
    
    if l_default_roles is not null
    then 
      execute immediate 'alter user %user default role ' || l_default_roles;
    end if;

  end;
end;
/
