set echo off
set verify off
set serveroutput on

define FCOSYNONYM = &1.

rem ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
rem MIGRATE TIME_STAMPS INTO DESIGN REPOSITORY
rem &1 is the name of the synonym used to access the source Design Repository
rem Invoke this file in the target Design Repository account.
rem ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

declare
  -- cursor to get fco timestamps from old repos 
  cursor c_getOldFcos is 
    select name, uoid, updatetimestamp, updatedby, notm
	from &FCOSYNONYM. -- synonym name for firstclassobject_v
    where seeded = 0;	
	
  -- Commit frequency 
  COMMIT_FREQ NUMBER := 200;
  
  -- Commit counter
  commitCount NUMBER := 0;
  
begin
  -- loop through all the 'old' fcos
  for oldFco in c_getOldFcos loop
  
    -- update the equivalent fco in the new repos
    update cmpallclasses newFco
      set  newFco.d_2 = oldFco.updatetimestamp,
	       newFco.s1_2 = oldFco.updatedby,
		   newFco.i_2 = oldFco.notm 
	  where newFco.s2_5 = oldFco.uoid
	  and newFco.s2_4 = oldFco.name;


	-- commit periodically to prevent blowing rollback  
     commitCount := commitCount + 1;
	if commitCount > COMMIT_FREQ then
	  commit;
      commitCount := 0;
	end if;
	
  end loop;
  
  -- perform a final commit
  commit;
end;
/
