begin
  declare

    function wait_for_is_available 
    return number
    is
      l_available number;
      l_org_log_count number;
      l_log_count number;
      l_count number := 0;      
    begin

      service_available(l_available);
      
      select
        count(*)
      into
        l_log_count
      from
        wb_rt_service_job_logs;
      l_org_log_count := l_log_count;
      
      while l_available = 0 and l_log_count = l_org_log_count and l_count < 90
      loop
        dbms_lock.sleep(2);
        service_available(l_available);
        select
          count(*)
        into
          l_log_count
        from
          wb_rt_service_job_logs;
        l_count := l_count + 1;

      end loop;

      return l_available;
    end;

  begin

    wb_rt_service_management.enable_all(wb_rt_constants.STARTUP_KIND_MANUAL);
    commit;

    if wait_for_is_available = 0
    then
      for m in (
        select
          message
        from
          wb_rt_service_job_logs
        order by
          time_stamp desc
      )
      loop
        raise_application_error(-20001, m.message);
      end loop;

      raise_application_error(-20001, 'service startup timeout');

    end if;

    commit;

  end;
end;
/

