begin
  execute immediate 'create table OWBRTPS (' ||
  '  KEY VARCHAR2(35) NOT NULL,' ||
  '  VALUE VARCHAR2(255) NOT NULL,' ||
  '  UNIQUE (KEY)' ||
  '  )';
  
exception
  when others
  then
    if sqlcode <> -955 -- name already used by existing object
    then
      raise;
    end if;
end;
/

begin
  execute immediate 'create table RAW_OWBREPOS (' ||
  '  SCHEMANAME VARCHAR2(30) NOT NULL,' ||
  '  VERSION_NO VARCHAR2(30) NOT NULL,' ||
  '  UNIQUE (SCHEMANAME)' ||
  '  )';
  
exception
  when others
  then
    if sqlcode <> -955 -- name already used by existing object
    then
      raise;
    end if;
end;
/

begin
  execute immediate 'create or replace view OWBREPOS' ||
  '  as' ||
  '    select' ||
  '      UPPER(r.SCHEMANAME) as SCHEMANAME,' ||
  '      r.VERSION_NO' ||
  '    from' ||
  '      RAW_OWBREPOS r,' ||
  '      ALL_USERS u' ||
  '    where' ||
  '      UPPER(r.SCHEMANAME) = u.USERNAME';
  
end;
/
  