CREATE OR REPLACE DIRECTORY OWBTEMP AS '%owb_admin_home';

CREATE OR REPLACE FUNCTION validate_owbhome ( v in varchar2) RETURN varchar2 IS
  l_file      utl_file.file_type;
  l_text      VARCHAR2(256);
  l_version     VARCHAR2(20) := v;
  l_match     VARCHAR2(50) :='invalid';
BEGIN
  BEGIN
    l_file := UTL_FILE.fopen('OWBTEMP', 'Compatibility.properties', 'r', 256);
  EXCEPTION
    WHEN OTHERS THEN
      RETURN 'File cannot be opened.';
  END;

  BEGIN
    LOOP
      UTL_FILE.get_line(l_file, l_text, 256);

      IF INSTR(l_text,l_version)>0 THEN
        l_match := 'valid';
        exit;
      end if;

    END LOOP;
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      DBMS_OUTPUT.put_line('Execepion when executing get_line(): ' || SQLCODE ||': '|| SQLERRM);
  END;

  utl_file.fclose(l_file);
  return l_match;
END;
/


