Rem
Rem Copyright (c) 2000, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem

create or replace package wb_rt_api_exec is
    
  TASK_TYPE_PLSQL constant number := 1;
  TASK_TYPE_SQL_LOADER constant number := 2;
  TASK_TYPE_PROCESS constant number := 3;
  TASK_TYPE_SAP constant number := 4;
  TASK_TYPE_DATA_AUDITOR constant number := 5;
  TASK_TYPE_SCHEDULED_JOB constant number := 6;
  
  PARAMETER_KIND_CUSTOM constant number := 1;
  PARAMETER_KIND_SYSTEM constant number := 2;
  
  RESULT_SUCCESS constant number := 1;
  RESULT_WARNING constant number := 2;
  RESULT_FAILURE constant number := 3;
  
  PARAM_SCOPE_GLOBAL constant number := 1;
  PARAM_SCOPE_SHARED constant number := 2;
  PARAM_SCOPE_PARAM constant number := 3;
  PARAM_SCOPE_LOCAL constant number := 4;

  VALUE_KIND_LITERAL constant number := 1;
  VALUE_KIND_EXPRESSION constant number := 2;
  VALUE_KIND_EVAL_EXPR constant number := 3;
  VALUE_KIND_NOT_SET constant number := 4;

  function open_group
  (
    p_group_name in varchar2
  ) 
  return number;

  function open
  (
    p_audit_execution_group_id in number,
    p_task_type in number,
    p_map_name in varchar2, 
    p_location_name in varchar2
  ) 
  return number;
    
  function open
  (
    p_task_type in number,
    p_map_name in varchar2, 
    p_location_name in varchar2
  ) 
  return number;
    
  function open
  (
    p_audit_execution_group_id in number,
    p_task_type_name in varchar2, 
    p_task_name in varchar2,
    p_location_name in varchar2,
    p_exec_location_name in varchar2 := 'PlatformSchema'
  ) 
  return number;
    
  function open
  (
    p_task_type_name in varchar2, 
    p_task_name in varchar2,
    p_location_name in varchar2,
    p_exec_location_name in varchar2 := 'PlatformSchema'
  ) 
  return number;
        
  procedure override_input_parameter
  (
    p_audit_execution_id in number,
    p_parameter_name in varchar2,
    p_value in clob,
    p_parameter_kind in number := PARAMETER_KIND_CUSTOM,
    p_value_kind in number := null,
    p_parameter_scope in number := PARAM_SCOPE_PARAM
  ); 
  
  function execute
  (
    p_audit_execution_id number
  )
  return number;

  procedure execute_in_background
  (
    p_audit_execution_id in number
  );
  
  function get_output_parameter
  (
    p_audit_execution_id in number,
    p_parameter_name in varchar2,
    p_parameter_kind in number := PARAMETER_KIND_CUSTOM,
    p_parameter_scope in number := PARAM_SCOPE_PARAM
  )
  return varchar2; 
  
  function get_output_clob_parameter
  (
    p_audit_execution_id in number,
    p_parameter_name in varchar2,
    p_parameter_kind in number := PARAMETER_KIND_CUSTOM,
    p_parameter_scope in number := PARAM_SCOPE_PARAM
  )
  return clob; 
  
  procedure abort_and_close
  (
    p_audit_execution_id in number
  );

  procedure close
  (
    p_audit_execution_id number
  );

  /* 

   USAGE

   p_location_name := e.g. MY_WAREHOUSE  - Physical Name of the Location to which this task was deployed
                                           (i.e. a DB Location or a Process Location or the Platform Schema)
                                           Note: Always use "PlaformSchema" for SQL_LOADER and SAP types.

   p_task_type     := PLSQLMAP           - OWB PL/SQL Mapping
                   |  SQLLOADER          - OWB SQL*Loader Mapping
                   |  PROCESSFLOW        - OWB ProcessFlow
                   |  SAP                - OWB SAP Mapping
                   |  DATAAUDITOR        - OWB DataAuditor Mapping
                   |  SCHEDULEDJOB       - OWB Scheduled Object
		   |  CTMAPPING          - OWB Template Mapping

   p_task_name     := e.g. MY_MAPPING    - Physical Name of the Deployed Object. This can be optionally qualified
                                           by the name of a deployed parent, such as the Processflow Package name
                                           of a Processflow. A module name cannot be used here because it is not
                                           a deployable object.
                      e.g. MY_PKG/MY_PROC

   p_custom_params := { , | (name = value [, name = value]...)}
                      e.g. ","
                      or   MY_PARAM=1,YOUR_PARAM=true

   p_system_params := { , | (name = value [, name = value]...)}
                      e.g. ","
                      or   MY_PARAM=1,YOUR_PARAM=true

   p_oem_friendly  := 0 | 1
                      Effects the return value

   p_background  := 0 | 1
                      Runs task in background, Effects the return value

   RETURNS

     when p_background = 0 and
       when oem_friendly = 0:  1 if task reports SUCCESS, 2 if WARNING, 3 if ERROR
       when oem_friendly <> 0: 0 if task reports SUCCESS or WARNING, 3 if ERROR
     otherwise when p_background <> 0: 0 if task execution submitted otherwise 1.

  How to and use function:

  begin
    set role owb_d_OWB_REPOS., owb_o_OWB_REPOS.;
    dbms_output.put_line
    ('result '
      || to_char(<runtime repository owner>.wb_rt_api_exec.run_task
                 ( '<target location>'
                 , '<type: PLSQL, PROCESS, SQL_LOADER, SAP, or DATA_AUDITOR>'
                 , '<mapping or process name>'
                 , '<custom parameters>'
                 , '<system parameters>'
                 . '<normal or oem>'
                 )
                )
      ) ;
  end ;

  To run this script, a user has to have been granted roles OWB_D_<runtime
  repos owner> and OWB_O_<runtime repos owner>. The runtime access user
  will have these roles granted.

  */
  function run_task
  ( p_location_name in varchar2
  , p_task_type in varchar2
  , p_task_name in varchar2
  , p_custom_params in varchar2 default null
  , p_system_params in varchar2 default null
  , p_oem_friendly in number default 0
  , p_background in number default 0
  ) return number;
  
end wb_rt_api_exec;
/

