Rem
Rem Copyright (c) 2000, 2007, Oracle. All rights reserved.  
Rem

create or replace package wb_rt_api_server_exec is
    
  function PARAM_KIND_CUSTOM return number;
  function PARAM_KIND_SYSTEM return number;
  
  function RESULT_CATEGORY_SUCCESS return number;
  function RESULT_CATEGORY_WARNING return number;
  function RESULT_CATEGORY_FAILURE return number;
  
  function FORMAT_TEXT return number;
  function FORMAT_HTML return number;
  function FORMAT_OTHER return number;
  
  function MIME_TEXT return varchar2;
  function MIME_HTML return varchar2;
  function MIME_EAR return varchar2;
  
  function ENCODING_NONE return varchar2;
  function ENCODING_BASE64 return varchar2;
  
  function SEVERITY_INFORMATIONAL return number;
  function SEVERITY_WARNING return number;
  function SEVERITY_ERROR return number;
  function SEVERITY_RECOVERY return number;

  function PARAM_SCOPE_GLOBAL return number;
  function PARAM_SCOPE_SHARED return number;
  function PARAM_SCOPE_PARAM return number;
  function PARAM_SCOPE_LOCAL return number;

  function VALUE_KIND_LITERAL return number;
  function VALUE_KIND_EXPRESSION return number;
  function VALUE_KIND_EVAL_EXPR return number;
  function VALUE_KIND_NOT_SET return number;

  --
  -- Task Control
  --

  function open
  (
    p_parent_audit_id in number,
    p_object_uoid in varchar2,
    p_object_type in varchar2, 
    p_location_uoid in varchar2,
    p_task_name in varchar2,
    p_exec_location_uoid in varchar2
  ) 
  return number;
    
  function open
  (
    p_object_uoid in varchar2,
    p_object_type in varchar2, 
    p_location_uoid in varchar2,
    p_task_name in varchar2,
    p_exec_location_uoid in varchar2
  ) 
  return number;
        
  procedure close
  (
    p_audit_execution_id in number
  );

  --
  -- Execution
  --
  
  -- Execution Location

  function get_exec_location_type
  (
    p_audit_execution_id in number
  ) 
  return varchar2;
  
  -- Internal Exection
        
  function execute
  (
    p_audit_execution_id in number
  )
  return number;
  
  procedure execute_in_background
  (
    p_audit_execution_id in number
  );
  
  function execute_in_background_and_wait
  (
    p_audit_execution_id in number,
    p_wait_timeout in number := 0
  )
  return number;
  
  -- External Execution

  function notify_execution_start
  (
    p_audit_execution_id in number,
    p_start_operator in number := 1
  )
  return number;

  procedure notify_execution_complete
  (
    p_audit_execution_id in number,
    p_return_result in number,
    p_return_code in number,
    p_operator_started in number := 1
  );

  procedure abort_and_close
  (
    p_audit_execution_id in number,
    p_operator_started in number 
  );

  procedure expedite_and_close
  (
    p_audit_execution_id in number,
    p_return_result in number,
    p_return_code in number,
    p_operator_started in number 
  );

  --
  -- Context Attributes
  --
  
  procedure create_textual_attr
  (
    p_audit_id in number,
    p_attr_name in varchar2,
    p_attr_value in varchar2
  );


  function get_textual_attr
  (
    p_audit_id in number,
    p_attr_name in varchar2
  )
  return varchar2;

  --
  -- File Auditing
  --
  
  function get_task_input
  (
    p_audit_execution_id in number
  ) 
  return clob;
  

  function get_task_input_binary
  (
    p_audit_execution_id in number
  ) 
  return blob;
  

  function upload_task_file
  (
    p_audit_execution_id in number,
    p_file_type in varchar2,
    p_file_text in clob,
    p_mime_type in varchar2,
    p_encoding_type in varchar2 := null
  ) 
  return number;

  function upload_task_file
  (
    p_audit_execution_id in number,
    p_file_type in varchar2,
    p_file_binary in blob,
    p_mime_type in varchar2,
    p_encoding_type in varchar2 := null
  ) 
  return number;

  --
  -- Message Reporting
  --
  
  function task_message
  (
    p_audit_execution_id in number,
    p_severity in number
  ) 
  return number;  

  procedure message_line
  (
    p_audit_message_id in number,
    p_text in varchar2
  );

  function message_line
  (
    p_audit_message_id in number,
    p_key in varchar2,
    p_text in varchar2
  ) 
  return number;

  procedure message_line_parameter
  (
    p_audit_message_line_id in number,
    p_value in varchar2
  );
    
  function message_end
  (
    p_audit_message_id in number
  )
    return number;  
  
  --
  -- Parameter Manipulation
  --
  
  procedure override_input_parameter
  (
    p_audit_execution_id in number,
    p_parameter_name in varchar2,
    p_value in clob,
    p_parameter_kind in number := PARAM_KIND_CUSTOM,
    p_value_kind in number := null,
    p_parameter_scope in number := PARAM_SCOPE_PARAM
  ); 
  
  procedure set_output_parameter
  (
    p_audit_execution_id in number,
    p_parameter_name in varchar2,
    p_value in varchar2,
    p_parameter_kind in number := PARAM_KIND_CUSTOM,
    p_parameter_scope in number := PARAM_SCOPE_PARAM
  ); 
 
  procedure set_output_parameter
  (
    p_audit_execution_id in number,
    p_parameter_name in varchar2,
    p_value in clob,
    p_parameter_kind in number := PARAM_KIND_CUSTOM,
    p_parameter_scope in number := PARAM_SCOPE_PARAM
  ); 
 
  function get_input_parameter
  (
    p_audit_execution_id in number,
    p_parameter_name in varchar2,
    p_parameter_kind in number := PARAM_KIND_CUSTOM,
    p_parameter_scope in number := PARAM_SCOPE_PARAM
  )
  return varchar2; 
  
  function get_output_parameter
  (
    p_audit_execution_id in number,
    p_parameter_name in varchar2,
    p_parameter_kind in number := PARAM_KIND_CUSTOM,
    p_parameter_scope in number := PARAM_SCOPE_PARAM
  )
  return varchar2; 
  
  function get_output_clob_parameter
  (
    p_audit_execution_id in number,
    p_parameter_name in varchar2,
    p_parameter_kind in number := PARAM_KIND_CUSTOM,
    p_parameter_scope in number := PARAM_SCOPE_PARAM
  )
  return clob; 
  
  --
  -- Result Feedback
  --
  
  function get_return_result
  (
    p_audit_execution_id in number
  )
  return varchar2; 
  
  function get_return_result_category
  (
    p_audit_execution_id in number
  )
  return number; 
  
  function get_return_result_number
  (
    p_audit_execution_id in number
  )
  return number; 
  
  function get_return_code
  (
    p_audit_execution_id in number
  )
  return number;
  
  --
  -- Metadata
  --
  
  function get_execution_operator
  (
    p_audit_unit_id in number,
    p_object_uoid in varchar2,
    p_object_type in varchar2, 
    p_location_uoid in varchar2,
    p_task_name in varchar2,
    p_exec_location_uoid in varchar2
  ) 
  return number;

  function get_return_result_category
  (
    p_execution_operator_id in number,
    p_return_result varchar2
  )
  return number;

  function create_property
  (
    p_property_path in varchar2,
    p_property_value in clob,
    p_is_mutable in number
  )
  return number;

  procedure set_property
  (
    p_property_path in varchar2,
    p_property_value in clob
  );

  function get_runtime_id return varchar2;

  --
  -- Encryption
  --
  
  function encrypt
  (
    p_data in varchar2, 
    p_key in varchar2
  ) return varchar2;

  function decrypt
  (
    p_data in varchar2, 
    p_key in varchar2
  ) return varchar2;

--
-- The following 4 functions and 1 procedure originally in PACKAGE CDR_RT_API_EXEC
--
  FUNCTION GetNewStream RETURN NUMBER ;

  FUNCTION DropStream (pi_nStreamID IN NUMBER) RETURN BOOLEAN ;

  PROCEDURE Execute (pi_nAuditExecutionID IN NUMBER
                    ,pi_nStreamID         IN NUMBER) ;

  FUNCTION WaitOnStream (pi_nStreamID   IN NUMBER
                        ,po_nEventType OUT NOCOPY NUMBER
                        ,po_nAuditID   OUT NOCOPY NUMBER
                        ,po_nFocusID   OUT NOCOPY NUMBER) RETURN NUMBER ;

  function execute
  (
    p_audit_execution_id in  number,
    p_time_out_seconds   in  number,
    p_timed_out          out nocopy boolean
  )
  return number;

end wb_rt_api_server_exec;
/
