Rem
Rem Copyright (c) 2000, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem

create or replace package wb_rt_audit_shadow_table is 
  procedure populate_cache
  (
    p_target_schema in varchar2,
    p_table_name in varchar2,
    p_col in varchar2 := null,
    p_rowid in varchar2 := null
  );
  
  procedure purge_table
  (
    p_target_schema in varchar2,
    p_table_name in varchar2,
    p_rowid in varchar2 := null
  );    

  function count_audit_run
  (
    p_target_schema in varchar2,
    p_table_name in varchar2,
    p_run_id in number := null
  )
    return number;

  function count_audit_detail
  (
    p_target_schema in varchar2,
    p_table_name in varchar2,
    p_detail_id in number := null
  )
    return number;

  procedure populate_target_cache
  (
    p_schema in varchar2,
    p_table in varchar2,
    p_rowid in varchar2
  );
  
end;
/

