Rem
Rem $Header: wb_rt_bioinformatics.sql 20-may-2005.04:36:08 rkarri Exp $
Rem
Rem wb_rt_bioinformatics.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      wb_rt_bioinformatics.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      This sql seeds the data types needed for using the bioinformatics
Rem      table functions.
Rem    NOTES
Rem      
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rkarri      05/20/05 - 
Rem    rkarri      04/26/05 - rkarri_bug-4225256
Rem    rkarri      04/22/05 - Created
Rem


CREATE TYPE BLAST_SQL_TABLE_OF_NUMBERS AS TABLE OF NUMBER
;


CREATE OR REPLACE PACKAGE BIOINFORMATICS AS

  TYPE BLAST_MATCH_PLSQLRECORDTYPE IS RECORD
  (
    t_seq_id VARCHAR2(4000),
    score NUMBER,
    expect NUMBER
  );

  TYPE BLAST_ALIGN_PLSQLRECORDTYPE IS RECORD
  (
    t_seq_id VARCHAR2(4000),
    pct_identity NUMBER,
    alignment_length NUMBER,
    mismatches NUMBER,
    positives NUMBER,
    gap_openings NUMBER,
    gap_list BLAST_SQL_TABLE_OF_NUMBERS,
    q_seq_start NUMBER,
    q_frame NUMBER,
    q_seq_end NUMBER,
    t_seq_start NUMBER,
    t_seq_end NUMBER,
    t_frame NUMBER,  
    score_ NUMBER,
    expect_ NUMBER
   );

  TYPE BLAST_SEQUENCE_RECORD IS RECORD (
	seq_id VARCHAR2(4000),
	seq_data CLOB
	);

  TYPE ALIGN_PLS_TABLE_OF_RECORD IS TABLE OF BLAST_ALIGN_PLSQLRECORDTYPE;
  TYPE MATCH_PLS_TABLE_OF_RECORD IS TABLE OF BLAST_MATCH_PLSQLRECORDTYPE;

  TYPE BLAST_SEQUENCE_CURSOR IS REF CURSOR RETURN BLAST_SEQUENCE_RECORD;

END BIOINFORMATICS;


/
