CREATE OR REPLACE FUNCTION OWB$CDC$GET_TXNS_START_TIME (
                dblinkname IN VARCHAR2,
                objectlist IN VARCHAR2,
                currtime IN DATE) RETURN DATE AUTHID CURRENT_USER AS
    retval DATE := NULL;
    accessname VARCHAR2 (128) := ' ';
BEGIN
    BEGIN
        IF dblinkname IS NOT NULL THEN
            accessname := '@'||dblinkname;
        END IF;
        execute immediate
        'select min(to_date(t.start_time, ''MM/DD/YY HH24:MI:SS''))
           from v$transaction'   || accessname || ' t,
                v$locked_object' || accessname || ' l,
                all_objects'     || accessname || ' o
           where (o.object_name, o.owner) in (' || objectlist || ')
            and o.object_id = l.object_id
            and l.xidsqn = t.xidsqn'  into retval;
        IF retval IS NULL OR retval > currtime THEN
            retval := currtime;
        END IF;
    EXCEPTION
      WHEN OTHERS THEN
        retval := NULL;
    END;
    RETURN retval;
END;
/


CREATE OR REPLACE FUNCTION OWB$CDC$GET_LATEST_UB (dblinkname IN VARCHAR2,
        objectlist IN VARCHAR2, currtime IN DATE, lowerbound DATE,
        txnwaittime INTEGER, longtxnwaittime INTEGER) RETURN DATE IS
    retval DATE;
BEGIN
    IF lowerbound >= currtime THEN
        return lowerbound;
    END IF;
    retval := OWB$CDC$GET_TXNS_START_TIME(dblinkname, objectlist, currtime);
    IF retval IS NOT NULL THEN
        DECLARE
            interval_1 NUMBER;
            interval_2 NUMBER;
        BEGIN
            interval_1 := currtime - lowerbound;
            interval_2 := currtime - retval;
            IF  interval_2 > (interval_1/4) THEN
                DBMS_LOCK.SLEEP (longtxnwaittime);
                retval := OWB$CDC$GET_TXNS_START_TIME (
                            dblinkname, objectlist, currtime);
            END IF;
        END;
    END IF;

    IF retval IS NULL THEN
        retval := currtime - NUMTODSINTERVAL (txnwaittime, 'SECOND');
    END IF;
    IF lowerbound >= retval THEN
        return lowerbound;
    END IF;
    return retval;
END;
/


CREATE OR REPLACE FUNCTION OWB$CDC$GET_LAST_DAY_UB  (currtime IN DATE) RETURN DATE IS
BEGIN
    RETURN trunc(currtime);
END;
/

CREATE OR REPLACE FUNCTION OWB$CDC$GET_LAST_DAY_LB  (currtime IN DATE) RETURN DATE IS
BEGIN
    RETURN trunc(currtime -1);
END;
/


CREATE OR REPLACE FUNCTION OWB$CDC$GET_LAST_WEEK_UB  (dblinkname IN VARCHAR2,
        currtime IN DATE) RETURN DATE IS
    remotenlsterritory VARCHAR2 (128);
    localnlsterritory  VARCHAR2 (128);
    accessname         VARCHAR2 (123) := ' ';
    retval             DATE;
BEGIN
    IF dblinkname IS NOT NULL THEN
        accessname := '@' + dblinkname;
    END IF;

    SELECT value into localnlsterritory
    FROM nls_session_parameters WHERE PARAMETER = 'NLS_TERRITORY';
    execute immediate 'SELECT value FROM nls_database_parameters' || accessname
        || ' WHERE PARAMETER = ''NLS_TERRITORY''' into remotenlsterritory;
    execute immediate 'ALTER SESSION SET NLS_TERRITORY = ' || remotenlsterritory;
    retval := TRUNC (currtime);
    execute immediate 'ALTER SESSION SET NLS_TERRITORY = ' || localnlsterritory;
    return retval;
END;
/

CREATE OR REPLACE FUNCTION OWB$CDC$GET_LAST_WEEK_LB  (dblinkname IN VARCHAR2,
        currtime IN DATE) RETURN DATE IS
    remotenlsterritory VARCHAR2 (128);
    localnlsterritory  VARCHAR2 (128);
    accessname         VARCHAR2 (123) := ' ';
    retval             DATE;
BEGIN
    IF dblinkname IS NOT NULL THEN
        accessname := '@' + dblinkname;
    END IF;

    SELECT value into localnlsterritory
    FROM nls_session_parameters WHERE PARAMETER = 'NLS_TERRITORY';
    execute immediate 'SELECT value FROM nls_database_parameters' || accessname
        || ' WHERE PARAMETER = ''NLS_TERRITORY''' into remotenlsterritory;
    execute immediate 'ALTER SESSION SET NLS_TERRITORY = ' || remotenlsterritory;
    retval := TRUNC (currtime - 6);
    execute immediate 'ALTER SESSION SET NLS_TERRITORY = ' || localnlsterritory;
    return retval;
END;
/


CREATE OR REPLACE FUNCTION OWB$CDC$GET_LAST_MONTH_UB  (currtime IN DATE) RETURN DATE IS
BEGIN
    RETURN trunc (LAST_DAY (currtime - NUMTOYMINTERVAL (1, 'MONTH')) + 1);
END;
/

CREATE OR REPLACE FUNCTION OWB$CDC$GET_LAST_MONTH_LB  (currtime IN DATE) RETURN DATE IS
BEGIN
    RETURN trunc (LAST_DAY (currtime - NUMTOYMINTERVAL (2, 'MONTH'))+1);
END;
/

