Rem
Rem Copyright (c) 2000, 2007, Oracle. All rights reserved.  
Rem

create or replace package wb_rt_constants is

  function EVENT_TYPE_UNIT_OP_START return number;
  function EVENT_TYPE_UNIT_OP_COMPLETE return number;
  function EVENT_TYPE_EXEC_OP_START return number;
  function EVENT_TYPE_EXEC_OP_COMPLETE return number;
  function EVENT_TYPE_SCRIPT_RUN_BEGIN return number;
  function EVENT_TYPE_SCRIPT_RUN_END return number;
  function EVENT_TYPE_TASK_BEGIN return number;
  function EVENT_TYPE_TASK_END return number;
  function EVENT_TYPE_FILE return number;
  function EVENT_TYPE_INFORMATIONAL return number;
  function EVENT_TYPE_WARNING return number;
  function EVENT_TYPE_ERROR return number;
  function EVENT_TYPE_RECOVERY return number;
  function EVENT_TYPE_PREPARED return number;
  function EVENT_TYPE_UNPREPARED return number;
  function EVENT_TYPE_TIMEOUT return number;
  
  function PARAM_TYPE_BOOLEAN return number;
  function PARAM_TYPE_CHAR return number;
  function PARAM_TYPE_DATE return number;
  function PARAM_TYPE_FLOAT return number;
  function PARAM_TYPE_NUMBER return number;
  function PARAM_TYPE_VARCHAR return number;
  function PARAM_TYPE_VARCHAR2 return number;
  function PARAM_TYPE_VARCHAR2_TF return number;
  function PARAM_TYPE_TIMESTAMP return number;
  function PARAM_TYPE_TIMESTAMP_TZ return number;
  function PARAM_TYPE_TIMESTAMP_LTZ return number;
  function PARAM_TYPE_BINARY_INTEGER return number;
  function PARAM_TYPE_PLS_INTEGER return number;
  function PARAM_TYPE_LOCATION_UOID return number;
  function PARAM_TYPE_OPERATING_MODE return number;
  function PARAM_TYPE_AUDIT_LEVEL return number;
  function PARAM_TYPE_ANY return number;
  function PARAM_TYPE_BINARY_DOUBLE return number;
  function PARAM_TYPE_BINARY_FLOAT return number;
  function PARAM_TYPE_INTERVAL_DY_TO_SEC return number;
  function PARAM_TYPE_INTERVAL_YR_TO_MO return number;
  function PARAM_TYPE_XMLTYPE return number;
  function PARAM_TYPE_CLOB return number;
  function PARAM_TYPE_BLOB return number;
  
  function PARAM_MODE_IN return number;
  function PARAM_MODE_OUT return number;
  function PARAM_MODE_INOUT return number;
  function PARAM_MODE_VARIABLE return number;

  function PARAM_KIND_SYSTEM return number;
  function PARAM_KIND_CUSTOM return number;
  
  function PARAM_VALUE_INPUT return number;
  function PARAM_VALUE_OUTPUT return number;

  function PARAM_SCOPE_GLOBAL return number;
  function PARAM_SCOPE_SHARED return number;
  function PARAM_SCOPE_PARAM return number;
  function PARAM_SCOPE_LOCAL return number;
  function PARAM_SCOPE_INNER return number;

  function VALUE_KIND_LITERAL return number;
  function VALUE_KIND_EXPRESSION return number;
  function VALUE_KIND_EVAL_EXPR return number;
  function VALUE_KIND_NOT_SET return number;
  
  function RESULT_CATEGORY_SUCCESS return number;
  function RESULT_CATEGORY_WARNING return number;
  function RESULT_CATEGORY_FAILURE return number;
  
  function ACTION_CREATE return number;
  function ACTION_DROP return number;
  function ACTION_UPGRADE return number;
  function ACTION_REPORT return number;
  
  function FORMAT_TEXT return number;
  function FORMAT_HTML return number;
  function FORMAT_OTHER return number;
  
  function MIME_TEXT return varchar2;
  function MIME_BINARY return varchar2;
  function MIME_HTML return varchar2;
  function MIME_EAR return varchar2;
  function ENCODING_NONE return varchar2;
  function ENCODING_BASE64 return varchar2;
  function ENCODING_UU return varchar2;
  function ENCODING_URI return varchar2;
  
  function STORAGE_TEXT return number;
  function STORAGE_BINARY return number;
  
  function SEVERITY_INFORMATIONAL return number;
  function SEVERITY_WARNING return number;
  function SEVERITY_ERROR return number;
  function SEVERITY_RECOVERY return number;

  function OPERATION_DEPLOY return number;
  function OPERATION_UNDO return number;
  
  function OBJECT_STATUS_VALID return number;
  function OBJECT_STATUS_INVALID return number;
  function OBJECT_STATUS_REMOVED return number;
  function OBJECT_STATUS_UNCERTAIN return number;
  
  function DEPLOYMENT_STATUS_INACTIVE return number;
  function DEPLOYMENT_STATUS_READY return number;
  function DEPLOYMENT_STATUS_COMPLETE return number;

  function UNIT_STATUS_INACTIVE return number;
  function UNIT_STATUS_READY return number;
  function UNIT_STATUS_BUSY_PREPARE return number;
  function UNIT_STATUS_BUSY_UNPREPARE return number;
  function UNIT_STATUS_BUSY_DEPLOY return number;
  function UNIT_STATUS_BUSY_UNDO return number;
  function UNIT_STATUS_BUSY_FINALIZE return number;
  function UNIT_STATUS_COMPLETE return number;
  
  function UNIT_OPS_NONE return number;
  function UNIT_OPS_PREPARE return number;
  function UNIT_OPS_DEPLOY return number;
  function UNIT_OPS_DEPLOY_OR_UNPREPARE return number;
  function UNIT_OPS_UNDO_OR_FINALIZE return number;
  function UNIT_OPS_DEPLOY_OR_FINALIZE return number;
  function UNIT_OPS_UNPREPARE return number;
  function UNIT_OPS_FINALIZE return number;

  function SCRIPT_STATUS_INACTIVE return number;
  function SCRIPT_STATUS_BUSY_DEPLOYING return number;
  function SCRIPT_STATUS_BUSY_UNDOING return number;
  
  function SCRIPT_RUN_STATUS_BUSY return number;
  function SCRIPT_RUN_STATUS_COMPLETE return number;
  function SCRIPT_RUN_STATUS_UNCERTAIN return number;
  function SCRIPT_RUN_STATUS_FAILED return number;
  function SCRIPT_RUN_STATUS_INACTIVE return number;
  
  function EXECUTION_STATUS_INACTIVE return number;
  function EXECUTION_STATUS_BUSY return number;
  function EXECUTION_STATUS_READY return number;
  function EXECUTION_STATUS_COMPLETE return number;
  
  function REQUEST_TYPE_PREPARE_UNIT return number;
  function REQUEST_TYPE_UNPREPARE_UNIT return number;
  function REQUEST_TYPE_DEPLOY_UNIT return number;
  function REQUEST_TYPE_UNDO_UNIT return number;
  function REQUEST_TYPE_FINALIZE_UNIT return number;
  function REQUEST_TYPE_EXECUTE return number;
  function REQUEST_TYPE_ABORT return number;
  function REQUEST_TYPE_COMPLETE return number;
  function REQUEST_TYPE_CLOSEDOWN return number;
  function REQUEST_TYPE_TIMEOUT return number;

  function STARTUP_KIND_AUTOMATIC return number;
  function STARTUP_KIND_MANUAL return number;
  function STARTUP_KIND_SKIP_VERS_CHECK return number;

  function FILE_ATTACHMENT_UNIT return number;
  function FILE_ATTACHMENT_SCRIPT_RUN return number;
  function FILE_ATTACHMENT_EXECUTION return number;

  function MESSAGE_ATTACHMENT_UNIT return number;
  function MESSAGE_ATTACHMENT_SCRIPT_RUN return number;
  function MESSAGE_ATTACHMENT_EXECUTION return number;

  function JOB_MODE_NORMAL return number;
  function JOB_MODE_SEMI_AUTOMATIC return number;
  function JOB_MODE_FULLY_AUTOMATIC return number;

  function ACK_TYPE_NONE return number;
  function ACK_TYPE_RECOVERIES return number;
  function ACK_TYPE_ERRORS return number;
  function ACK_TYPE_WARNINGS return number;

  function COMMAND_RETRY return number;
  function COMMAND_STOP return number;
  function COMMAND_CONTINUE return number;
  function COMMAND_DEFAULT return number;

  function ACCESS_MODE_DEFAULT return number;
  function ACCESS_MODE_MANAGED return number;
  function ACCESS_MODE_DEPARTMENTAL return number;
  function ACCESS_MODE_ENTERPRISE return number;
  function ACCESS_MODE_SHARED return number;

  function RESULT_SUCCESS return varchar2;
  function RESULT_WARNING return varchar2;
  function RESULT_FAILURE return varchar2;
  function RESULT_NUMBER_SUCCESS return number;
  function RESULT_NUMBER_WARNING return number;
  function RESULT_NUMBER_FAILURE return number;

  function DEFAULT_MIME_TYPE_TEXT return varchar2;
  function DEFAULT_MIME_TYPE_BINARY return varchar2;
  function DEFAULT_ENCODING_TYPE return varchar2;
  
  function RUNTIME_PLATFORM_TYPE return varchar2;
  function DEFAULT_STORE_VERSION return varchar2;
  function RUNTIME_PLATFORM_NAME return varchar2;
  function RUNTIME_PLATFORM_UOID return varchar2;
  function NATIVE_DEPLOYMENT_ADAPTER return varchar2;
  
  function OBJECT_TYPE_FOLDER return varchar2;
  
  function FORMAT_TYPE
  (
    p_mime_type in varchar2,
    p_encoding_type in varchar2
  )
  return number;
  
  function to_string(p_constant in number)
  return varchar2;
  
  function get_plsql_type(p_constant in number)
  return varchar2;
  
end wb_rt_constants;
/
