Rem
Rem Copyright (c) 2000, 2005, Oracle. All rights reserved.  
Rem

create or replace package wb_rt_conversions is

  function to_boolean(p_rep in clob) return boolean;
  function to_boolean(p_rep in number) return boolean;
  function to_boolean(p_rep in varchar2) return boolean;
  function from_boolean(p_value in boolean) return clob;
  function from_boolean(p_value in clob) return clob;
  function from_boolean(p_value in varchar2) return clob;

  function to_char(p_rep in clob) return varchar2;
  function to_char(p_rep in varchar2) return varchar2;
  function from_char(p_value in clob) return clob;
  function from_char(p_value in varchar2) return clob;

  function to_date(p_rep in clob) return date;
  function to_date(p_rep in varchar2) return date;
  function from_date(p_value in date) return clob;
  function from_date(p_value in timestamp_unconstrained) return clob;
  function from_date(p_value in timestamp_tz_unconstrained) return clob;
  function from_date(p_value in timestamp_ltz_unconstrained) return clob;
  function from_date(p_value in varchar2) return clob;
  function from_date(p_value in clob) return clob;
  
  function to_timestamp(p_rep in clob) return timestamp_unconstrained;
  function to_timestamp(p_rep in varchar2) return timestamp_unconstrained;
  function from_timestamp(p_value in date) return clob;
  function from_timestamp(p_value in timestamp_unconstrained) return clob;
  function from_timestamp(p_value in timestamp_tz_unconstrained) return clob;
  function from_timestamp(p_value in timestamp_ltz_unconstrained) return clob;
  function from_timestamp(p_value in varchar2) return clob;
  function from_timestamp(p_value in clob) return clob;

  function to_timestamp_tz(p_rep in clob) return timestamp_tz_unconstrained ;
  function to_timestamp_tz(p_rep in varchar2) return timestamp_tz_unconstrained ;
  function from_timestamp_tz(p_value in date ) return clob;
  function from_timestamp_tz(p_value in timestamp_unconstrained ) return clob;
  function from_timestamp_tz(p_value in timestamp_tz_unconstrained ) return clob;
  function from_timestamp_tz(p_value in timestamp_ltz_unconstrained ) return clob;
  function from_timestamp_tz(p_value in date, timezone_template in timestamp_tz_unconstrained) return clob;
  function from_timestamp_tz(p_value in date, timezone_template in timestamp_ltz_unconstrained) return clob;
  function from_timestamp_tz(p_value in timestamp_unconstrained, timezone_template in timestamp_tz_unconstrained) return clob;
  function from_timestamp_tz(p_value in timestamp_unconstrained, timezone_template in timestamp_ltz_unconstrained) return clob;
  function from_timestamp_tz(p_value in varchar2 ) return clob;
  function from_timestamp_tz(p_value in clob ) return clob;

  function to_timestamp_ltz(p_rep in clob) return timestamp_ltz_unconstrained ;
  function to_timestamp_ltz(p_rep in varchar2) return timestamp_ltz_unconstrained ;
  function from_timestamp_ltz(p_value in date ) return clob;
  function from_timestamp_ltz(p_value in timestamp_unconstrained ) return clob;
  function from_timestamp_ltz(p_value in timestamp_tz_unconstrained ) return clob;
  function from_timestamp_ltz(p_value in timestamp_ltz_unconstrained ) return clob;
  function from_timestamp_ltz(p_value in varchar2 ) return clob;
  function from_timestamp_ltz(p_value in clob ) return clob;
  
  function to_time_interval_dy_to_sec(p_rep in clob) return dsinterval_unconstrained;
  function to_time_interval_dy_to_sec(p_rep in varchar2) return dsinterval_unconstrained;
  function from_time_interval_dy_to_sec(p_value in dsinterval_unconstrained) return clob;
  function from_time_interval_dy_to_sec(p_value in varchar2) return clob;
  function from_time_interval_dy_to_sec(p_value in clob) return clob;
  
  function to_time_interval_yr_to_mo(p_rep in clob) return yminterval_unconstrained;
  function to_time_interval_yr_to_mo(p_rep in varchar2) return yminterval_unconstrained;
  function from_time_interval_yr_to_mo(p_value in yminterval_unconstrained) return clob;
  function from_time_interval_yr_to_mo(p_value in varchar2) return clob;
  function from_time_interval_yr_to_mo(p_value in clob) return clob;

  function to_xmltype(p_rep in clob) return xmltype;
  function to_xmltype(p_rep in varchar2) return xmltype;
  function from_xmltype(p_value in xmltype) return clob;
  function from_xmltype(p_value in varchar2) return clob;
  function from_xmltype(p_value in clob) return clob;

  function to_clob(p_rep in clob) return clob;
  function to_clob(p_rep in varchar2) return clob;
  function from_clob(p_value in clob) return clob;
  function from_clob(p_value in varchar2) return clob;

  function to_blob(p_rep in clob) return blob;
  function to_blob(p_rep in varchar2) return blob;
  function from_blob(p_value in blob) return clob;
  function from_blob(p_value in varchar2) return clob;
  function from_blob(p_value in clob) return clob;

  procedure convert(value in clob, result out boolean);
  procedure convert(value in varchar2, result out boolean);
  procedure convert(value in clob, result out date);
  procedure convert(value in varchar2, result out date);
  procedure convert(value in clob, result out timestamp_unconstrained);
  procedure convert(value in varchar2, result out timestamp_unconstrained);
  procedure convert(value in clob, result out timestamp_tz_unconstrained);
  procedure convert(value in varchar2, result out timestamp_tz_unconstrained);
  procedure convert(value in clob, result out timestamp_ltz_unconstrained);
  procedure convert(value in varchar2, result out timestamp_ltz_unconstrained);
  procedure convert(value in clob, result out dsinterval_unconstrained);
  procedure convert(value in varchar2, result out dsinterval_unconstrained);
  procedure convert(value in clob, result out yminterval_unconstrained);
  procedure convert(value in varchar2, result out yminterval_unconstrained);
  procedure convert(value in clob, result out xmltype);
  procedure convert(value in varchar2, result out xmltype);
  procedure convert(value in clob, result out clob);
  procedure convert(value in varchar2, result out clob);
  procedure convert(value in clob, result out blob);
  procedure convert(value in varchar2, result out blob);
  procedure convert(value in clob, result out number);
  procedure convert(value in varchar2, result out number);
  procedure convert(value in clob, result out varchar2);
  procedure convert(value in varchar2, result out varchar2);

  function datatype_as_sql_text(
    p_type in number,
    p_type_length in number := null,
    p_type_scale in number := null,
    p_type_precision in number := null
  ) return varchar2;

  function convert_from_as_sql_text(
    p_expression_text in varchar2,
    p_type in number,
    p_type_length in number := null,
    p_type_scale in number := null,
    p_type_precision in number := null,
    p_use_package in number := null
  ) return varchar2;

  function convert_to_as_sql_text(
    p_expression_text in varchar2,
    p_type in number,
    p_type_length in number := null,
    p_type_scale in number := null,
    p_type_precision in number := null,
    p_use_package in number := null
  ) return varchar2;

  function extract_location_UOID(p_id varchar2)
    return varchar2;
  
  function extract_location_name(p_id varchar2)
    return varchar2;
end wb_rt_conversions;
/

