create or replace view RAB_RT_REP_TYPES as
select distinct t.object_type_name as obj_type,
                upper(replace(replace(t.object_type_name,' ','_'),'/','_')) as symbol,
                decode(t.parent_object_type_id, null, 'true', 'false') as rep_fco,
                decode(upper(t.object_type_name), 'PROCESSFLOWPACKAGE', 'RTProcess',
                                                  'SCHEDULEDJOB', 'RTProcess',
                                                  'ABAPFILE', 'RTMap',
                                                  'CHANGEDATACAPTURE', 'RTMap',
                                                  'DATAAUDITOR', 'RTMap',
                                                  'PLSQLMAP', 'RTMap',
                                                  'SQLLOADERCONTROLFILE', 'RTMap',
                                                  'STREAMSCAPTURE', 'RTMap',
                                                  'ABAPFILE', 'RTMap',
                                                  'TRICKLEFEEDMAP', 'RTMap',
                                                  'DATABASELINK', 'RTDBLink',
                                                  upper(x.object_type_name), 'RTMap',
                                                                             'RTDataObject') as rep_type
from wb_rt_def_object_types t,
     (select distinct xt.object_type_name
        from wb_rt_def_object_types xt, wb_rt_audit_executions xe
       where xt.object_type_id = xe.execution_object_type_id) x
where x.object_type_name (+) = t.object_type_name
  and upper(t.object_type_name) != 'PROCESSFLOW'
  and upper(t.object_type_name) != 'TASKGROUP'
  and upper(t.object_type_name) != 'CMPKMTASKFLOW'
  and upper(t.object_type_name) != 'CMPMAPKM'
  and upper(t.object_type_name) != 'EXECUTE'
  and upper(t.object_type_name) != 'J2EEAPPLICATION'
  and upper(t.object_type_name) != 'JRTJOB'
  and upper(t.object_type_name) != 'JRTPHASE'
  and upper(t.object_type_name) != 'JRTSTEP'
  and upper(t.object_type_name) != 'JRTTASK'
union
select distinct p.operator_name as obj_type,
                upper(replace(replace(p.operator_name,' ','_'),'/','_')) as symbol,
                'false' as rep_fco,
                null as rep_type
from wb_rt_def_execution_operators p
where upper(p.operator_name) not in (select distinct upper(object_type_name) from wb_rt_def_object_types)
  and upper(p.operator_name) != 'PROCESSFLOW'
  and upper(p.operator_name) != 'TASKGROUP'
  and upper(p.operator_name) != 'CMPKMTASKFLOW'
  and upper(p.operator_name) != 'CMPMAPKM'
  and upper(p.operator_name) != 'EXECUTE'
  and upper(p.operator_name) != 'J2EEAPPLICATION'
  and upper(p.operator_name) != 'JRTJOB'
  and upper(p.operator_name) != 'JRTPHASE'
  and upper(p.operator_name) != 'JRTSTEP'
  and upper(p.operator_name) != 'JRTTASK'
union
select 'ProcessFlow' as obj_type, 'PROCESSFLOW' as symbol, 'true' as rep_fco, 'RTProcess' as rep_type
from dual
union
select 'TaskGroup' as obj_type, 'TASKGROUP' as symbol, 'false' as rep_fco, null as rep_type from dual
union
select 'CMPKMTaskFlow' as obj_type, 'KMTASKFLOW' as sumbol, 'true' as rep_fco, 'RTProcess' as rep_type from dual
union
select 'CMPMapKM' as obj_type, 'KMMAP' as sumbol, 'true' as rep_fco, 'RTMap' as rep_type from dual
union
select 'execute' as obj_type, 'KMPHASE' as sumbol, 'true' as rep_fco, 'RTProcess' as rep_type from dual
union
select 'J2EEApplication' as obj_type, 'J2EEAPPLICATION' as sumbol, 'true' as rep_fco, 'RTDataObject' as rep_type from dual
union
select 'JRTJob' as obj_type, 'JRTJOB' as sumbol, 'true' as rep_fco, 'RTProcess' as rep_type from dual
union
select 'JRTPhase' as obj_type, 'JRTPHASE' as sumbol, 'true' as rep_fco, 'RTProcess' as rep_type from dual
union
select 'JRTStep' as obj_type, 'JRTSTEP' as sumbol, 'true' as rep_fco, 'RTMap' as rep_type from dual
union
select 'JRTTask' as obj_type, 'JRTTASK' as sumbol, 'true' as rep_fco, 'RTProcess' as rep_type from dual
;

create or replace view RAB_RT_STORE_TYPES as
select distinct store_type_name as type,
                upper(replace(replace(store_type_name,' ','_'),'/','_')) as symbol
from wb_rt_def_store_types
;

create or replace view RAB_RT_STORE_PARAM_NAMES as
select distinct parameter_name as name,
                upper(replace(replace(parameter_name,' ','_'),'/','_')) as symbol
from wb_rt_def_store_type_params
;

create or replace view RAB_RT_FILE_TYPES as
select distinct file_type_name as type,
                upper(replace(replace(file_type_name,' ','_'),'/','_')) as symbol
from wb_rt_def_file_types
;

create or replace view RAB_RT_DEP_STATUS as
select        wb_rt_constants.DEPLOYMENT_STATUS_COMPLETE as status,
              wb_rt_constants.to_string(wb_rt_constants.DEPLOYMENT_STATUS_COMPLETE) as symbol,
              'false' as purge_disabled, null as style from dual
union select  wb_rt_constants.DEPLOYMENT_STATUS_INACTIVE as status,
              wb_rt_constants.to_string(wb_rt_constants.DEPLOYMENT_STATUS_INACTIVE) as symbol,
              'false' as purge_disabled, null as style from dual
union select  wb_rt_constants.DEPLOYMENT_STATUS_READY as status,
              wb_rt_constants.to_string(wb_rt_constants.DEPLOYMENT_STATUS_READY) as symbol,
              'true' as purge_disabled, 'OraDataText' as style from dual
;

create or replace view RAB_RT_SCR_RUN_STATUS as
select        wb_rt_constants.SCRIPT_RUN_STATUS_BUSY as status,
              wb_rt_constants.to_string(wb_rt_constants.SCRIPT_RUN_STATUS_BUSY) as symbol,
              'true' as purge_disabled, 'OraDataText' as style from dual
union select  wb_rt_constants.SCRIPT_RUN_STATUS_COMPLETE as status,
              wb_rt_constants.to_string(wb_rt_constants.SCRIPT_RUN_STATUS_COMPLETE) as symbol,
              'false' as purge_disabled, null as style from dual
union select  wb_rt_constants.SCRIPT_RUN_STATUS_FAILED as status,
              wb_rt_constants.to_string(wb_rt_constants.SCRIPT_RUN_STATUS_FAILED) as symbol,
              'false' as purge_disabled, 'OraErrorText' as style from dual
union select  wb_rt_constants.SCRIPT_RUN_STATUS_INACTIVE as status,
              wb_rt_constants.to_string(wb_rt_constants.SCRIPT_RUN_STATUS_INACTIVE) as symbol,
              'false' as purge_disabled, null as style from dual
union select  wb_rt_constants.SCRIPT_RUN_STATUS_UNCERTAIN as status,
              wb_rt_constants.to_string(wb_rt_constants.SCRIPT_RUN_STATUS_UNCERTAIN) as symbol,
              'false' as purge_disabled, 'OraErrorText' as style from dual
;

create or replace view RAB_RT_OBJ_STATUS as
select        wb_rt_constants.OBJECT_STATUS_VALID as status,
              wb_rt_constants.to_string(wb_rt_constants.OBJECT_STATUS_VALID) as symbol,
              null as style from dual
union select  wb_rt_constants.OBJECT_STATUS_INVALID as status,
              wb_rt_constants.to_string(wb_rt_constants.OBJECT_STATUS_INVALID) as symbol,
              'OraErrorText' as style from dual
union select  wb_rt_constants.OBJECT_STATUS_REMOVED as status,
              wb_rt_constants.to_string(wb_rt_constants.OBJECT_STATUS_REMOVED) as symbol,
              'OraDataText' as style from dual
union select  wb_rt_constants.OBJECT_STATUS_UNCERTAIN as status,
              wb_rt_constants.to_string(wb_rt_constants.OBJECT_STATUS_UNCERTAIN) as symbol,
              'OraErrorText' as style from dual
;

create or replace view RAB_RT_DEP_SEVERITY as
select        wb_rt_constants.SEVERITY_INFORMATIONAL as severity,
              wb_rt_constants.to_string(wb_rt_constants.SEVERITY_INFORMATIONAL) as symbol,
              'images/info.gif' as icon from dual
union select  wb_rt_constants.SEVERITY_WARNING as severity,
              wb_rt_constants.to_string(wb_rt_constants.SEVERITY_WARNING) as symbol,
              'images/warning.gif' as icon from dual
union select  wb_rt_constants.SEVERITY_ERROR as severity,
              wb_rt_constants.to_string(wb_rt_constants.SEVERITY_ERROR) as symbol,
              'images/error.gif' as icon from dual
union select  wb_rt_constants.SEVERITY_RECOVERY as severity,
              wb_rt_constants.to_string(wb_rt_constants.SEVERITY_RECOVERY) as symbol,
              'images/Failed.gif' as icon from dual
;

create or replace view RAB_RT_AUDIT_DEPLOYMENTS as
select
d.audit_deployment_id as audit_deployment_id,
d.deployment_name as audit_deployment_name,
d.number_of_units as number_of_units,
d.runtime_version as runtime_version,
d.client_version as client_version,
d.client_repository as client_repository,
d.client_repository_version as client_repository_version,
d.client_repository_user as client_repository_user,
d.generation_time as generation_time,
d.audit_status as audit_status,
wb_rt_constants.to_string(d.audit_status) as audit_status_symbol,
m.severity as severity,
wb_rt_constants.to_string(m.severity) as severity_symbol,
0 as elapse_time,
d.creation_date as deployment_date,
d.created_by as created_by,
d.last_update_date as updated_date,
d.last_updated_by as updated_by
from
wb_rt_audit_deployments d,
(select u.audit_deployment_id, max(severity) as severity
from wb_rt_audit_units u, wb_rt_audit_messages g
where u.audit_unit_id=g.audit_unit_id
group by u.audit_deployment_id) m
where
d.audit_deployment_id=m.audit_deployment_id(+)
with read only;

create or replace view RAB_RT_WH_LOCATIONS as
select
s.store_id as store_id,
s.store_uoid as store_uoid,
s.store_name as store_name,
st.store_type_name as store_type,
rt.symbol as store_type_symbol,
st.store_type_version as store_type_version,
s.is_deployment_target as is_deployment_target
from
wb_rt_stores s, wb_rt_def_store_types st,
rab_rt_store_types rt
where
st.store_type_id = s.store_type_id and
rt.type (+) = st.store_type_name
with read only;

create or replace view RAB_RT_AUDIT_UNITS as
select
u.audit_deployment_id as audit_deployment_id,
u.audit_unit_id as audit_unit_id,
u.unit_name as audit_unit_name,
u.unit_number as audit_unit_number,
u.number_of_objects as number_of_objects,
s.store_id as store_id,
u.deployment_adapter_id as deployment_adapter_id,
u.audit_status as audit_status,
wb_rt_constants.to_string(u.audit_status) as audit_status_symbol,
m.severity as severity,
wb_rt_constants.to_string(m.severity) as severity_symbol,
0 as elapse_time,
u.creation_date as deployment_date,
u.created_by as created_by,
u.last_update_date as updated_date,
u.last_updated_by as updated_by
from
wb_rt_audit_units u,
wb_rt_stores s,
(select audit_unit_id, max(severity) as severity
from wb_rt_audit_messages
group by audit_unit_id) m
where
u.store_uoid = s.store_uoid(+) and
u.audit_unit_id=m.audit_unit_id(+)
with read only;

create or replace view RAB_RT_AUDIT_OBJECTS as
select
u.audit_deployment_id as audit_deployment_id,
u.audit_unit_id as audit_unit_id,
u.store_uoid as store_uoid,
u.store_name as store_name,
o.tgt_store_uoid as tgt_store_uoid,
o.tgt_store_name as tgt_store_name,
o.audit_object_id as audit_object_id,
o.object_uoid as object_uoid,
ot.object_type_name as object_type,
rt.symbol as object_type_symbol,
o.object_name as object_name,
o.parent_audit_object_id as parent_audit_object_id,
o.object_version_tag as object_version_tag,
o.object_number as object_number,
o.number_of_objects as number_of_objects,
o.number_of_scripts as number_of_scripts,
u.audit_status as audit_status,
wb_rt_constants.to_string(u.audit_status) as audit_status_symbol,
o.final_object_status as final_object_status,
wb_rt_constants.to_string(o.final_object_status) as final_object_status_symbol,
m.severity as severity,
wb_rt_constants.to_string(m.severity) as severity_symbol,
0 as elapse_time,
o.creation_date as deployment_date,
o.created_by as created_by,
o.last_update_date as updated_date,
o.last_updated_by as updated_by
from
wb_rt_audit_objects o,
wb_rt_audit_units u,
wb_rt_def_object_types ot,
rab_rt_rep_types rt,
(select ao.audit_object_id as audit_object_id,
        max(m.severity) as severity
from
wb_rt_audit_objects ao,
wb_rt_audit_scripts s,
wb_rt_audit_script_runs r,
wb_rt_audit_messages m
where
r.audit_script_run_id=m.audit_script_run_id and
s.audit_script_id=r.audit_script_id and
ao.audit_object_id=s.audit_object_id
group by ao.audit_object_id) m
where
o.audit_unit_id = u.audit_unit_id and
o.object_type_id=ot.object_type_id and
rt.obj_type (+) = ot.object_type_name and
o.audit_object_id=m.audit_object_id(+)
with read only;

create or replace view RAB_RT_AUDIT_TASKS as
select
t.audit_task_id as audit_task_id,
u.audit_unit_id as audit_unit_id,
u.audit_deployment_id as audit_deployment_id,
s.store_id as store_id,
ts.store_id as tgt_store_id,
u.deployment_adapter_id as deployment_adapter_id,
t.audit_object_id as audit_object_id,
t.execution_store_uoid as execution_store_uoid,
t.execution_operator_id as execution_operator_id,
t.execution_object_uoid as exec_object_uoid,
xot.object_type_name as exec_object_type_name,
rt.symbol as exec_object_type_symbol,
t.execution_object_store_uoid as exec_object_store_uoid,
t.task_name,
t.creation_date as deployment_date,
t.created_by as created_by
from
wb_rt_audit_tasks t,
wb_rt_audit_objects o,  
wb_rt_audit_units u,
wb_rt_def_object_types xot,
rab_rt_rep_types rt,
wb_rt_stores s,
wb_rt_stores ts
where
t.audit_object_id = o.audit_object_id and
o.audit_unit_id = u.audit_unit_id and
xot.object_type_id = t.execution_object_type_id and
rt.obj_type (+) = xot.object_type_name and
u.store_uoid=s.store_uoid(+) and
o.tgt_store_uoid=ts.store_uoid(+)
with read only;


create or replace view RAB_RT_AUDIT_SCRIPTS as
select
u.audit_deployment_id as audit_deployment_id,
u.audit_unit_id as audit_unit_id,
s.audit_object_id as audit_object_id,
s.audit_script_id as audit_script_id,
s.action as script_action,
wb_rt_constants.to_string(s.action) as script_action_symbol,
s.script as script,
s.script_binary as script_binary,
wb_rt_constants.FORMAT_TYPE(s.mime_type, s.encoding_type) as format,
s.mime_type as mime_type,
s.encoding_type as encoding_type,
s.audit_status as audit_status,
wb_rt_constants.to_string(s.audit_status) as audit_status_symbol,
s.script_number as script_number,
m.severity as severity,
wb_rt_constants.to_string(m.severity) as severity_symbol,
s.generation_time as generation_time,
s.creation_date as deployment_date,
s.created_by as created_by,
s.last_update_date as updated_date,
s.last_updated_by as updated_by
from
wb_rt_audit_units u,
wb_rt_audit_scripts s,
wb_rt_audit_objects o,
(select r.audit_script_id, max(m.severity) as severity
from wb_rt_audit_script_runs r, wb_rt_audit_messages m
where r.audit_script_run_id=m.audit_script_run_id
group by audit_script_id) m
where
s.audit_object_id=o.audit_object_id and
o.audit_unit_id=u.audit_unit_id and
s.audit_script_id=m.audit_script_id(+)
with read only;

create or replace view RAB_RT_AUDIT_SCRIPT_RUNS
as
select
scr.audit_script_run_id as audit_script_run_id,
u.audit_deployment_id as audit_deployment_id,
u.audit_unit_id as audit_unit_id,
o.audit_object_id as audit_object_id,
sc.audit_script_id as audit_script_id,
s.store_id as store_id,
ts.store_id as tgt_store_id,
sc.action as script_action,
wb_rt_constants.to_string(sc.action) as script_action_symbol,
scr.operation as script_operation,
wb_rt_constants.to_string(scr.operation) as script_operation_symbol,
scr.audit_status as audit_status,
wb_rt_constants.to_string(scr.audit_status) as audit_status_symbol,
m.severity as severity,
wb_rt_constants.to_string(m.severity) as severity_symbol,
scr.elapse as elapse_time,
scr.external_audit_id as external_audit_id,
scr.creation_date as deployment_date,
scr.created_by as created_by,
scr.last_update_date as updated_date,
scr.last_updated_by as updated_by
from
wb_rt_audit_script_runs scr,
wb_rt_audit_scripts sc,
wb_rt_audit_objects o,
wb_rt_audit_units u,
wb_rt_stores s,
wb_rt_stores ts,
(select audit_script_run_id, max(severity) as severity
from wb_rt_audit_messages
group by audit_script_run_id) m
where
scr.audit_script_id = sc.audit_script_id and
sc.audit_object_id = o.audit_object_id (+) and
(o.audit_unit_id = u.audit_unit_id or sc.audit_unit_id = u.audit_unit_id) and
u.store_uoid=s.store_uoid(+) and
o.tgt_store_uoid=ts.store_uoid(+) and
scr.audit_script_run_id=m.audit_script_run_id(+)
with read only;

create or replace view RAB_RT_AUDIT_FCOS as
select
o.audit_object_id as audit_object_id,
o.object_uoid as object_uoid,
o.object_type as object_type,
o.object_type_symbol as object_type_symbol,
o.object_name as object_name,
o.deployment_date as deployment_date,
o.audit_status as audit_status,
o.audit_status_symbol as audit_status_symbol,
o.final_object_status as final_object_status,
o.final_object_status_symbol as final_object_status_symbol,
o.store_uoid as store_uoid,
o.store_name as store_name
from
RAB_RT_AUDIT_OBJECTS o
where
o.parent_audit_object_id is null
with read only;

create or replace view RAB_RT_AUDIT_SCOS as
select
o.audit_object_id as audit_object_id,
o.object_uoid as object_uoid,
o.object_type as object_type,
o.object_type_symbol as object_type_symbol,
o.object_name as object_name,
o.parent_audit_object_id as parent_audit_object_id,
o.deployment_date as deployment_date,
o.audit_status as audit_status,
o.audit_status_symbol as audit_status_symbol,
o.final_object_status as final_object_status,
o.final_object_status_symbol as final_object_status_symbol,
o.store_uoid as store_uoid,
o.store_name as store_name
from
RAB_RT_AUDIT_OBJECTS o
where
o.parent_audit_object_id is not null
with read only;

create or replace view RAB_RT_UNIT_MESSAGES as
select
u.audit_deployment_id as audit_deployment_id,
m.audit_unit_id as audit_unit_id,
m.audit_message_id as audit_message_id,
m.severity as severity,
wb_rt_constants.to_string(m.severity) as severity_symbol,
m.creation_date as created_on,
l.line_number as line_number,
l.plain_text as line_text
from
wb_rt_audit_messages m,
wb_rt_audit_message_lines l,
wb_rt_audit_units u
where
m.audit_message_id = l.audit_message_id and
m.audit_unit_id =u.audit_unit_id
with read only;

create or replace view RAB_RT_SCRIPT_RUN_MESSAGES as
select
s.audit_object_id as audit_object_id,
m.audit_script_run_id as audit_script_run_id,
m.audit_message_id as audit_message_id,
m.severity as severity,
wb_rt_constants.to_string(m.severity) as severity_symbol,
m.creation_date as created_on,
l.line_number as line_number,
l.plain_text as line_text
from
wb_rt_audit_messages m,
wb_rt_audit_message_lines l,
wb_rt_audit_script_runs sr,
wb_rt_audit_scripts s
where
m.audit_message_id = l.audit_message_id and
m.audit_script_run_id = sr.audit_script_run_id and
sr.audit_script_id = s.audit_script_id
with read only;

create or replace view RAB_RT_EXECUTION_MESSAGES as
select
m.audit_execution_id as audit_execution_id,
m.audit_message_id as audit_message_id,
m.severity as severity,
wb_rt_constants.to_string(m.severity) as severity_symbol,
m.creation_date as created_on,
l.line_number as line_number,
l.plain_text as line_text
from
wb_rt_audit_messages m,
wb_rt_audit_message_lines l,
wb_rt_audit_executions e
where
m.audit_message_id = l.audit_message_id and
m.audit_execution_id = e.audit_execution_id and
m.audit_message_id not in (select nvl(rtm_id,0) from wb_rt_errors)
with read only;

create or replace view RAB_RT_AUDIT_PROCESSES as
select
o.audit_object_id as audit_process_id,
o.object_uoid as process_uoid,
o.object_type as process_type,
o.object_type_symbol as process_type_symbol,
o.object_name as process_name,
o.deployment_date as deployment_date,
o.audit_status as audit_status,
o.audit_status_symbol as audit_status_symbol,
o.parent_audit_object_id as parent_audit_object_id,
o.store_uoid as store_uoid,
o.store_name as store_name
from RAB_RT_AUDIT_OBJECTS o, RAB_RT_REP_TYPES r
where upper(o.object_type) = upper(r.obj_type) AND r.rep_type = 'RTProcess'
with read only;

create or replace view RAB_RT_AUDIT_ACTIVITIES as
select
o.audit_object_id as audit_activity_id,
o.object_uoid as activity_uoid,
o.object_type as activity_type,
o.object_type_symbol as activity_type_symbol,
o.object_name as activity_name,
o.deployment_date as deployment_date,
o.audit_status as audit_status,
o.audit_status_symbol as audit_status_symbol,
o.store_uoid as store_uoid,
o.store_name as store_name
from
RAB_RT_AUDIT_OBJECTS o,
RAB_RT_REP_TYPES r
where
upper(o.object_type) = upper(r.obj_type) AND
r.rep_type = 'RTMap'
with read only;

create or replace view RAB_RT_AUDIT_DATA_OBJECTS as
select
o.audit_object_id as audit_data_object_id,
o.object_uoid as object_uoid,
o.object_type as object_type,
o.object_type_symbol as object_type_symbol,
o.object_name as object_name,
o.deployment_date as deployment_date,
o.audit_status as audit_status,
o.audit_status_symbol as audit_status_symbol,
o.store_uoid as store_uoid,
o.store_name as store_name
from
RAB_RT_AUDIT_FCOS o,
RAB_RT_REP_TYPES r
where
upper(o.object_type) = upper(r.obj_type) and
r.rep_type = 'RTDataObject'
with read only;

create or replace view RAB_RT_AUDIT_PROCESS_COMPS as
select
p.process_name as process_name,
p.process_uoid as process_uoid,
o.object_type as component_type,
o.object_type_symbol as component_type_symbol,
o.object_uoid as component_uoid,
o.object_name as component_name
from RAB_RT_AUDIT_PROCESSES p, 
RAB_RT_AUDIT_OBJECTS o
where
o.parent_audit_object_id=p.audit_process_id
with read only;

create or replace view RAB_RT_EXECUTION_FILES as
select
f.audit_execution_id as audit_execution_id,
f.audit_file_id as file_id,
f.file_text as file_clob,
f.file_binary as file_blob,
wb_rt_constants.FORMAT_TYPE(f.mime_type, f.encoding_type) as format,
f.mime_type as mime_type,
f.encoding_type as encoding_type,
ft.file_type_name as file_type,
rt.symbol as file_type_symbol,
f.creation_date as created_on
from
wb_rt_audit_files f,
wb_rt_def_file_types ft,
rab_rt_file_types rt
where
f.audit_execution_id is not null and
f.file_type_id = ft.file_type_id and
rt.type (+) = ft.file_type_name
with read only;

create or replace view RAB_RT_UNIT_FILES as
select
f.audit_unit_id as audit_unit_id,
f.audit_file_id as file_id,
f.file_text as file_clob,
f.file_binary as file_blob,
wb_rt_constants.FORMAT_TYPE(f.mime_type, f.encoding_type) as format,
f.mime_type as mime_type,
f.encoding_type as encoding_type,
ft.file_type_name as file_type,
rt.symbol as file_type_symbol,
f.creation_date as created_on
from
wb_rt_audit_files f,
wb_rt_def_file_types ft,
rab_rt_file_types rt
where
f.audit_unit_id is not null and
f.file_type_id = ft.file_type_id and
rt.type (+) = ft.file_type_name
with read only;

create or replace view RAB_RT_SCRIPT_RUN_FILES as
select
s.audit_object_id as audit_object_id,
f.audit_file_id as file_id,
f.file_text as file_clob,
f.file_binary as file_blob,
wb_rt_constants.FORMAT_TYPE(f.mime_type, f.encoding_type) as format,
f.mime_type as mime_type,
f.encoding_type as encoding_type,
ft.file_type_name as file_type,
rt.symbol as file_type_symbol,
f.creation_date as created_on
from
wb_rt_audit_files f,
wb_rt_audit_script_runs sr,
wb_rt_audit_scripts s,
wb_rt_def_file_types ft,
rab_rt_file_types rt
where
f.audit_script_run_id=sr.audit_script_run_id and
sr.audit_script_id = s.audit_script_id and
f.file_type_id = ft.file_type_id and
rt.type (+) = ft.file_type_name
with read only;

create or replace view RAB_RT_AUDIT_OBJECT_SCRIPTS as
select
o.audit_object_id as audit_object_id,
o.object_uoid as object_uoid,
s.audit_script_id as audit_script_id,
s.script as script,
s.script_binary as script_binary,
wb_rt_constants.FORMAT_TYPE(s.mime_type, s.encoding_type) as format,
s.mime_type as mime_type,
s.encoding_type as encoding_type
from
wb_rt_audit_scripts s,
wb_rt_audit_objects o
where
s.audit_object_id = o.audit_object_id
with read only;

create or replace view RAB_RT_TASK_PARAMETERS as
select
t.task_name as task_name,
t.task_id as task_id,
p.parameter_name as parameter_name,
p.parameter_type as parameter_type,
wb_rt_constants.to_string(p.parameter_type) as parameter_type_symbol,
p.parameter_mode as parameter_mode,
wb_rt_constants.to_string(p.parameter_mode) as parameter_mode_symbol,
p.parameter_scope as parameter_scope,
wb_rt_constants.to_string(p.parameter_scope) as parameter_scope_symbol,
d.bound_to_name as bound_to_name,
d.bound_to_kind as bound_to_kind,
wb_rt_constants.to_string(d.bound_to_kind) as bound_to_kind_symbol,
d.bound_to_scope as bound_to_scope,
wb_rt_constants.to_string(d.bound_to_scope) as bound_to_scope_symbol,
decode(p.is_required, 0, 'true', 'false') as ismandatory,
p.type_length as type_length,
p.type_scale as type_scale,
p.type_precision as type_precision,
d.value_kind as default_value_kind,
d.clob_value as default_clob_value,
d.value as default_value
from
wb_rt_tasks t,
wb_rt_task_custom_parameters p,
wb_rt_task_parameter_defaults d
where
t.task_id = p.task_id and
p.custom_parameter_id=d.custom_parameter_id(+)
with read only;

create or replace view RAB_RT_LOCATION_PARAMETERS as
select
s.store_type_name as store_type,
rt.symbol as store_type_symbol,
s.store_type_version as store_type_version,
p.parameter_name as parameter_name,
pn.symbol as parameter_name_symbol
from
wb_rt_def_store_types s,
wb_rt_def_store_type_params p,
rab_rt_store_types rt,
rab_rt_store_param_names pn
where
s.store_type_id = p.store_type_id and
rt.type (+) = s.store_type_name and
pn.name (+) = p.parameter_name
with read only;

create or replace view RAB_RT_AUDIT_LOCATION_PARAMS as
select
s.store_id as store_id,
s.store_uoid as store_uoid,
s.store_name as store_name,
st.store_type_name as store_type,
rt.symbol as store_type_symbol,
st.store_type_version as store_type_version,
p.parameter_name as parameter_name,
pn.symbol as parameter_name_symbol,
p.parameter_value as parameter_value,
p.access_restricted as access_restricted
from
wb_rt_stores s,
wb_rt_def_store_types st,
wb_rtv_store_parameters p,
rab_rt_store_types rt,
rab_rt_store_param_names pn
where
s.store_id = p.store_id and
st.store_type_id=s.store_type_id and
rt.type (+) = st.store_type_name and
pn.name (+) = p.parameter_name
with read only;

create or replace view RAB_RT_STORE_PARAMS as
select s.store_id as store_id,
       s.store_uoid as store_uoid,
       p.parameter_name as param_name,
       d.display_name as param_display_name,
       p.parameter_value as param_value,
       p.access_restricted as access_restricted,
       p.store_parameter_id as store_param_id
from wb_rt_stores s, wb_rtv_store_parameters p, wb_rt_def_store_type_params d
where s.store_uoid != '{0}'
  and p.store_id = s.store_id
  and d.store_type_id = s.store_type_id
  and d.parameter_name = p.parameter_name
union
select s.store_id as store_id,
       s.store_uoid as store_uoid,
       n.p_name as param_name,
       n.p_display as param_display_name,
       n.p_value as param_value,
       0 as access_restricted,
       0 as store_param_id
from wb_rt_stores s,
     (select 'Host' p_name, 'Host' p_display, host p_value from wb_rtv_service_nodes
      where node_id in (select min(node_id) from wb_rtv_service_nodes)
      union
      select 'Port' p_name, 'Port' p_display, to_char(port) p_value from wb_rtv_service_nodes
      where node_id in (select min(node_id) from wb_rtv_service_nodes)
      union
      select 'Service' p_name, 'Service' p_display, service_name p_value from wb_rtv_service_nodes
      where node_id in (select min(node_id) from wb_rtv_service_nodes)) n
where s.store_uoid = '{0}'
with read only;

create or replace view RAB_RT_STORE_DETAILS as
select s.store_id as store_id,
       s.store_uoid as store_uoid,
       s.store_name as store_name,
       t.store_type_name as store_type_name,
       t.display_name as store_type_display_name,
       t.store_type_version as store_type_version,
       d.creation_date as last_dep_date,
       ph.param_value as par_host,
       pp.param_value as par_port,
       ps.param_value as par_service,
       pn.param_value as par_netservicename,
       pr.param_value as par_rootpath,
       pu.param_value as par_user,
       pc.param_value as par_connectas,
       decode(pn.param_value, null,
              decode(ph.param_value, null,
                     decode(pr.param_value, null, null,
                            decode(sn.host, null, pr.param_value,
                                   '[' || sn.host || ']:' || pr.param_value)),
                     decode(pr.param_value, null,
                            ph.param_value || ':' || pp.param_value || ':' || ps.param_value,
                            ph.param_value || ':' || pr.param_value)),
              pn.param_value) as service_description,
       s.is_deployment_target as is_deployment_target
from wb_rt_stores s, wb_rt_def_store_types t, wb_rt_audit_deployments d,
     (select store_uoid, max(audit_deployment_id) max_dep_id
      from wb_rt_audit_units group by store_uoid) x,
     rab_rt_store_params ph, rab_rt_store_params pp, rab_rt_store_params ps,
     rab_rt_store_params pn, rab_rt_store_params pr, rab_rt_store_params pu,
     rab_rt_store_params pc, wb_rtv_service_nodes sn
where t.store_type_id = s.store_type_id
  and x.store_uoid (+) = s.store_uoid
  and d.audit_deployment_id (+) = x.max_dep_id
  and ph.store_id (+) = s.store_id and ph.param_name (+) = 'Host'
  and pp.store_id (+) = s.store_id and pp.param_name (+) = 'Port'
  and ps.store_id (+) = s.store_id and ps.param_name (+) = 'Service'
  and pn.store_id (+) = s.store_id and pn.param_name (+) = 'NetServiceName'
  and pr.store_id (+) = s.store_id and pr.param_name (+) = 'RootPath'
  and pu.store_id (+) = s.store_id and pu.param_name (+) = 'User'
  and pc.store_id (+) = s.store_id and pc.param_name (+) = 'ConnectAs'
  and sn.node_id in (select min(node_id) from wb_rtv_service_nodes)
with read only;

create or replace view RAB_RT_WH_OBJECTS as
select
w.warehouse_object_id as wh_object_id,
w.object_uoid as object_uoid,
w.object_name as object_name,
w.object_qname as object_qname,
ot.object_type_name as object_type,
rt.symbol as object_type_symbol,
w.object_status as object_status,
w.sub_objects_valid as sub_objects_valid,
w.related_objects_valid as related_objects_valid,
wb_rt_constants.to_string(w.object_status) as object_status_symbol,
w.version_tag as version_tag,
w.parent_object_id as parent_wh_object_id,
s.store_id as store_id,
s.store_uoid as store_uoid,
s.store_name as store_name,
ts.store_id as tgt_store_id,
ts.store_uoid as tgt_store_uoid,
ts.store_name as tgt_store_name,
decode(w.last_audit_object_id, null, null,
       object_deployment_status(w.last_audit_object_id)) as last_deployment_status,
decode(w.last_audit_object_id, null, null,
       decode(object_deployment_status(w.last_audit_object_id), 0, 'OK',
              wb_rt_constants.to_string(object_deployment_status(w.last_audit_object_id))))
                                                      as last_deployment_status_symbol,
m.severity as last_max_severity,
sv.symbol as last_max_severity_symbol,
a.creation_date as last_deployment_date
from
wb_rt_warehouse_objects w, wb_rt_stores s, wb_rt_stores ts, wb_rt_def_object_types ot,
wb_rt_audit_script_runs a, rab_rt_dep_severity sv, rab_rt_rep_types rt,
(select audit_script_run_id, max(severity) as severity
from wb_rt_audit_messages
group by audit_script_run_id) m
where
s.store_id = w.store_id and
ts.store_id (+) = w.tgt_store_id and
ot.object_type_id = w.object_type_id and
rt.obj_type (+) = ot.object_type_name and
a.audit_script_run_id (+) = w.last_audit_script_run_id and
m.audit_script_run_id (+) = a.audit_script_run_id and
sv.severity (+) = m.severity
with read only;
