Rem
Rem Copyright (c) 2000 by Oracle Corporation
Rem

create or replace package wb_rt_deployment is
  
  function define_deployment
  (
    p_deployment_name in varchar2,
    p_runtime_version in varchar2,
    p_client_version in varchar2,
    p_client_repository in varchar2,
    p_client_repository_version in varchar2,
    p_client_repository_user in varchar2,
    p_generation_time in date,
    p_description in clob := null
  ) return number;
      
  function define_unit
  (
    p_audit_deployment_id in number,
    p_unit_name varchar2,
    p_store_id in number,
    p_deployment_adapter_id in number
  ) 
  return number;
  
  function define_object
  (
    p_audit_unit_id in number,
    p_object_type_id in number,
    p_object_uoid in varchar2,
    p_object_name in varchar2,
    p_object_version_tag in varchar2,
    p_client_info in clob := null,
    p_metadata_info in clob := null,
    p_impl_type_id in number := null,
    p_tgt_store_id in number := null
  ) 
  return number;
  
  function define_sub_object
  (
    p_parent_audit_object_id in number,
    p_object_type_id in number,
    p_object_uoid in varchar2,
    p_object_name in varchar2,
    p_object_version_tag in varchar2,
    p_client_info in clob := null,
    p_metadata_info in clob := null,
    p_impl_type_id in number := null,
    p_tgt_store_id in number := null
  ) 
  return number;

  function define_task
  (
    p_audit_object_id in number,
    p_execution_store_uoid in varchar2,
    p_execution_operator_id in number,
    p_execution_object_uoid in varchar2,
    p_execution_object_type_id in number,
    p_execution_obj_store_uoid in varchar2,
    p_execution_obj_store_type_id in number,
    p_task_name in varchar2,
    p_task_input in clob,
    p_task_input_mime_type in varchar2 := null,
    p_task_input_encoding_type in varchar2 := null
  ) 
  return number;

  function define_task
  (
    p_audit_object_id in number,
    p_execution_store_uoid in varchar2,
    p_execution_operator_id in number,
    p_execution_object_uoid in varchar2,
    p_execution_object_type_id in number,
    p_execution_obj_store_uoid in varchar2,
    p_execution_obj_store_type_id in number,
    p_task_name in varchar2,
    p_task_input_binary in blob,
    p_task_input_mime_type in varchar2 := null,
    p_task_input_encoding_type in varchar2 := null
  ) 
  return number;

  procedure define_custom_parameter
  (
    p_audit_task_id in number,
    p_parameter_uoid in varchar2,
    p_parameter_name in varchar2,
    p_parameter_type in number,
    p_parameter_mode in number,
    p_parameter_scope in number := null,
    p_is_fixed in number := 0,
    p_is_required in number := 0,
    p_default_value in clob := null,
    p_value_kind in number := null,
    p_bound_to_name in varchar2 := null,
    p_bound_to_kind in number := null,
    p_bound_to_scope in number := null,
    p_length in number := null,
    p_scale in number := null,
    p_precision in number := null
  );

  procedure define_sys_parameter_override
  (
    p_audit_task_id in number,
    p_system_parameter_id in number,
    p_default_value in clob,
    p_value_kind in number := null,
    p_bound_to_name in varchar2 := null,
    p_bound_to_kind in number := null,
    p_bound_to_scope in number := null
  );

  function define_script
  (
    p_audit_object_id in number,
    p_action in number,
    p_generation_time in date,
    p_script in clob,
    p_mime_type in varchar2,
    p_encoding_type in varchar2 := null
  ) 
  return number;

  function define_script
  (
    p_audit_object_id in number,
    p_action in number,
    p_generation_time in date,
    p_script_binary in blob,
    p_mime_type in varchar2,
    p_encoding_type in varchar2 := null
  ) 
  return number;

  procedure activate_deployment
  (
    p_audit_deployment_id in number
  );

  procedure deactivate_deployment
  (
    p_audit_deployment_id in number,
    p_force in number := 0
  );

end wb_rt_deployment;
/

