Rem
Rem Copyright (c) 2000, 2005, Oracle. All rights reserved.  
Rem

create or replace package wb_rt_deployment_control is

  function reserve_deployment
  (
    p_audit_deployment_id in number
  ) 
  return number;
  
  procedure unreserve_deployment
  (
    p_audit_deployment_id in number
  );
  
  procedure refresh_catalog
  (
    p_audit_deployment_id in number
  ); 

  procedure prepare_unit
  (
    p_audit_unit_id in number,
    p_stream_id in number,
    p_ack_type in number
  );
    
  procedure unprepare_unit
  (
    p_audit_unit_id in number,
    p_stream_id in number,
    p_ack_type in number
  );
    
  procedure deploy_unit
  (
    p_audit_unit_id in number,
    p_stream_id in number,
    p_ack_type in number,
    p_job_mode in number := wb_rt_constants.JOB_MODE_NORMAL
  );
  
  procedure undo_unit
  (
    p_audit_unit_id in number,
    p_stream_id in number,
    p_ack_type in number,
    p_job_mode in number := wb_rt_constants.JOB_MODE_NORMAL
  );
  
  procedure finalize_unit
  (
    p_audit_unit_id in number,
    p_stream_id in number,
    p_ack_type in number,
    p_job_mode in number := wb_rt_constants.JOB_MODE_NORMAL
  );
  
  procedure acknowledge
  (
    p_audit_unit_id in number,
    p_stream_id in number,
    p_command in number
  );
    
  procedure abort
  (
    p_audit_unit_id in number
  );

end wb_rt_deployment_control;
/

