Rem
Rem Copyright (c) 2000 by Oracle Corporation
Rem

create or replace package wb_rt_deployment_feedback is

  function create_unit_upgrade_script
  (
    p_audit_unit_id in number,
    p_runnable in number,
    p_upgrade_script in clob,
    p_upgrade_report in clob,
    p_report_mime_type in varchar2,
    p_report_encoding_type in varchar2 := null,
    p_script_mime_type in varchar2 := null,
    p_script_encoding_type in varchar2 := null
  )
  return number;

  function create_unit_upgrade_script
  (
    p_audit_unit_id in number,
    p_runnable in number,
    p_upgrade_script_binary in blob,
    p_upgrade_report in clob,
    p_report_mime_type in varchar2,
    p_report_encoding_type in varchar2 := null,
    p_script_mime_type in varchar2 := null,
    p_script_encoding_type in varchar2 := null
  )
  return number;

  function script_run_begin
  (
    p_audit_script_id in number,
    p_operation in number,
    p_external_audit_id in varchar2 := null
  ) 
  return number;

  procedure set_external_audit_id
  (
    p_audit_script_run_id in number,
    p_external_audit_id in varchar2
  );

  procedure script_run_end
  (
    p_audit_script_run_id in number,
    p_script_run_status in number,
    p_external_audit_id in varchar2 := null
  );

  function object_status_exists
  (
    p_object_uoid in varchar2,
    p_object_type_name in varchar2,
    p_store_id in number,
    p_valid in number,
    p_parent_warehouse_object_id in number,
    p_audit_object_id in number
  )
  return number;

  procedure object_status_not_exists
  (
    p_object_uoid in varchar2,
    p_object_type_name in varchar2,
    p_store_id in number,
    p_parent_warehouse_object_id in number,
    p_audit_object_id in number
  );

  procedure object_status_uncertain
  (
    p_object_uoid in varchar2,
    p_object_type_name in varchar2,
    p_store_id in number,
    p_parent_warehouse_object_id in number,
    p_audit_object_id in number
  );

end wb_rt_deployment_feedback;
/

