Rem
Rem Copyright (c) 2000 by Oracle Corporation
Rem

create or replace package wb_rt_execution is

  function define_execution
  (
    p_task_id in number,
    p_execution_name in varchar2,
    p_description in clob := null
  ) 
  return number;

  function define_execution
  (
    p_task_id in number,
    p_parent_audit_execution_id in number,
    p_execution_name in varchar2,
    p_description in clob := null
  ) 
  return number;

  function define_execution_group
  (
    p_execution_name in varchar2,
    p_description in clob := null,
    p_parent_audit_execution_id in number := null,
    p_object_type_id in number := null
  ) 
  return number;
  
  function define_execution_taskless_map
  (
    p_execution_name in varchar2,
    p_object_name in varchar2    
  ) 
  return number;  

  procedure override_input_parameter
  (
    p_audit_execution_id in number,
    p_parameter_name in varchar2,
    p_parameter_kind in number,
    p_value in clob,
    p_value_kind in number := null,
    p_parameter_scope in number := wb_rt_constants.PARAM_SCOPE_PARAM
  ); 
  
  procedure set_external_audit_id
  (
    p_audit_execution_id in number,
    p_external_audit_id in varchar2
  ); 
  
  procedure set_request_audit_id
  (
    p_audit_execution_id in number,
    p_request_audit_id in varchar2
  ); 
  
  procedure set_scope_audit_execution_id
  (
    p_audit_execution_id in number,
    p_scope_audit_execution_id in number
  ); 
  
  procedure activate_execution
  (
    p_audit_execution_id in number
  );

  procedure deactivate_execution
  (
    p_audit_execution_id in number,
    p_force in number := 0
  );

end wb_rt_execution;
/

