Rem
Rem Copyright (c) 2000, 2005, Oracle. All rights reserved.  
Rem

create or replace package wb_rt_execution_control is

  procedure execute
  (
    p_audit_execution_id in number,
    p_stream_id in number,
    p_ack_type in number,
    p_job_mode in number := wb_rt_constants.JOB_MODE_NORMAL
  );
  
  procedure execute_background
  (
    p_audit_execution_id in number
  );
  
  function execute_background_and_wait
  (
    p_audit_execution_id in number,
    p_wait_timeout in number := 0
  ) 
  return number;
  
  procedure execute_child
  (
    p_audit_execution_id in number,
    p_stream_id in number
  );
  
  procedure acknowledge
  (
    p_audit_execution_id in number,
    p_stream_id in number,
    p_command in number
  );
    
  procedure abort
  (
    p_audit_execution_id in number
  );

  procedure expedite
  (
    p_audit_execution_id in number
  );

end wb_rt_execution_control;
/

