Rem
Rem Copyright (c) 2008 by Oracle Corporation
Rem

create or replace package wb_rt_ie_blob as  TYPE blob_row is record (
         id number,
         table_tag varchar2(32),
         offset number,
         length number,
         blob_text varchar2(1024));
         
   TYPE bin_blob_row is record (
         id number,
         table_tag varchar2(32),
         offset number,
         length number,
         blob_bin raw(2000));

   TYPE blob_row_set is table of blob_row;  

   function export_audit_files(p_wkspace_id varchar2) return blob_row_set pipelined;
   function export_audit_executions(p_wkspace_id varchar2) return blob_row_set pipelined;
   function export_audit_scripts(p_wkspace_id varchar2) return blob_row_set pipelined;
   function export_audit_tasks(p_wkspace_id varchar2) return blob_row_set pipelined;
   function export_platform_files(p_wkspace_id varchar2) return blob_row_set pipelined;
   function export_tasks(p_wkspace_id varchar2) return blob_row_set pipelined;
   function export_warehouse_objects(p_wkspace_id varchar2) return blob_row_set pipelined;
      
   TYPE c_bin_blob_row IS REF CURSOR;
   
   procedure load_blob_column(p_table_tag varchar2,
                     p_tgt_table varchar2,
                     p_blob_col  varchar2,
                     p_id_col    varchar2,
                     p_seq_name  varchar2);
  
end wb_rt_ie_blob;
/
