Rem
Rem Copyright (c) 2000, 2005, Oracle. All rights reserved.  
Rem
Rem NAME
Rem   wb_rt_mapaudit.pls
Rem FUNCTION
Rem   Create auditing API package (WB_RT_MAPAUDIT)
Rem NOTES
Rem   - This file can be tested using SQL*Plus.
Rem   - OWB developers must make sure this file is also runnable
Rem     using Runtime assistant. 
Rem
Rem MODIFIED
Rem    prichens   04/25/05 - add file auditing. 
Rem  T.Rose           Nov 2003 - Add logical_error_count parameter to APIs
REM  G.Watters        03/20/2002 - Created from WBPRTI.SQL
Rem  Yu.Gong          12/06/2000 -  Created.
REM  S.Nanjundeswaran 12/12/2000 - Updated for new runtime for 3i
Rem

CREATE OR REPLACE PACKAGE WB_RT_MAPAUDIT IS

  STATUS_BEGIN                  CONSTANT NUMBER := 0;
  STATUS_COMPLETE               CONSTANT NUMBER := 1;
  STATUS_FAILED                 CONSTANT NUMBER := 2;
  
  -- Audit Level constants
  AUDIT_NONE                    CONSTANT BINARY_INTEGER := 0;
  AUDIT_STATISTICS              CONSTANT BINARY_INTEGER := 1;
  AUDIT_ERROR_DETAILS           CONSTANT BINARY_INTEGER := 2;
  AUDIT_COMPLETE                CONSTANT BINARY_INTEGER := 3;

  -- Operating mode constants
  MODE_SET                      CONSTANT BINARY_INTEGER := 0;
  MODE_ROW                      CONSTANT BINARY_INTEGER := 1;
  MODE_ROW_TARGET               CONSTANT BINARY_INTEGER := 2;
  MODE_SET_FAILOVER_ROW         CONSTANT BINARY_INTEGER := 3;
  MODE_SET_FAILOVER_ROW_TARGET  CONSTANT BINARY_INTEGER := 4;
  
  -- System parameter names
  MAX_NO_OF_ERRORS              CONSTANT VARCHAR2(30) := 'MAX_NO_OF_ERRORS';
  COMMIT_FREQUENCY              CONSTANT VARCHAR2(30) := 'COMMIT_FREQUENCY';
  OPERATING_MODE                CONSTANT VARCHAR2(30) := 'OPERATING_MODE';
  BULK_SIZE                     CONSTANT VARCHAR2(30) := 'BULK_SIZE';
  AUDIT_LEVEL                   CONSTANT VARCHAR2(30) := 'AUDIT_LEVEL';  
  AUDIT_ID                      CONSTANT VARCHAR2(30) := 'AUDIT_ID';    
  
  -- Autononous Transaction Support
  AUTO_TRANS_VERSION            CONSTANT SYS.PRODUCT_COMPONENT_VERSION.VERSION%TYPE := '9.2';
  AUTO_TRANS_CACHE              BOOLEAN := NULL;
  
  TYPE ROWIDLIST IS TABLE OF VARCHAR2(40) INDEX BY BINARY_INTEGER;
  empty_rowidlist ROWIDLIST;

  TYPE KEYLIST IS TABLE OF VARCHAR2(2000) INDEX BY BINARY_INTEGER;
  empty_keylist KEYLIST;

  TYPE NUMBERLIST IS TABLE OF NUMBER INDEX BY BINARY_INTEGER;
  empty_numberlist NUMBERLIST;

  TYPE STRINGLIST IS TABLE OF VARCHAR2(2000) INDEX BY BINARY_INTEGER;
  empty_stringlist STRINGLIST;

  TYPE MULTAUDITYPE IS RECORD
  (
  tname VARCHAR2(80),
  cname VARCHAR2(80),
  spamount NUMBER(22,4),
  snamount NUMBER(22,4),
  fpamount NUMBER(22,4),
  fnamount NUMBER(22,4)
  );

  TYPE MULTAUDITArrayType IS TABLE OF
  MULTAUDITYPE
  INDEX BY BINARY_INTEGER;
  
  TYPE WB_RT_NAME_VALUE IS RECORD
  (
  param_name varchar2(30),
  param_value varchar2(4000)
  );
  
  TYPE WB_RT_NAME_VALUES IS TABLE OF
    WB_RT_NAME_VALUE
    INDEX BY BINARY_INTEGER;

  PROCEDURE override_auto_trans(
  p_override BOOLEAN)
;

  FUNCTION is_auto_trans_allowed
    RETURN BOOLEAN
;

  FUNCTION last_rta_id(
  p_lob_name IN VARCHAR2 )
RETURN NUMBER
;

  FUNCTION audit_begin(
  p_auditid IN NUMBER,
  p_lob_uoid IN VARCHAR2,
  p_lob_name IN VARCHAR2 DEFAULT NULL,
  p_purge_group IN VARCHAR2 DEFAULT NULL,
  p_parent IN NUMBER DEFAULT NULL,
  p_source IN VARCHAR2 DEFAULT NULL,
  p_source_uoid IN VARCHAR2 DEFAULT NULL,  
  p_target IN VARCHAR2 DEFAULT NULL,
  p_target_uoid IN VARCHAR2 DEFAULT NULL,  
  p_info IN VARCHAR2 DEFAULT NULL,
  p_date IN DATE DEFAULT SYSDATE)
  RETURN NUMBER
;  
 
 FUNCTION audit_begin(
  p_auditid IN NUMBER,
  p_lob_uoid IN VARCHAR2,
  p_type IN VARCHAR2,
  p_lob_name IN VARCHAR2 DEFAULT NULL,
  p_purge_group IN VARCHAR2 DEFAULT NULL,
  p_parent IN NUMBER DEFAULT NULL,
  p_source IN VARCHAR2 DEFAULT NULL,
  p_source_uoid IN VARCHAR2 DEFAULT NULL,  
  p_target IN VARCHAR2 DEFAULT NULL,
  p_target_uoid IN VARCHAR2 DEFAULT NULL,
  p_info IN VARCHAR2 DEFAULT NULL,
  p_date IN DATE DEFAULT SYSDATE) 
  RETURN NUMBER
;
  PROCEDURE audit_end(
  p_rta IN NUMBER ,
  p_sel IN NUMBER DEFAULT NULL,
  p_ins IN NUMBER DEFAULT NULL,
  p_upd IN NUMBER DEFAULT NULL,
  p_del IN NUMBER DEFAULT NULL,
  p_err IN NUMBER DEFAULT NULL,
  p_dis IN NUMBER DEFAULT NULL,
  p_mer IN NUMBER DEFAULT NULL,
  p_logical_err IN NUMBER DEFAULT NULL)
;
  PROCEDURE audit_fail(
  p_rta IN NUMBER,
  p_status IN NUMBER DEFAULT NULL,
  p_sel IN NUMBER DEFAULT NULL,
  p_ins IN NUMBER DEFAULT NULL,
  p_upd IN NUMBER DEFAULT NULL,
  p_del IN NUMBER DEFAULT NULL,
  p_err IN NUMBER DEFAULT NULL,
  p_dis IN NUMBER DEFAULT NULL,
  p_mer IN NUMBER DEFAULT NULL,
  p_logical_err IN NUMBER DEFAULT NULL
  )
;
  FUNCTION auditd_begin(
  p_rta IN NUMBER ,
  p_step IN NUMBER ,
  p_name IN VARCHAR2 DEFAULT NULL,
  p_source IN VARCHAR2 DEFAULT NULL,
  p_source_uoid IN VARCHAR2 DEFAULT NULL,  
  p_target IN VARCHAR2 DEFAULT NULL,
  p_target_uoid IN VARCHAR2 DEFAULT NULL,    
  p_stm IN VARCHAR2 DEFAULT NULL,
  p_info IN VARCHAR2 DEFAULT NULL,
  p_exec_mode IN NUMBER DEFAULT NULL)
  RETURN NUMBER
;
  FUNCTION auditd_begin(
  p_rta IN NUMBER ,
  p_rto IN NUMBER ,
  p_step IN NUMBER ,
  p_name IN VARCHAR2 DEFAULT NULL,
  p_source IN VARCHAR2 DEFAULT NULL,
  p_source_uoid IN VARCHAR2 DEFAULT NULL,  
  p_target IN VARCHAR2 DEFAULT NULL,
  p_target_uoid IN VARCHAR2 DEFAULT NULL, 
  p_stm IN VARCHAR2 DEFAULT NULL,
  p_info IN VARCHAR2 DEFAULT NULL,
  p_exec_mode IN NUMBER DEFAULT NULL)
  RETURN NUMBER
;
  PROCEDURE auditd_end(
  p_rtd IN NUMBER ,
  p_sel IN NUMBER DEFAULT NULL,
  p_ins IN NUMBER DEFAULT NULL,
  p_upd IN NUMBER DEFAULT NULL,
  p_del IN NUMBER DEFAULT NULL,
  p_err IN NUMBER DEFAULT NULL,
  p_dis IN NUMBER DEFAULT NULL,
  p_mer IN NUMBER DEFAULT NULL,
  p_logical_err IN NUMBER DEFAULT NULL,
  p_autotrans IN BOOLEAN DEFAULT TRUE)
;
  PROCEDURE auditd_end(
  p_rta IN NUMBER ,
  p_step IN NUMBER,
  p_sel IN NUMBER DEFAULT NULL,
  p_ins IN NUMBER DEFAULT NULL,
  p_upd IN NUMBER DEFAULT NULL,
  p_del IN NUMBER DEFAULT NULL,
  p_err IN NUMBER DEFAULT NULL,
  p_dis IN NUMBER DEFAULT NULL,
  p_mer IN NUMBER DEFAULT NULL,
  p_logical_err IN NUMBER DEFAULT NULL)
;
  PROCEDURE auditd_progress(
  p_rtd IN NUMBER ,
  p_sel IN NUMBER DEFAULT NULL,
  p_ins IN NUMBER DEFAULT NULL,
  p_upd IN NUMBER DEFAULT NULL,
  p_del IN NUMBER DEFAULT NULL,
  p_err IN NUMBER DEFAULT NULL,
  p_dis IN NUMBER DEFAULT NULL,
  p_mer IN NUMBER DEFAULT NULL,
  p_logical_err IN NUMBER DEFAULT NULL)
;
  PROCEDURE auditd_progress(
  p_rta IN NUMBER ,
  p_step IN NUMBER ,
  p_sel IN NUMBER DEFAULT NULL,
  p_ins IN NUMBER DEFAULT NULL,
  p_upd IN NUMBER DEFAULT NULL,
  p_del IN NUMBER DEFAULT NULL,
  p_err IN NUMBER DEFAULT NULL,
  p_dis IN NUMBER DEFAULT NULL,
  p_mer IN NUMBER DEFAULT NULL,
  p_logical_err IN NUMBER DEFAULT NULL)
;
  FUNCTION register_audit_detail_type(
  p_rtd IN NUMBER,
  p_parent_operator_uoid IN VARCHAR2,
  p_parent_object_name IN VARCHAR2,
  p_parent_object_uoid IN VARCHAR2,
  p_parent_object_type IN VARCHAR2,
  p_object_name IN VARCHAR2,
  p_object_uoid IN VARCHAR2,
  p_object_type IN VARCHAR2,
  p_location_uoid IN VARCHAR2)
  RETURN NUMBER
;

  FUNCTION audito_begin(
  p_rta IN NUMBER ,
  p_step IN NUMBER ,
  p_name IN VARCHAR2 DEFAULT NULL,
  p_exp IN VARCHAR2 DEFAULT NULL)
  RETURN NUMBER
;
  PROCEDURE audito_end(
  p_rto IN NUMBER ,
  p_input IN NUMBER DEFAULT NULL,
  p_output IN NUMBER DEFAULT NULL)
;
  PROCEDURE audito_progress(
  p_rto IN NUMBER ,
  p_input IN NUMBER DEFAULT NULL,
  p_output IN NUMBER DEFAULT NULL)
;
  PROCEDURE log_file(
  p_rta IN NUMBER,
  p_text IN CLOB)
;

  FUNCTION error(
  p_rta IN NUMBER ,
  p_step IN NUMBER ,
  p_rtd IN NUMBER ,
  p_rowkey IN NUMBER ,
  p_table IN VARCHAR2 DEFAULT NULL,
  p_column IN VARCHAR2 DEFAULT NULL,
  p_dstval IN VARCHAR2 DEFAULT NULL,
  p_stm IN VARCHAR2 DEFAULT NULL ,
  p_sqlerr IN NUMBER DEFAULT NULL ,
  p_sqlerrm IN VARCHAR2 DEFAULT NULL ,
  p_rowid IN ROWID DEFAULT NULL)
RETURN NUMBER
;

  FUNCTION error(
  p_rta IN NUMBER ,
  p_rto IN NUMBER ,
  p_step IN NUMBER ,
  p_rtd IN NUMBER DEFAULT NULL,
  p_rowkey IN NUMBER ,
  p_table IN VARCHAR2 DEFAULT NULL,
  p_column IN VARCHAR2 DEFAULT NULL,
  p_dstval IN VARCHAR2 DEFAULT NULL,
  p_stm IN VARCHAR2 DEFAULT NULL ,
  p_sqlerr IN NUMBER DEFAULT NULL ,
  p_sqlerrm IN VARCHAR2 DEFAULT NULL ,
  p_rowid IN ROWID DEFAULT NULL)
RETURN NUMBER
;
  PROCEDURE error(
  p_rta IN NUMBER ,
  p_step IN NUMBER ,
  p_rtd IN NUMBER ,
  p_rowkey IN NUMBER ,
  p_table IN VARCHAR2 DEFAULT NULL,
  p_column IN VARCHAR2 DEFAULT NULL,
  p_dstval IN VARCHAR2 DEFAULT NULL,
  p_stm IN VARCHAR2 DEFAULT NULL ,
  p_sqlerr IN NUMBER DEFAULT NULL ,
  p_sqlerrm IN VARCHAR2 DEFAULT NULL ,
  p_rowid IN ROWID DEFAULT NULL)
;
  PROCEDURE error_source(
  p_rta IN NUMBER ,
  p_rowkey IN NUMBER ,
  p_seq IN NUMBER,
  p_instance IN NUMBER,
  p_table IN VARCHAR2,
  p_column IN VARCHAR2 DEFAULT NULL,
  p_value IN VARCHAR2 DEFAULT NULL,
  p_step IN NUMBER DEFAULT NULL,
  p_role IN VARCHAR2 DEFAULT NULL)
;
  PROCEDURE error_reg(
  p_rte IN NUMBER ,
  p_rowkey IN NUMBER ,
  p_seq IN NUMBER )
;
  FUNCTION get_rowkey(
  p_bulk_size IN NUMBER DEFAULT 1)
RETURN NUMBER
;
  PROCEDURE register_feedback(
  p_rta IN NUMBER ,
  p_step IN NUMBER ,
  p_rowkey IN NUMBER ,
  p_status IN VARCHAR2 ,
  p_table IN VARCHAR2 ,
  p_role IN VARCHAR2 ,
  p_action IN VARCHAR2 ,
  p_rowid IN ROWID  DEFAULT NULL ,
  p_key01 IN VARCHAR2  DEFAULT NULL,
  p_key02 IN VARCHAR2  DEFAULT NULL,
  p_key03 IN VARCHAR2  DEFAULT NULL,
  p_key04 IN VARCHAR2  DEFAULT NULL,
  p_key05 IN VARCHAR2  DEFAULT NULL,
  p_key06 IN VARCHAR2  DEFAULT NULL,
  p_key07 IN VARCHAR2  DEFAULT NULL,
  p_key08 IN VARCHAR2  DEFAULT NULL,
  p_key09 IN VARCHAR2  DEFAULT NULL )
;
  PROCEDURE register_amounts(
  p_index IN NUMBER ,
  p_rta IN NUMBER ,
  p_step IN NUMBER ,
  p_type IN VARCHAR2 ,
  p_multaudit IN MULTAUDITArrayType )
;
  FUNCTION is_processed(
  p_rowid IN ROWID)
  RETURN BOOLEAN
;
  FUNCTION is_processed(
  p_key01 IN VARCHAR2,
  p_key02 IN VARCHAR2  DEFAULT NULL,
  p_key03 IN VARCHAR2  DEFAULT NULL,
  p_key04 IN VARCHAR2  DEFAULT NULL,
  p_key05 IN VARCHAR2  DEFAULT NULL,
  p_key06 IN VARCHAR2  DEFAULT NULL,
  p_key07 IN VARCHAR2  DEFAULT NULL,
  p_key08 IN VARCHAR2  DEFAULT NULL,
  p_key09 IN VARCHAR2  DEFAULT NULL )
  RETURN BOOLEAN
;
  FUNCTION get_feedback_id (
  bulk_size NUMBER)
  RETURN NUMBER
;
  PROCEDURE register_feedback_bulk(
  p_rta    IN NUMBER,
  p_step   IN NUMBER,
  p_rowkey IN NUMBER,
  p_status IN VARCHAR2,
  p_table  IN VARCHAR2,
  p_role   IN VARCHAR2,
  p_action IN VARCHAR2,
  p_rowid  IN ROWIDLIST DEFAULT empty_rowidlist,
  p_key01  IN KEYLIST   DEFAULT empty_keylist,
  p_key02  IN KEYLIST   DEFAULT empty_keylist,
  p_key03  IN KEYLIST   DEFAULT empty_keylist,
  p_key04  IN KEYLIST   DEFAULT empty_keylist,
  p_key05  IN KEYLIST   DEFAULT empty_keylist,
  p_key06  IN KEYLIST   DEFAULT empty_keylist,
  p_key07  IN KEYLIST   DEFAULT empty_keylist,
  p_key08  IN KEYLIST   DEFAULT empty_keylist,
  p_key09  IN KEYLIST   DEFAULT empty_keylist )
;
  PROCEDURE register_feedback_bulk(
  p_rta    IN NUMBER,
  p_step   IN NUMBER,
  p_rowkey IN NUMBERLIST,
  p_status IN VARCHAR2,
  p_table  IN VARCHAR2,
  p_role   IN VARCHAR2,
  p_action IN VARCHAR2,
  p_rowid  IN ROWIDLIST DEFAULT empty_rowidlist,
  p_key01  IN KEYLIST   DEFAULT empty_keylist,
  p_key02  IN KEYLIST   DEFAULT empty_keylist,
  p_key03  IN KEYLIST   DEFAULT empty_keylist,
  p_key04  IN KEYLIST   DEFAULT empty_keylist,
  p_key05  IN KEYLIST   DEFAULT empty_keylist,
  p_key06  IN KEYLIST   DEFAULT empty_keylist,
  p_key07  IN KEYLIST   DEFAULT empty_keylist,
  p_key08  IN KEYLIST   DEFAULT empty_keylist,
  p_key09  IN KEYLIST   DEFAULT empty_keylist )
;
  PROCEDURE register_feedback_bulk(
  p_rta    IN NUMBER,
  p_step   IN NUMBER,
  p_rowkey IN NUMBER,
  p_status IN VARCHAR2,
  p_table  IN VARCHAR2,
  p_role   IN VARCHAR2,
  p_action IN VARCHAR2,
  p_rowid  IN NUMBER,
  p_key01  IN KEYLIST   DEFAULT empty_keylist,
  p_key02  IN KEYLIST   DEFAULT empty_keylist,
  p_key03  IN KEYLIST   DEFAULT empty_keylist,
  p_key04  IN KEYLIST   DEFAULT empty_keylist,
  p_key05  IN KEYLIST   DEFAULT empty_keylist,
  p_key06  IN KEYLIST   DEFAULT empty_keylist,
  p_key07  IN KEYLIST   DEFAULT empty_keylist,
  p_key08  IN KEYLIST   DEFAULT empty_keylist,
  p_key09  IN KEYLIST   DEFAULT empty_keylist )
;

  FUNCTION getErrorRows(
     get_runtime_audit_id in NUMBER,
     get_model_name in VARCHAR2) 
  RETURN NUMBER ;
  
END WB_RT_MAPAUDIT;
/

