Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem NAME
Rem   WB_RT_MAPAUDIT_UTIL_INVOKER.PLS
Rem FUNCTION
Rem   Create runtime utility package (WB_RT_MAPAUDIT_UTIL_INVOKER)
Rem NOTES
Rem
Rem MODIFIED
Rem    jtho       09/12/05 - 
Rem    ygong      06/08/05 - 
Rem  Yu.Gong      04/09/05 -  Created.
Rem

CREATE OR REPLACE PACKAGE WB_RT_MAPAUDIT_UTIL_INVOKER AUTHID CURRENT_USER IS

  TYPE ChildTab IS TABLE OF ALL_CONSTRAINTS%ROWTYPE INDEX BY BINARY_INTEGER;
  ALLTab  ChildTab;
  Row_No  INTEGER;

  PROCEDURE GetObjDependency(p_table_name VARCHAR2,
                             p_status IN VARCHAR2 DEFAULT 'ENABLED');

  -- get next unused temporary table name in caller's schema
  FUNCTION get_unused_temptable_name RETURN VARCHAR2;

  -- get next unused temporary index name in caller's schema
  FUNCTION get_unused_tempindex_name RETURN VARCHAR2;

  -- get next unused temporary constraint name in caller's schema
  FUNCTION get_unused_tempcons_name RETURN VARCHAR2;

  -- create new table having same definition with the reference table
  PROCEDURE create_table_like(p_new_table  IN VARCHAR2,
                              p_ref_table  IN VARCHAR2,
                              p_tablespace IN VARCHAR2);

  -- create new temp table like ref table, return temp table name
  FUNCTION create_table_like(p_ref_table   IN VARCHAR2,
                             p_tablespace  IN VARCHAR2) RETURN VARCHAR2;

  -- index a table according to all local indexes in the ref table
  PROCEDURE lindex_table_like(p_new_table         IN VARCHAR2,
                              p_ref_table         IN VARCHAR2,
                              p_lindex_tablespace IN VARCHAR2);

  -- add one type of constraint to table according to cons in ref table
  PROCEDURE add_cons_like(p_new_table  IN VARCHAR2,
                          p_ref_table  IN VARCHAR2,
                          p_cons_type  IN VARCHAR2);

  -- add all constraints to a table according to cons in ref table
  PROCEDURE add_cons_like(p_new_table  IN VARCHAR2,
                          p_ref_table  IN VARCHAR2);

  -- disable all constraints of certain type:
  --   p_cons_type must take one of the values: P, U, R
  PROCEDURE disable_constraints(p_tablename IN VARCHAR2,
                                p_cons_type IN VARCHAR2);

  -- disable one constraint
  PROCEDURE disable_constraint(p_tablename IN VARCHAR2,
                               p_cons_name IN VARCHAR2);

  -- enable all constraints of certain type:
  --   p_exception_table can take one of the following possible values:
  --     1. NULL: No exception table is to be used.
  --     2. 'CREATE': Create an exception table, then fill p_exception_table 
  --        parameter (an IN OUT param) with the name of the freshly created 
  --        exception table.
  --     3. A table name: Use this table for the purpose of exception table.
  --   p_cons_type (if present) must take one of the values: P, U, R 
  PROCEDURE enable_constraints(p_tablename       IN VARCHAR2,
                               p_cons_type       IN VARCHAR2,
                               p_exception_table IN OUT VARCHAR2);

  -- enable one constraint:
  --   p_exception_table can take one of the following possible values:
  --     1. NULL: No exception table is to be used.
  --     2. 'CREATE': Create an exception table, then fill p_exception_table 
  --        parameter (an IN OUT param) with the name of the freshly 
  --        created exception table.
  --     3. A table name: Use this table for the purpose of exception table.
  PROCEDURE enable_constraint(p_tablename        IN VARCHAR2,
                              p_cons_name        IN VARCHAR2,
                              p_exception_table  IN OUT VARCHAR2);

  -- disable all referenced foreign keys for a certain table
  PROCEDURE disable_ref_fk(p_tablename IN VARCHAR2);

  -- enable all referenced foreign keys for a certain table
  --   p_exception_table can take one the following possible values:
  --     1. NULL: No exception table is to be used.
  --     2. 'CREATE': Create an exception table in p_owner's schema, then
  --                  fill p_exception_table parameter (an IN OUT param) with
  --                  the name of the freshly created exception table.
  --     3. A table name: Use this table for the purpose of exception table.
  --                      The table should be located in p_owner's schema.
  PROCEDURE enable_ref_fk(p_tablename        IN VARCHAR2,
                          p_exception_table  IN OUT VARCHAR2);

  -- this procedure just calls dbms_stats.gather_table_stats. but different
  -- from dbms_stats.gather_table_stats, this procedure does not commit
  -- the current session.
  PROCEDURE gather_table_stats(p_ownname          IN VARCHAR2,
                               p_tabname          IN VARCHAR2,
                               p_estimate_percent IN NUMBER,
                               p_granularity      IN VARCHAR2,
                               p_cascade          IN BOOLEAN,
                               p_degree           IN NUMBER);

END WB_RT_MAPAUDIT_UTIL_INVOKER;
/
