CREATE OR REPLACE TYPE
utl_name_addr_Component_obj AS OBJECT (
  id NUMBER,
  which_instance NUMBER,
  version NUMBER
);
/

CREATE OR REPLACE TYPE
utl_name_addr_InputRole_obj AS OBJECT (
  id NUMBER,
  val VARCHAR2(128)
);
/

CREATE OR REPLACE PACKAGE
utl_name_addr AS
  network_error EXCEPTION;
  network_error_errcode CONSTANT PLS_INTEGER:= -20100;
  PRAGMA EXCEPTION_INIT(network_error, -20100);

  bad_option EXCEPTION;
  bad_option_errcode CONSTANT PLS_INTEGER:= -20101;
  PRAGMA EXCEPTION_INIT(bad_option, -20101);

  bad_role_id EXCEPTION;
  bad_role_id_errcode CONSTANT PLS_INTEGER:= -20102;
  PRAGMA EXCEPTION_INIT(bad_role_id, -20102);

  bad_component_id EXCEPTION;
  bad_component_id_errcode CONSTANT PLS_INTEGER:= -20103;
  PRAGMA EXCEPTION_INIT(bad_component_id, -20103);

  bad_component_instance EXCEPTION;
  bad_component_instance_errcode CONSTANT PLS_INTEGER:= -20104;
  PRAGMA EXCEPTION_INIT(bad_component_instance, -20104);

  server_error EXCEPTION;
  server_error_errcode CONSTANT PLS_INTEGER:= -20105;
  PRAGMA EXCEPTION_INIT(server_error, -20105);

  internal_error EXCEPTION;
  internal_error_errcode CONSTANT PLS_INTEGER:= -20106;
  PRAGMA EXCEPTION_INIT(internal_error, -20106);

  invalid_connection_error EXCEPTION;
  invalid_connection_errcode CONSTANT PLS_INTEGER:= -20107;
  PRAGMA EXCEPTION_INIT(invalid_connection_error, -20107);

  parsing_error EXCEPTION;
  parsing_errcode CONSTANT PLS_INTEGER:= -20108;
  PRAGMA EXCEPTION_INIT(parsing_error, -20108);

  connect_info_error EXCEPTION;
  connect_info_errcode CONSTANT PLS_INTEGER:= -20109;
  PRAGMA EXCEPTION_INIT(connect_info_error, -20109);

  TYPE component IS RECORD (
    cobj utl_name_addr_Component_obj
  );

  TYPE Component_array IS TABLE OF utl_name_addr_Component_obj;

  TYPE connection IS RECORD (
    id NUMBER,
    group_name VARCHAR2(128),
    assign_dual_address NUMBER,
    data_type NUMBER,
    enable_postal_match NUMBER,
    primary_parse_country VARCHAR2(3),
    components Component_array
  );


  TYPE input_value IS RECORD (
    irobj utl_name_addr_InputRole_obj
  );

  TYPE input_values IS TABLE OF utl_name_addr_InputRole_obj;

  -- Input data type options
  OPTION_NAME CONSTANT PLS_INTEGER := 5;
  OPTION_ADDRESS CONSTANT PLS_INTEGER := 6;
  OPTION_NAME_AND_ADDRESS CONSTANT PLS_INTEGER := 7;
  OPTION_BOTH CONSTANT PLS_INTEGER := OPTION_NAME_AND_ADDRESS;

  -- Dual address assignment options
  OPTION_STREET CONSTANT PLS_INTEGER := 8;
  OPTION_BOX CONSTANT PLS_INTEGER := 9;
  OPTION_CLOSEST CONSTANT PLS_INTEGER := 10;

  -- Dual address output version options
  OPTION_NORMAL CONSTANT PLS_INTEGER := 11;
  OPTION_DUAL CONSTANT PLS_INTEGER := 12;
  
  OPTION_FALSE CONSTANT PLS_INTEGER := 0;
  OPTION_TRUE CONSTANT PLS_INTEGER := 1;

  -- Role ID Constants
  INPUT_PRE_NAME CONSTANT PLS_INTEGER          := 100;
  INPUT_FIRST_NAME CONSTANT PLS_INTEGER        := 101;
  INPUT_MIDDLE_NAME_1 CONSTANT PLS_INTEGER     := 102;
  INPUT_MIDDLE_NAME_2 CONSTANT PLS_INTEGER     := 103;
  INPUT_MIDDLE_NAME_3 CONSTANT PLS_INTEGER     := 104;
  INPUT_LAST_NAME CONSTANT PLS_INTEGER         := 105;
  INPUT_POST_NAME CONSTANT PLS_INTEGER         := 106;
  INPUT_NAME_FIRST_PART CONSTANT PLS_INTEGER   := 107;
  INPUT_NAME_LAST_PART CONSTANT PLS_INTEGER    := 108;
  INPUT_NAME_PERSON CONSTANT PLS_INTEGER       := 109;
  INPUT_NAME_FIRM CONSTANT PLS_INTEGER         := 110;
  INPUT_ADDRESS_LINE CONSTANT PLS_INTEGER      := 111;
  INPUT_PRIMARY_ADDRESS CONSTANT PLS_INTEGER   := 112;
  INPUT_SECONDARY_ADDRESS CONSTANT PLS_INTEGER := 113;
  INPUT_LASTLINE CONSTANT PLS_INTEGER          := 114;
  INPUT_CITY CONSTANT PLS_INTEGER              := 115;
  INPUT_STATE CONSTANT PLS_INTEGER             := 116;
  INPUT_POSTAL_CODE CONSTANT PLS_INTEGER       := 117;
  INPUT_COUNTRY_NAME CONSTANT PLS_INTEGER      := 118;
  INPUT_COUNTRY_CODE CONSTANT PLS_INTEGER      := 119;
  INPUT_LINE_1 CONSTANT PLS_INTEGER            := 120;
  INPUT_LINE_2 CONSTANT PLS_INTEGER            := 121;
  INPUT_LINE_3 CONSTANT PLS_INTEGER            := 122;
  INPUT_LINE_4 CONSTANT PLS_INTEGER            := 123;
  INPUT_LINE_5 CONSTANT PLS_INTEGER            := 124;
  INPUT_LINE_6 CONSTANT PLS_INTEGER            := 125;
  INPUT_LINE_7 CONSTANT PLS_INTEGER            := 126;
  INPUT_LINE_8 CONSTANT PLS_INTEGER            := 127;
  INPUT_LINE_9 CONSTANT PLS_INTEGER            := 128;
  INPUT_LINE_10 CONSTANT PLS_INTEGER           := 129;
  INPUT_NEIGHBORHOOD CONSTANT PLS_INTEGER      := 130;
  INPUT_ADDRESS_LINE_2 CONSTANT PLS_INTEGER    := 131;
  INPUT_NAME_PERSON_2 CONSTANT PLS_INTEGER     := 132;
  INPUT_NAME_PERSON_3 CONSTANT PLS_INTEGER     := 133;
    -- paris version roles
  INPUT_LASTLINE_2 CONSTANT PLS_INTEGER        := 134;
  INPUT_LOCALITY   CONSTANT PLS_INTEGER        := 135;
  INPUT_LOCALITY_2 CONSTANT PLS_INTEGER        := 136;
  INPUT_LOCALITY_3 CONSTANT PLS_INTEGER        := 137;
  INPUT_LOCALITY_4 CONSTANT PLS_INTEGER        := 138;

  -- Component ID Constants
  FIRST_OUTPUT_ID               CONSTANT PLS_INTEGER := 400;
  OUTPUT_PERSON                 CONSTANT PLS_INTEGER := 400;
  OUTPUT_NAME_DESIG             CONSTANT PLS_INTEGER := 401;
  OUTPUT_PRE_NAME               CONSTANT PLS_INTEGER := 402;
  OUTPUT_FIRST_NAME             CONSTANT PLS_INTEGER := 403;
  OUTPUT_FIRST_NAME_STD         CONSTANT PLS_INTEGER := 404;
  OUTPUT_MIDDLE_NAME            CONSTANT PLS_INTEGER := 405;
  OUTPUT_MIDDLE_NAME_STD        CONSTANT PLS_INTEGER := 406;
  OUTPUT_MIDDLE_NAME2           CONSTANT PLS_INTEGER := 407;
  OUTPUT_MIDDLE_NAME2_STD       CONSTANT PLS_INTEGER := 408;
  OUTPUT_MIDDLE_NAME3           CONSTANT PLS_INTEGER := 409;
  OUTPUT_MIDDLE_NAME3_STD       CONSTANT PLS_INTEGER := 410;
  OUTPUT_LAST_NAME              CONSTANT PLS_INTEGER := 411;
  OUTPUT_GENERATION             CONSTANT PLS_INTEGER := 412;
  OUTPUT_POST_NAME              CONSTANT PLS_INTEGER := 412;  --same as generation
  OUTPUT_OTHER_POST_NAME        CONSTANT PLS_INTEGER := 413;
  OUTPUT_RELATIONSHIP           CONSTANT PLS_INTEGER := 414;
  OUTPUT_FIRM_NAME              CONSTANT PLS_INTEGER := 415;
  OUTPUT_GENDER                 CONSTANT PLS_INTEGER := 416;
  OUTPUT_FIRM_COUNT             CONSTANT PLS_INTEGER := 417;
  OUTPUT_PERSON_COUNT           CONSTANT PLS_INTEGER := 418;
  OUTPUT_ADDRESS                CONSTANT PLS_INTEGER := 419;
  OUTPUT_PRIMARY_ADDR           CONSTANT PLS_INTEGER := 420;
  OUTPUT_SECONDARY_ADDR         CONSTANT PLS_INTEGER := 421;
  OUTPUT_PRIMARY_RANGE          CONSTANT PLS_INTEGER := 422;
  OUTPUT_PREDIRECTIONAL         CONSTANT PLS_INTEGER := 423;
  OUTPUT_STREET_NAME            CONSTANT PLS_INTEGER := 424;
  OUTPUT_POST_DIRECTIONAL       CONSTANT PLS_INTEGER := 425;
  OUTPUT_STREET_TYPE            CONSTANT PLS_INTEGER := 426;
  OUTPUT_UNIT_DESIGNATOR        CONSTANT PLS_INTEGER := 427;
  OUTPUT_UNIT_NUMBER            CONSTANT PLS_INTEGER := 428;
  OUTPUT_BUILDING_NAME          CONSTANT PLS_INTEGER := 429;
  OUTPUT_BOX_NAME               CONSTANT PLS_INTEGER := 430;
  OUTPUT_BOX_NUMBER             CONSTANT PLS_INTEGER := 431;
  OUTPUT_ROUTE_NAME             CONSTANT PLS_INTEGER := 432;
  OUTPUT_ROUTE_NUMBER           CONSTANT PLS_INTEGER := 433;
  OUTPUT_CITY                   CONSTANT PLS_INTEGER := 434;
  OUTPUT_NEIGHBORHOOD           CONSTANT PLS_INTEGER := 435;
  OUTPUT_STATE                  CONSTANT PLS_INTEGER := 436;
  OUTPUT_POSTAL_CODE            CONSTANT PLS_INTEGER := 437;
  OUTPUT_POSTAL_CODE_FMT        CONSTANT PLS_INTEGER := 438;
  OUTPUT_LAST_LINE              CONSTANT PLS_INTEGER := 439;
  OUTPUT_ISO_COUNTRY_2          CONSTANT PLS_INTEGER := 440;
  OUTPUT_ISO_COUNTRY_3          CONSTANT PLS_INTEGER := 441;
  OUTPUT_COUNTRY_NAME           CONSTANT PLS_INTEGER := 442;
  OUTPUT_MISC_ADDR              CONSTANT PLS_INTEGER := 443;
  OUTPUT_IS_PARSED              CONSTANT PLS_INTEGER := 444;
  OUTPUT_IS_FOUND               CONSTANT PLS_INTEGER := 445;
  OUTPUT_IS_GOOD_GROUP          CONSTANT PLS_INTEGER := 446;
  OUTPUT_IS_GOOD_ADDRESS        CONSTANT PLS_INTEGER := 447;
  OUTPUT_IS_GOOD_NAME           CONSTANT PLS_INTEGER := 448;
  OUTPUT_IS_ADDRESS_VERIFIABLE  CONSTANT PLS_INTEGER := 449;
  OUTPUT_NAME_WARNING           CONSTANT PLS_INTEGER := 450;
  OUTPUT_CITY_WARNING           CONSTANT PLS_INTEGER := 451;
  OUTPUT_STREET_WARNING         CONSTANT PLS_INTEGER := 452;
  OUTPUT_PARSE_STATUS           CONSTANT PLS_INTEGER := 453;
  OUTPUT_PARSE_STATUS_DESC      CONSTANT PLS_INTEGER := 454;
  OUTPUT_ADDRESS_TYPE           CONSTANT PLS_INTEGER := 455;
  OUTPUT_ADDRESS_CORRECTED      CONSTANT PLS_INTEGER := 456;
  OUTPUT_POSTAL_CODE_CORRECTED  CONSTANT PLS_INTEGER := 457;
  OUTPUT_CITY_CORRECTED         CONSTANT PLS_INTEGER := 458;
  OUTPUT_STREET_CORRECTED       CONSTANT PLS_INTEGER := 459;
  OUTPUT_STREET_COMP_CORRECTED  CONSTANT PLS_INTEGER := 460;
  OUTPUT_CITY_MATCH             CONSTANT PLS_INTEGER := 461;
  OUTPUT_STREET_NAME_MATCH      CONSTANT PLS_INTEGER := 462;
  OUTPUT_STREET_NUMBER_MATCH    CONSTANT PLS_INTEGER := 463;
  OUTPUT_STREET_COMP_MATCH      CONSTANT PLS_INTEGER := 464;
  OUTPUT_NON_AMBIGUOUS_MATCH    CONSTANT PLS_INTEGER := 465;
  OUTPUT_PARSING_COUNTRY        CONSTANT PLS_INTEGER := 466;
  OUTPUT_URBANIZATION_NAME      CONSTANT PLS_INTEGER := 467;
  OUTPUT_ZIP5                   CONSTANT PLS_INTEGER := 468;
  OUTPUT_ZIP4                   CONSTANT PLS_INTEGER := 469;
  OUTPUT_CART                   CONSTANT PLS_INTEGER := 470;
  OUTPUT_DPBC                   CONSTANT PLS_INTEGER := 471;
  OUTPUT_CHECK_DIGIT            CONSTANT PLS_INTEGER := 472;
  OUTPUT_LATITUDE               CONSTANT PLS_INTEGER := 473;
  OUTPUT_LONGITUDE              CONSTANT PLS_INTEGER := 474;
  OUTPUT_MSA                    CONSTANT PLS_INTEGER := 475;
  OUTPUT_MCD                    CONSTANT PLS_INTEGER := 476;
  OUTPUT_CENSUS_ID              CONSTANT PLS_INTEGER := 477;
  OUTPUT_FIPS                   CONSTANT PLS_INTEGER := 478;
  OUTPUT_FIPS_COUNTY            CONSTANT PLS_INTEGER := 479;
  OUTPUT_LACS                   CONSTANT PLS_INTEGER := 480;
  OUTPUT_LOCALITY_CODE          CONSTANT PLS_INTEGER := 481;
  OUTPUT_LOCALITY_NAME          CONSTANT PLS_INTEGER := 482;
  OUTPUT_INSTALLATION_NAME      CONSTANT PLS_INTEGER := 483;
  OUTPUT_INSTALLATION_TYPE      CONSTANT PLS_INTEGER := 484;
  OUTPUT_DELIVERY_OFFICE_CODE   CONSTANT PLS_INTEGER := 485;
  OUTPUT_DELIVERY_BEAT_CODE     CONSTANT PLS_INTEGER := 486;
  OUTPUT_LOT                    CONSTANT PLS_INTEGER := 487;
  OUTPUT_LOT_ORDER              CONSTANT PLS_INTEGER := 488;
  OUTPUT_COUNTY_NAME            CONSTANT PLS_INTEGER := 489;
  OUTPUT_ADDRESS2               CONSTANT PLS_INTEGER := 490;
  OUTPUT_COMPLEX                CONSTANT PLS_INTEGER := 491;
    -- paris version components
  OUTPUT_TITLE                  CONSTANT PLS_INTEGER := 492;
  OUTPUT_FIRM_LOC               CONSTANT PLS_INTEGER := 493;
  OUTPUT_NAME_FIRM_EXTRA        CONSTANT PLS_INTEGER := 494;
  OUTPUT_SSN                    CONSTANT PLS_INTEGER := 495;
  OUTPUT_EMAIL                  CONSTANT PLS_INTEGER := 496;
  OUTPUT_PHONE                  CONSTANT PLS_INTEGER := 497;
  OUTPUT_LAST_LINE_2            CONSTANT PLS_INTEGER := 498;
  OUTPUT_LOCALITY_2             CONSTANT PLS_INTEGER := 499;
  OUTPUT_LOCALITY_3             CONSTANT PLS_INTEGER := 500;
  OUTPUT_LOCALITY_4             CONSTANT PLS_INTEGER := 501;
  OUTPUT_CITY_ABBREV            CONSTANT PLS_INTEGER := 502;
  OUTPUT_CITY_ABBREV_2          CONSTANT PLS_INTEGER := 503;
  OUTPUT_CITY_ALTERNATE         CONSTANT PLS_INTEGER := 504;
  OUTPUT_PRIM_NAME_2            CONSTANT PLS_INTEGER := 505;
  OUTPUT_FIPS_PLACE_CODE        CONSTANT PLS_INTEGER := 506;
  OUTPUT_AUTO_ZONE_IND          CONSTANT PLS_INTEGER := 507;
  OUTPUT_URBAN_IND              CONSTANT PLS_INTEGER := 508;
  OUTPUT_CBSA_CODE              CONSTANT PLS_INTEGER := 509;
  OUTPUT_CBSA_DESC              CONSTANT PLS_INTEGER := 510;
  OUTPUT_NP_SEC_ADDR            CONSTANT PLS_INTEGER := 511;
  OUTPUT_NP_UNIT_DESIG          CONSTANT PLS_INTEGER := 512;
  OUTPUT_NP_UNIT_NBR            CONSTANT PLS_INTEGER := 513;
  OUTPUT_GEO_MATCH_PREC         CONSTANT PLS_INTEGER := 514;
  OUTPUT_EXTRA_1                CONSTANT PLS_INTEGER := 515;
  OUTPUT_EXTRA_2                CONSTANT PLS_INTEGER := 516;
  OUTPUT_EXTRA_3                CONSTANT PLS_INTEGER := 517;
  OUTPUT_EXTRA_4                CONSTANT PLS_INTEGER := 518;
  OUTPUT_EXTRA_5                CONSTANT PLS_INTEGER := 519;
  OUTPUT_EXTRA_6                CONSTANT PLS_INTEGER := 520;
  OUTPUT_EXTRA_7                CONSTANT PLS_INTEGER := 521;
  OUTPUT_EXTRA_8                CONSTANT PLS_INTEGER := 522;
  OUTPUT_EXTRA_9                CONSTANT PLS_INTEGER := 523;
  OUTPUT_EXTRA_10               CONSTANT PLS_INTEGER := 524;
  OUTPUT_EXTRA_11               CONSTANT PLS_INTEGER := 525;
  OUTPUT_EXTRA_12               CONSTANT PLS_INTEGER := 526;
  OUTPUT_EXTRA_13               CONSTANT PLS_INTEGER := 527;
  OUTPUT_EXTRA_14               CONSTANT PLS_INTEGER := 528;
  OUTPUT_EXTRA_15               CONSTANT PLS_INTEGER := 529;
  OUTPUT_EXTRA_16               CONSTANT PLS_INTEGER := 530;
  OUTPUT_EXTRA_17               CONSTANT PLS_INTEGER := 531;
  OUTPUT_EXTRA_18               CONSTANT PLS_INTEGER := 532;
  OUTPUT_EXTRA_19               CONSTANT PLS_INTEGER := 533;
  OUTPUT_EXTRA_20               CONSTANT PLS_INTEGER := 534;
  LAST_OUTPUT_ID                CONSTANT PLS_INTEGER := 534;
  OUTPUT_MAX_INSTANCE           CONSTANT PLS_INTEGER := 10;

  -- Default country code.
  USA CONSTANT VARCHAR2(3) := 'USA';

  FUNCTION create_group(groupName IN VARCHAR2,
                           primaryParseCountry IN VARCHAR2 DEFAULT USA,
                           inputType IN PLS_INTEGER DEFAULT OPTION_BOTH,
                           dualAddressAssignment IN PLS_INTEGER DEFAULT OPTION_STREET,
                           enablePostalMatch IN BOOLEAN DEFAULT TRUE)
    RETURN connection PARALLEL_ENABLE;
  -- PRAGMA RESTRICT_REFERENCES(, wnds, rnds, wnps, rnps); */
  -- Note that in the above RESTRICT_REFERENCES pragma, RNPS (Reads No Package
  -- State) could be specified if only non-package variables (i.e., constants)
  -- were used for default parameter values.
  PROCEDURE destroy_group(conn IN connection);

  PROCEDURE set_input_type(conn IN OUT NOCOPY connection,
                           opt IN PLS_INTEGER) PARALLEL_ENABLE DETERMINISTIC;

  PROCEDURE set_dual_address_assignment(conn IN OUT NOCOPY connection,
                           opt IN PLS_INTEGER) PARALLEL_ENABLE DETERMINISTIC;

  PROCEDURE enable_postal_matching(conn IN OUT NOCOPY connection,
                                   opt IN BOOLEAN) PARALLEL_ENABLE DETERMINISTIC;

  PROCEDURE set_primary_parser_country(conn IN OUT NOCOPY connection,
                                       ctry IN VARCHAR2) PARALLEL_ENABLE DETERMINISTIC;

  FUNCTION create_output_component(compID IN PLS_INTEGER,
                            comp_instance IN PLS_INTEGER DEFAULT 1,
                            version IN PLS_INTEGER DEFAULT OPTION_NORMAL)
    RETURN component PARALLEL_ENABLE;

  PROCEDURE add_output_component(conn IN OUT NOCOPY connection, comp IN component)
                        PARALLEL_ENABLE DETERMINISTIC;

  PROCEDURE clear_input(irarray IN OUT NOCOPY input_values) PARALLEL_ENABLE DETERMINISTIC;

  FUNCTION create_input_value(roleID IN PLS_INTEGER,
                       val IN VARCHAR2)
    RETURN input_value PARALLEL_ENABLE;
  PRAGMA RESTRICT_REFERENCES(create_input_value, WNDS, RNDS, WNPS);

  PROCEDURE add_input_value(irarray IN OUT NOCOPY input_values, role IN input_value)
                          PARALLEL_ENABLE DETERMINISTIC;

  PROCEDURE parse(conn IN connection, input IN input_values) PARALLEL_ENABLE;

  PROCEDURE start_cass(conn IN connection, processor_name IN VARCHAR2,
                       list_name IN VARCHAR2) PARALLEL_ENABLE;

  PROCEDURE print_cass(conn IN connection) PARALLEL_ENABLE;

  PROCEDURE start_postal_report(conn IN connection, ctry3 IN VARCHAR2, processor_name IN VARCHAR2,
                       list_name IN VARCHAR2, addr1 IN VARCHAR2, addr2 IN VARCHAR2,
                       addr3 IN VARCHAR2, addr4 IN VARCHAR2) PARALLEL_ENABLE;

  PROCEDURE end_postal_report(conn IN connection, ctry3 IN VARCHAR2) PARALLEL_ENABLE;

  FUNCTION get_component(conn IN connection, id IN PLS_INTEGER, instance IN PLS_INTEGER DEFAULT 1,
                         version IN PLS_INTEGER DEFAULT OPTION_NORMAL, maxLength IN PLS_INTEGER DEFAULT 130)
    RETURN VARCHAR2 PARALLEL_ENABLE;

END utl_name_addr;
/
