Rem
Rem Copyright (c) 2000 by Oracle Corporation
Rem

create or replace package wb_rt_notification is

  function create_stream
  (
    p_timeout in number := null
  ) 
  return number;
  
  procedure drop_stream
  (
    p_stream_id in number
  );
  
  procedure register_deployment_interest
  (
    p_stream_id in number,
    p_audit_deployment_id in number
  );
  
  procedure unregister_deployment_interest
  (
    p_stream_id in number,
    p_audit_deployment_id in number
  );
  
  procedure register_deployment_interest
  (
    p_stream_id in number,
    p_audit_deployment_id in number,
    p_event_type in number
  );
  
  procedure unregister_deployment_interest
  (
    p_stream_id in number,
    p_audit_deployment_id in number,
    p_event_type in number
  );
  
  procedure register_execution_interest
  (
    p_stream_id in number,
    p_audit_execution_id in number
  );
  
  procedure unregister_execution_interest
  (
    p_stream_id in number,
    p_audit_execution_id in number
  );

  procedure register_execution_interest
  (
    p_stream_id in number,
    p_audit_execution_id in number,
    p_event_type in number
  );
  
  procedure unregister_execution_interest
  (
    p_stream_id in number,
    p_audit_execution_id in number,
    p_event_type in number
  );
  
  procedure wait
  (
    p_stream_id in number,
    p_event_type out number,
    p_audit_id out number,
    p_focus_id out number,
    p_timeout in number := null
  );
  
  procedure wait
  (
    p_stream_id in number,
    p_event_type out number,
    p_audit_id out number,
    p_focus_id out number,
    p_end_of_chain out number,
    p_timeout in number
  );
  
end wb_rt_notification;
/

