Rem
Rem Copyright (c) 2000, 2008, Oracle and/or its affiliates.
Rem All rights reserved. 
Rem

----------------------------------------------------------------------------
-- SEQUENCES
----------------------------------------------------------------------------

create sequence wb_rt_audit_seq start with 1 increment by 1 order;

----------------------------------------------------------------------------
-- DEPLOYMENT AUDIT TABLES
----------------------------------------------------------------------------
CREATE TABLE OWB$WB_RT_AUDIT_CUSTOM_PARAMS
(
AUDIT_CUSTOM_PARAMETER_ID NUMBER(22) NOT NULL,
AUDIT_TASK_ID NUMBER(22) NOT NULL,
PARAMETER_UOID VARCHAR2(32) NOT NULL,
PARAMETER_NAME VARCHAR2(64) NOT NULL,
PARAMETER_TYPE NUMBER(8) NOT NULL,
PARAMETER_MODE NUMBER(8) NOT NULL,
PARAMETER_SCOPE NUMBER(8),
IS_FIXED NUMBER(1) NOT NULL,
IS_REQUIRED NUMBER(1) NOT NULL,
TYPE_LENGTH NUMBER(10),
TYPE_SCALE NUMBER(10),
TYPE_PRECISION NUMBER(10),
CREATION_DATE DATE DEFAULT sysdate NOT NULL,
CREATED_BY VARCHAR2(30) DEFAULT user NOT NULL,
WORKSPACE_ID NUMBER(22) DEFAULT sys_context('owb_workspace', 'workspaceId') NOT NULL
)
;

CREATE TABLE OWB$WB_RT_AUDIT_DEPLOYMENTS
(
AUDIT_DEPLOYMENT_ID NUMBER(22) NOT NULL,
DEPLOYMENT_NAME VARCHAR2(64),
DESCRIPTION CLOB,
NUMBER_OF_UNITS NUMBER(10) NOT NULL,
RUNTIME_VERSION VARCHAR2(64),
CLIENT_VERSION VARCHAR2(64),
CLIENT_REPOSITORY VARCHAR2(30),
CLIENT_REPOSITORY_VERSION VARCHAR2(64),
CLIENT_REPOSITORY_USER VARCHAR2(30),
RESERVED_TO_SESSION NUMBER(22),
GENERATION_TIME DATE,
AUDIT_STATUS NUMBER(8) NOT NULL,
NUMBER_OF_SCRIPT_ERRORS NUMBER(10) NOT NULL,
NUMBER_OF_SCRIPT_WARNINGS NUMBER(10) NOT NULL,
CREATION_DATE DATE DEFAULT sysdate NOT NULL,
CREATED_BY VARCHAR2(30) DEFAULT user NOT NULL,
LAST_UPDATE_DATE DATE DEFAULT sysdate,
LAST_UPDATED_BY VARCHAR2(30) DEFAULT user,
WORKSPACE_ID NUMBER(22) DEFAULT sys_context('owb_workspace', 'workspaceId') NOT NULL
)
;

CREATE TABLE OWB$WB_RT_AUDIT_EXECUTIONS
(
AUDIT_EXECUTION_ID NUMBER(22) NOT NULL,
TOP_LEVEL_AUDIT_EXECUTION_ID NUMBER(22) NOT NULL,
PARENT_AUDIT_EXECUTION_ID NUMBER(22),
SCOPE_AUDIT_EXECUTION_ID NUMBER(22),
TASK_OBJECT_UOID VARCHAR2(32),
TASK_OBJECT_NAME VARCHAR2(64),
TASK_OBJECT_TYPE_ID NUMBER(22),
TASK_OBJECT_STORE_UOID VARCHAR2(32),
TASK_OBJECT_STORE_NAME VARCHAR2(64),
TASK_OBJECT_STORE_TYPE_ID NUMBER(22),
TASK_NAME VARCHAR2(64),
TASK_INPUT CLOB,
TASK_INPUT_BINARY BLOB,
TASK_INPUT_MIME_TYPE VARCHAR2(64),
TASK_INPUT_ENCODING_TYPE VARCHAR2(64),
EXECUTION_STORE_UOID VARCHAR2(32),
EXECUTION_STORE_NAME VARCHAR2(64),
EXECUTION_OPERATOR_ID NUMBER(22),
EXECUTION_OBJECT_UOID VARCHAR2(32),
EXECUTION_OBJECT_NAME VARCHAR2(64),
EXECUTION_OBJECT_TYPE_ID NUMBER(22),
EXECUTION_OBJECT_STORE_UOID VARCHAR2(32),
EXECUTION_OBJECT_STORE_NAME VARCHAR2(64),
EXECUTION_OBJECT_STORE_TYPE_ID NUMBER(22),
EXECUTION_NAME VARCHAR2(64),
DESCRIPTION CLOB,
RETURN_RESULT VARCHAR2(64),
RETURN_RESULT_NUMBER NUMBER(10),
RETURN_CODE NUMBER(10),
AUDIT_STATUS NUMBER(8) NOT NULL,
ABORT_SENT NUMBER(1) DEFAULT (0) NOT NULL,
JOB_MODE NUMBER(8),
JOB_OWNER NUMBER(10),
CURRENT_OP_ABORTED NUMBER(1),
CLIENT_INFO CLOB,
METADATA_INFO CLOB,
ELAPSE NUMBER(10) NOT NULL,
NUMBER_OF_TASK_ERRORS NUMBER(10) NOT NULL,
NUMBER_OF_TASK_WARNINGS NUMBER(10) NOT NULL,
EXTERNAL_AUDIT_ID VARCHAR2(512),
REQUEST_AUDIT_ID VARCHAR2(512),
CREATED_BY VARCHAR2(30) DEFAULT user NOT NULL,
CREATION_DATE DATE DEFAULT sysdate NOT NULL,
LAST_UPDATE_DATE DATE DEFAULT sysdate,
LAST_UPDATED_BY VARCHAR2(30) DEFAULT user,
WORKSPACE_ID NUMBER(22) DEFAULT sys_context('owb_workspace', 'workspaceId') NOT NULL
)
;

CREATE TABLE OWB$WB_RT_AUDIT_FILES
(
AUDIT_FILE_ID NUMBER(22) NOT NULL,
AUDIT_UNIT_ID NUMBER(22),
AUDIT_SCRIPT_RUN_ID NUMBER(22),
AUDIT_EXECUTION_ID NUMBER(22),
FILE_TYPE_ID NUMBER(22) NOT NULL,
FILE_TEXT CLOB,
FILE_BINARY BLOB,
MIME_TYPE VARCHAR2(64) NOT NULL,
ENCODING_TYPE VARCHAR2(64) NOT NULL,
CREATED_BY VARCHAR2(30) DEFAULT user NOT NULL,
CREATION_DATE DATE DEFAULT sysdate NOT NULL,
WORKSPACE_ID NUMBER(22) DEFAULT sys_context('owb_workspace', 'workspaceId') NOT NULL
)
;

CREATE TABLE OWB$WB_RT_AUDIT_MESSAGES
(
AUDIT_MESSAGE_ID NUMBER(22) NOT NULL,
AUDIT_UNIT_ID NUMBER(22),
AUDIT_SCRIPT_RUN_ID NUMBER(22),
AUDIT_EXECUTION_ID NUMBER(22),
SEVERITY NUMBER(8) NOT NULL,
NUMBER_OF_LINES NUMBER(10) NOT NULL,
CREATED_BY VARCHAR2(30) DEFAULT user NOT NULL,
CREATION_DATE DATE DEFAULT sysdate NOT NULL,
WORKSPACE_ID NUMBER(22) DEFAULT sys_context('owb_workspace', 'workspaceId') NOT NULL
)
;

CREATE TABLE OWB$WB_RT_AUDIT_MESSAGE_LINES
(
AUDIT_MESSAGE_LINE_ID NUMBER(22) NOT NULL,
AUDIT_MESSAGE_ID NUMBER(22) NOT NULL,
LINE_NUMBER NUMBER(10) NOT NULL,
IS_NLS NUMBER(1) NOT NULL,
NLS_KEY VARCHAR2(256),
NUMBER_OF_PARAMETERS NUMBER(10),
PLAIN_TEXT VARCHAR2(4000),
WORKSPACE_ID NUMBER(22) DEFAULT sys_context('owb_workspace', 'workspaceId') NOT NULL
)
;

CREATE TABLE OWB$WB_RT_AUDIT_MESSAGE_PARAMS
(
AUDIT_MESSAGE_PARAMETER_ID NUMBER(22) NOT NULL,
AUDIT_MESSAGE_LINE_ID NUMBER(22) NOT NULL,
PARAMETER_NUMBER NUMBER(10) NOT NULL,
VALUE VARCHAR2(4000),
WORKSPACE_ID NUMBER(22) DEFAULT sys_context('owb_workspace', 'workspaceId') NOT NULL
)
;

CREATE TABLE OWB$WB_RT_AUDIT_OBJECTS
(
AUDIT_OBJECT_ID NUMBER(22) NOT NULL,
AUDIT_UNIT_ID NUMBER(22) NOT NULL,
PARENT_AUDIT_OBJECT_ID NUMBER(22),
TGT_STORE_UOID VARCHAR2(32),
TGT_STORE_NAME VARCHAR2(64),
OBJECT_NUMBER NUMBER(10) NOT NULL,
NUMBER_OF_OBJECTS NUMBER(10) NOT NULL,
NUMBER_OF_SCRIPTS NUMBER(10) NOT NULL,
OBJECT_UOID VARCHAR2(32) NOT NULL,
OBJECT_NAME VARCHAR2(64) NOT NULL,
OBJECT_TYPE_ID NUMBER(22) NOT NULL,
IMPL_TYPE_ID NUMBER(22),
OBJECT_VERSION_TAG VARCHAR2(80) NOT NULL,
CLIENT_INFO CLOB,
METADATA_INFO CLOB,
NUMBER_OF_SCRIPT_ERRORS NUMBER(10) NOT NULL,
NUMBER_OF_SCRIPT_WARNINGS NUMBER(10) NOT NULL,
FINAL_OBJECT_STATUS NUMBER(8),
CREATION_DATE DATE DEFAULT sysdate NOT NULL,
CREATED_BY VARCHAR2(30) DEFAULT user NOT NULL,
LAST_UPDATE_DATE DATE DEFAULT sysdate,
LAST_UPDATED_BY VARCHAR2(30) DEFAULT user,
WORKSPACE_ID NUMBER(22) DEFAULT sys_context('owb_workspace', 'workspaceId') NOT NULL
)
;

CREATE TABLE OWB$WB_RT_AUDIT_PARAMS
(
AUDIT_PARAMETER_ID NUMBER(22) NOT NULL,
AUDIT_EXECUTION_ID NUMBER(22) NOT NULL,
PARAMETER_NAME VARCHAR2(64) NOT NULL,
PARAMETER_TYPE NUMBER(8) NOT NULL,
PARAMETER_KIND NUMBER(8) NOT NULL,
PARAMETER_MODE NUMBER(8) NOT NULL,
PARAMETER_SCOPE NUMBER(8) NOT NULL,
VALUE_MODE NUMBER(8) NOT NULL,
BOUND_TO_ID NUMBER(22),
IS_REQUIRED NUMBER(1) NOT NULL,
IS_FIXED NUMBER(1) NOT NULL,
PARAMETER_UOID VARCHAR2(32),
VALUE_KIND NUMBER(8) NOT NULL,
CLOB_VALUE CLOB,
TYPE_LENGTH NUMBER(10),
TYPE_SCALE NUMBER(10),
TYPE_PRECISION NUMBER(10),
WORKSPACE_ID NUMBER(22) DEFAULT sys_context('owb_workspace', 'workspaceId') NOT NULL
)
;

CREATE TABLE OWB$WB_RT_AUDIT_PARAM_DEFAULTS
(
AUDIT_PARAMETER_DEFAULT_ID NUMBER(22) NOT NULL,
AUDIT_TASK_ID NUMBER(22) NOT NULL,
AUDIT_CUSTOM_PARAMETER_ID NUMBER(22),
SYSTEM_PARAMETER_ID NUMBER(22),
VALUE_KIND NUMBER(8) NOT NULL,
CLOB_VALUE CLOB,
BOUND_TO_NAME VARCHAR2(64),
BOUND_TO_KIND NUMBER(8),
BOUND_TO_SCOPE NUMBER(8),
CREATION_DATE DATE DEFAULT sysdate NOT NULL,
CREATED_BY VARCHAR2(30) DEFAULT user NOT NULL,
WORKSPACE_ID NUMBER(22) DEFAULT sys_context('owb_workspace', 'workspaceId') NOT NULL
)
;

CREATE TABLE OWB$WB_RT_AUDIT_SCRIPTS
(
AUDIT_SCRIPT_ID NUMBER(22) NOT NULL,
AUDIT_UNIT_ID NUMBER(22),
AUDIT_OBJECT_ID NUMBER(22),
SCRIPT_NUMBER NUMBER(10) NOT NULL,
ACTION NUMBER(8) NOT NULL,
IS_RUNNABLE NUMBER(1) NOT NULL,
SCRIPT CLOB,
SCRIPT_BINARY BLOB,
MIME_TYPE VARCHAR2(64) NOT NULL,
ENCODING_TYPE VARCHAR2(64) NOT NULL,
GENERATION_TIME DATE,
AUDIT_STATUS NUMBER(8) NOT NULL,
CURRENT_SCRIPT_RUN_ID NUMBER(22),
NUMBER_OF_SCRIPT_ERRORS NUMBER(10) NOT NULL,
NUMBER_OF_SCRIPT_WARNINGS NUMBER(10) NOT NULL,
CREATION_DATE DATE DEFAULT sysdate NOT NULL,
CREATED_BY VARCHAR2(30) DEFAULT user NOT NULL,
LAST_UPDATE_DATE DATE DEFAULT sysdate,
LAST_UPDATED_BY VARCHAR2(30) DEFAULT user,
WORKSPACE_ID NUMBER(22) DEFAULT sys_context('owb_workspace', 'workspaceId') NOT NULL
)
;

CREATE TABLE OWB$WB_RT_AUDIT_SCRIPT_RUNS
(
AUDIT_SCRIPT_RUN_ID NUMBER(22) NOT NULL,
AUDIT_SCRIPT_ID NUMBER(22) NOT NULL,
OPERATION NUMBER(8) NOT NULL,
AUDIT_STATUS NUMBER(8) NOT NULL,
ELAPSE NUMBER(10) NOT NULL,
EXTERNAL_AUDIT_ID VARCHAR2(4000),
CREATION_DATE DATE DEFAULT sysdate NOT NULL,
CREATED_BY VARCHAR2(30) DEFAULT user NOT NULL,
LAST_UPDATE_DATE DATE DEFAULT sysdate,
LAST_UPDATED_BY VARCHAR2(30) DEFAULT user,
WORKSPACE_ID NUMBER(22) DEFAULT sys_context('owb_workspace', 'workspaceId') NOT NULL
)
;

CREATE TABLE OWB$WB_RT_AUDIT_TASKS
(
AUDIT_TASK_ID NUMBER(22) NOT NULL,
AUDIT_OBJECT_ID NUMBER(22) NOT NULL,
EXECUTION_STORE_UOID VARCHAR2(32) NOT NULL,
EXECUTION_OPERATOR_ID NUMBER(22) NOT NULL,
EXECUTION_OBJECT_UOID VARCHAR2(32),
EXECUTION_OBJECT_TYPE_ID NUMBER(22),
EXECUTION_OBJECT_STORE_UOID VARCHAR2(32),
EXECUTION_OBJECT_STORE_TYPE_ID NUMBER(22),
TASK_NAME VARCHAR2(64),
TASK_INPUT CLOB,
TASK_INPUT_BINARY BLOB,
TASK_INPUT_MIME_TYPE VARCHAR2(64),
TASK_INPUT_ENCODING_TYPE VARCHAR2(64),
CREATION_DATE DATE DEFAULT sysdate NOT NULL,
CREATED_BY VARCHAR2(30) DEFAULT user NOT NULL,
WORKSPACE_ID NUMBER(22) DEFAULT sys_context('owb_workspace', 'workspaceId') NOT NULL
)
;

CREATE TABLE OWB$WB_RT_AUDIT_UNITS
(
AUDIT_UNIT_ID NUMBER(22) NOT NULL,
AUDIT_DEPLOYMENT_ID NUMBER(22) NOT NULL,
UNIT_NAME VARCHAR2(64),
UNIT_NUMBER NUMBER(10) NOT NULL,
NUMBER_OF_OBJECTS NUMBER(10) NOT NULL,
NUMBER_OF_SCRIPTS NUMBER(10) NOT NULL,
STORE_UOID VARCHAR2(32) NOT NULL,
STORE_NAME VARCHAR2(64) NOT NULL,
DEPLOYMENT_ADAPTER_ID NUMBER(22) NOT NULL,
AUDIT_STATUS NUMBER(8) NOT NULL,
ABORT_SENT NUMBER(1) DEFAULT (0) NOT NULL,
JOB_MODE NUMBER(8),
JOB_OWNER NUMBER(10),
CURRENT_OP_ABORTED NUMBER(1),
OPS_ENABLED NUMBER(8) NOT NULL,
NUMBER_OF_SCRIPT_ERRORS NUMBER(10) NOT NULL,
NUMBER_OF_SCRIPT_WARNINGS NUMBER(10) NOT NULL,
CREATION_DATE DATE DEFAULT sysdate NOT NULL,
CREATED_BY VARCHAR2(30) DEFAULT user NOT NULL,
LAST_UPDATE_DATE DATE DEFAULT sysdate,
LAST_UPDATED_BY VARCHAR2(30) DEFAULT user,
WORKSPACE_ID NUMBER(22) DEFAULT sys_context('owb_workspace', 'workspaceId') NOT NULL
)
;

CREATE VIEW WB_RT_AUDIT_CUSTOM_PARAMETERS AS select AUDIT_CUSTOM_PARAMETER_ID,AUDIT_TASK_ID,PARAMETER_UOID,PARAMETER_NAME,PARAMETER_TYPE,PARAMETER_MODE,PARAMETER_SCOPE,IS_FIXED,IS_REQUIRED,TYPE_LENGTH,TYPE_SCALE,TYPE_PRECISION,CREATION_DATE,CREATED_BY,WORKSPACE_ID from OWB$WB_RT_AUDIT_CUSTOM_PARAMS where (workspace_id = wb_workspace_management.get_workspace_id or workspace_id = 0 or workspace_id is null) and wb_workspace_management.has_system_privilege_int('CONTROL_CENTER_VIEW') != 0;

CREATE VIEW WB_RT_AUDIT_DEPLOYMENTS AS select AUDIT_DEPLOYMENT_ID,DEPLOYMENT_NAME,DESCRIPTION,NUMBER_OF_UNITS,RUNTIME_VERSION,CLIENT_VERSION,CLIENT_REPOSITORY,CLIENT_REPOSITORY_VERSION,CLIENT_REPOSITORY_USER,RESERVED_TO_SESSION,GENERATION_TIME,AUDIT_STATUS,NUMBER_OF_SCRIPT_ERRORS,NUMBER_OF_SCRIPT_WARNINGS,CREATION_DATE,CREATED_BY,LAST_UPDATE_DATE,LAST_UPDATED_BY,WORKSPACE_ID from OWB$WB_RT_AUDIT_DEPLOYMENTS where (workspace_id = wb_workspace_management.get_workspace_id or workspace_id = 0 or workspace_id is null) and wb_workspace_management.has_system_privilege_int('CONTROL_CENTER_VIEW') != 0;

CREATE VIEW WB_RT_AUDIT_EXECUTIONS AS select AUDIT_EXECUTION_ID,TOP_LEVEL_AUDIT_EXECUTION_ID,PARENT_AUDIT_EXECUTION_ID,SCOPE_AUDIT_EXECUTION_ID,TASK_OBJECT_UOID,TASK_OBJECT_NAME,TASK_OBJECT_TYPE_ID,TASK_OBJECT_STORE_UOID,TASK_OBJECT_STORE_NAME,TASK_OBJECT_STORE_TYPE_ID,TASK_NAME,TASK_INPUT,TASK_INPUT_BINARY,TASK_INPUT_MIME_TYPE,TASK_INPUT_ENCODING_TYPE,EXECUTION_STORE_UOID,EXECUTION_STORE_NAME,EXECUTION_OPERATOR_ID,EXECUTION_OBJECT_UOID,EXECUTION_OBJECT_NAME,EXECUTION_OBJECT_TYPE_ID,EXECUTION_OBJECT_STORE_UOID,EXECUTION_OBJECT_STORE_NAME,EXECUTION_OBJECT_STORE_TYPE_ID,EXECUTION_NAME,DESCRIPTION,RETURN_RESULT,RETURN_RESULT_NUMBER,RETURN_CODE,AUDIT_STATUS,ABORT_SENT,JOB_MODE,JOB_OWNER,CURRENT_OP_ABORTED,CLIENT_INFO,METADATA_INFO,ELAPSE,NUMBER_OF_TASK_ERRORS,NUMBER_OF_TASK_WARNINGS,EXTERNAL_AUDIT_ID,REQUEST_AUDIT_ID,CREATED_BY,CREATION_DATE,LAST_UPDATE_DATE,LAST_UPDATED_BY,WORKSPACE_ID from OWB$WB_RT_AUDIT_EXECUTIONS where (workspace_id = wb_workspace_management.get_workspace_id or workspace_id = 0 or workspace_id is null) and wb_workspace_management.has_system_privilege_int('CONTROL_CENTER_VIEW') != 0;

CREATE VIEW WB_RT_AUDIT_FILES AS select AUDIT_FILE_ID,AUDIT_UNIT_ID,AUDIT_SCRIPT_RUN_ID,AUDIT_EXECUTION_ID,FILE_TYPE_ID,FILE_TEXT,FILE_BINARY,MIME_TYPE,ENCODING_TYPE,CREATED_BY,CREATION_DATE,WORKSPACE_ID from OWB$WB_RT_AUDIT_FILES where (workspace_id = wb_workspace_management.get_workspace_id or workspace_id = 0 or workspace_id is null) and wb_workspace_management.has_system_privilege_int('CONTROL_CENTER_VIEW') != 0;

CREATE VIEW WB_RT_AUDIT_MESSAGES AS select AUDIT_MESSAGE_ID,AUDIT_UNIT_ID,AUDIT_SCRIPT_RUN_ID,AUDIT_EXECUTION_ID,SEVERITY,NUMBER_OF_LINES,CREATED_BY,CREATION_DATE,WORKSPACE_ID from OWB$WB_RT_AUDIT_MESSAGES where (workspace_id = wb_workspace_management.get_workspace_id or workspace_id = 0 or workspace_id is null) and wb_workspace_management.has_system_privilege_int('CONTROL_CENTER_VIEW') != 0;

CREATE VIEW WB_RT_AUDIT_MESSAGE_LINES AS select AUDIT_MESSAGE_LINE_ID,AUDIT_MESSAGE_ID,LINE_NUMBER,IS_NLS,NLS_KEY,NUMBER_OF_PARAMETERS,PLAIN_TEXT,WORKSPACE_ID from OWB$WB_RT_AUDIT_MESSAGE_LINES where (workspace_id = wb_workspace_management.get_workspace_id or workspace_id = 0 or workspace_id is null) and wb_workspace_management.has_system_privilege_int('CONTROL_CENTER_VIEW') != 0;

CREATE VIEW WB_RT_AUDIT_MESSAGE_PARAMETERS AS select AUDIT_MESSAGE_PARAMETER_ID,AUDIT_MESSAGE_LINE_ID,PARAMETER_NUMBER,VALUE,WORKSPACE_ID from OWB$WB_RT_AUDIT_MESSAGE_PARAMS where (workspace_id = wb_workspace_management.get_workspace_id or workspace_id = 0 or workspace_id is null) and wb_workspace_management.has_system_privilege_int('CONTROL_CENTER_VIEW') != 0;

CREATE VIEW WB_RT_AUDIT_OBJECTS AS select AUDIT_OBJECT_ID,AUDIT_UNIT_ID,PARENT_AUDIT_OBJECT_ID,TGT_STORE_UOID,TGT_STORE_NAME,OBJECT_NUMBER,NUMBER_OF_OBJECTS,NUMBER_OF_SCRIPTS,OBJECT_UOID,OBJECT_NAME,OBJECT_TYPE_ID,IMPL_TYPE_ID,OBJECT_VERSION_TAG,CLIENT_INFO,METADATA_INFO,NUMBER_OF_SCRIPT_ERRORS,NUMBER_OF_SCRIPT_WARNINGS,FINAL_OBJECT_STATUS,CREATION_DATE,CREATED_BY,LAST_UPDATE_DATE,LAST_UPDATED_BY,WORKSPACE_ID from OWB$WB_RT_AUDIT_OBJECTS where (workspace_id = wb_workspace_management.get_workspace_id or workspace_id = 0 or workspace_id is null) and wb_workspace_management.has_system_privilege_int('CONTROL_CENTER_VIEW') != 0;

CREATE VIEW WB_RT_AUDIT_PARAMETERS AS select AUDIT_PARAMETER_ID,AUDIT_EXECUTION_ID,PARAMETER_NAME,PARAMETER_TYPE,PARAMETER_KIND,PARAMETER_MODE,PARAMETER_SCOPE,VALUE_MODE,BOUND_TO_ID,IS_REQUIRED,IS_FIXED,PARAMETER_UOID,VALUE_KIND,CLOB_VALUE,cast(DBMS_LOB.SUBSTR(CLOB_VALUE, 4000, 1) AS VARCHAR2(4000)) AS VALUE,TYPE_LENGTH,TYPE_SCALE,TYPE_PRECISION,WORKSPACE_ID from OWB$WB_RT_AUDIT_PARAMS where (workspace_id = wb_workspace_management.get_workspace_id or workspace_id = 0 or workspace_id is null) and wb_workspace_management.has_system_privilege_int('CONTROL_CENTER_VIEW') != 0;

CREATE VIEW WB_RT_AUDIT_PARAMETER_DEFAULTS AS select AUDIT_PARAMETER_DEFAULT_ID,AUDIT_TASK_ID,AUDIT_CUSTOM_PARAMETER_ID,SYSTEM_PARAMETER_ID,VALUE_KIND,CLOB_VALUE,cast(DBMS_LOB.SUBSTR(CLOB_VALUE, 4000, 1) AS VARCHAR2(4000)) AS VALUE,BOUND_TO_NAME,BOUND_TO_KIND,BOUND_TO_SCOPE,CREATION_DATE,CREATED_BY,WORKSPACE_ID from OWB$WB_RT_AUDIT_PARAM_DEFAULTS where (workspace_id = wb_workspace_management.get_workspace_id or workspace_id = 0 or workspace_id is null) and wb_workspace_management.has_system_privilege_int('CONTROL_CENTER_VIEW') != 0;

CREATE VIEW WB_RT_AUDIT_SCRIPTS AS select AUDIT_SCRIPT_ID,AUDIT_UNIT_ID,AUDIT_OBJECT_ID,SCRIPT_NUMBER,ACTION,IS_RUNNABLE,SCRIPT,SCRIPT_BINARY,MIME_TYPE,ENCODING_TYPE,GENERATION_TIME,AUDIT_STATUS,CURRENT_SCRIPT_RUN_ID,NUMBER_OF_SCRIPT_ERRORS,NUMBER_OF_SCRIPT_WARNINGS,CREATION_DATE,CREATED_BY,LAST_UPDATE_DATE,LAST_UPDATED_BY,WORKSPACE_ID from OWB$WB_RT_AUDIT_SCRIPTS where (workspace_id = wb_workspace_management.get_workspace_id or workspace_id = 0 or workspace_id is null) and wb_workspace_management.has_system_privilege_int('CONTROL_CENTER_VIEW') != 0;

CREATE VIEW WB_RT_AUDIT_SCRIPT_RUNS AS select AUDIT_SCRIPT_RUN_ID,AUDIT_SCRIPT_ID,OPERATION,AUDIT_STATUS,ELAPSE,EXTERNAL_AUDIT_ID,CREATION_DATE,CREATED_BY,LAST_UPDATE_DATE,LAST_UPDATED_BY,WORKSPACE_ID from OWB$WB_RT_AUDIT_SCRIPT_RUNS where (workspace_id = wb_workspace_management.get_workspace_id or workspace_id = 0 or workspace_id is null) and wb_workspace_management.has_system_privilege_int('CONTROL_CENTER_VIEW') != 0;

CREATE VIEW WB_RT_AUDIT_TASKS AS select AUDIT_TASK_ID,AUDIT_OBJECT_ID,EXECUTION_STORE_UOID,EXECUTION_OPERATOR_ID,EXECUTION_OBJECT_UOID,EXECUTION_OBJECT_TYPE_ID,EXECUTION_OBJECT_STORE_UOID,EXECUTION_OBJECT_STORE_TYPE_ID,TASK_NAME,TASK_INPUT,TASK_INPUT_BINARY,TASK_INPUT_MIME_TYPE,TASK_INPUT_ENCODING_TYPE,CREATION_DATE,CREATED_BY,WORKSPACE_ID from OWB$WB_RT_AUDIT_TASKS where (workspace_id = wb_workspace_management.get_workspace_id or workspace_id = 0 or workspace_id is null) and wb_workspace_management.has_system_privilege_int('CONTROL_CENTER_VIEW') != 0;

CREATE VIEW WB_RT_AUDIT_UNITS AS select AUDIT_UNIT_ID,AUDIT_DEPLOYMENT_ID,UNIT_NAME,UNIT_NUMBER,NUMBER_OF_OBJECTS,NUMBER_OF_SCRIPTS,STORE_UOID,STORE_NAME,DEPLOYMENT_ADAPTER_ID,AUDIT_STATUS,ABORT_SENT,JOB_MODE,JOB_OWNER,CURRENT_OP_ABORTED,OPS_ENABLED,NUMBER_OF_SCRIPT_ERRORS,NUMBER_OF_SCRIPT_WARNINGS,CREATION_DATE,CREATED_BY,LAST_UPDATE_DATE,LAST_UPDATED_BY,WORKSPACE_ID from OWB$WB_RT_AUDIT_UNITS where (workspace_id = wb_workspace_management.get_workspace_id or workspace_id = 0 or workspace_id is null) and wb_workspace_management.has_system_privilege_int('CONTROL_CENTER_VIEW') != 0;

ALTER TABLE OWB$WB_RT_AUDIT_CUSTOM_PARAMS
ADD CONSTRAINT ACP_PK PRIMARY KEY
(
AUDIT_CUSTOM_PARAMETER_ID
)
 ENABLE
;

ALTER TABLE OWB$WB_RT_AUDIT_DEPLOYMENTS
ADD CONSTRAINT AD_PK PRIMARY KEY
(
AUDIT_DEPLOYMENT_ID
)
 ENABLE
;

ALTER TABLE OWB$WB_RT_AUDIT_EXECUTIONS
ADD CONSTRAINT AE_PK PRIMARY KEY
(
AUDIT_EXECUTION_ID
)
 ENABLE
;

ALTER TABLE OWB$WB_RT_AUDIT_FILES
ADD CONSTRAINT AF_PK PRIMARY KEY
(
AUDIT_FILE_ID
)
 ENABLE
;

ALTER TABLE OWB$WB_RT_AUDIT_MESSAGES
ADD CONSTRAINT AM_PK PRIMARY KEY
(
AUDIT_MESSAGE_ID
)
 ENABLE
;

ALTER TABLE OWB$WB_RT_AUDIT_MESSAGE_LINES
ADD CONSTRAINT AML_PK PRIMARY KEY
(
AUDIT_MESSAGE_LINE_ID
)
 ENABLE
;

ALTER TABLE OWB$WB_RT_AUDIT_MESSAGE_PARAMS
ADD CONSTRAINT AMP_PK PRIMARY KEY
(
AUDIT_MESSAGE_PARAMETER_ID
)
 ENABLE
;

ALTER TABLE OWB$WB_RT_AUDIT_OBJECTS
ADD CONSTRAINT AO_PK PRIMARY KEY
(
AUDIT_OBJECT_ID
)
 ENABLE
;

ALTER TABLE OWB$WB_RT_AUDIT_PARAMS
ADD CONSTRAINT AP_PK PRIMARY KEY
(
AUDIT_PARAMETER_ID
)
 ENABLE
;

ALTER TABLE OWB$WB_RT_AUDIT_PARAMS
ADD CONSTRAINT AP_UK_NAME UNIQUE
(
AUDIT_EXECUTION_ID,
PARAMETER_NAME,
PARAMETER_KIND,
PARAMETER_SCOPE,
VALUE_MODE
)
 ENABLE
;

ALTER TABLE OWB$WB_RT_AUDIT_PARAM_DEFAULTS
ADD CONSTRAINT APD_PK PRIMARY KEY
(
AUDIT_PARAMETER_DEFAULT_ID
)
 ENABLE
;

ALTER TABLE OWB$WB_RT_AUDIT_SCRIPTS
ADD CONSTRAINT AS_PK PRIMARY KEY
(
AUDIT_SCRIPT_ID
)
 ENABLE
;

ALTER TABLE OWB$WB_RT_AUDIT_SCRIPT_RUNS
ADD CONSTRAINT AR_PK PRIMARY KEY
(
AUDIT_SCRIPT_RUN_ID
)
 ENABLE
;

ALTER TABLE OWB$WB_RT_AUDIT_TASKS
ADD CONSTRAINT AT_PK PRIMARY KEY
(
AUDIT_TASK_ID
)
 ENABLE
;

ALTER TABLE OWB$WB_RT_AUDIT_UNITS
ADD CONSTRAINT AU_PK PRIMARY KEY
(
AUDIT_UNIT_ID
)
 ENABLE
;

ALTER TABLE OWB$WB_RT_AUDIT_UNITS
ADD CONSTRAINT AU_UK UNIQUE
(
AUDIT_DEPLOYMENT_ID,
UNIT_NAME
)
 ENABLE
;

ALTER TABLE OWB$WB_RT_AUDIT_CUSTOM_PARAMS
ADD CONSTRAINT ACP_FK_AT FOREIGN KEY
(
AUDIT_TASK_ID
)
REFERENCES OWB$WB_RT_AUDIT_TASKS
(
AUDIT_TASK_ID
)
ON DELETE CASCADE ENABLE
;

ALTER TABLE OWB$WB_RT_AUDIT_EXECUTIONS
ADD CONSTRAINT AE_FK_TOP_LEVEL_AE FOREIGN KEY
(
TOP_LEVEL_AUDIT_EXECUTION_ID
)
REFERENCES OWB$WB_RT_AUDIT_EXECUTIONS
(
AUDIT_EXECUTION_ID
)
ON DELETE CASCADE ENABLE
;

ALTER TABLE OWB$WB_RT_AUDIT_EXECUTIONS
ADD CONSTRAINT AE_FK_PARENT_AE FOREIGN KEY
(
PARENT_AUDIT_EXECUTION_ID
)
REFERENCES OWB$WB_RT_AUDIT_EXECUTIONS
(
AUDIT_EXECUTION_ID
)
ON DELETE CASCADE ENABLE
;

ALTER TABLE OWB$WB_RT_AUDIT_FILES
ADD CONSTRAINT AF_FK_AU FOREIGN KEY
(
AUDIT_UNIT_ID
)
REFERENCES OWB$WB_RT_AUDIT_UNITS
(
AUDIT_UNIT_ID
)
ON DELETE CASCADE ENABLE
;

ALTER TABLE OWB$WB_RT_AUDIT_FILES
ADD CONSTRAINT AF_FK_AE FOREIGN KEY
(
AUDIT_EXECUTION_ID
)
REFERENCES OWB$WB_RT_AUDIT_EXECUTIONS
(
AUDIT_EXECUTION_ID
)
ON DELETE CASCADE ENABLE
;

ALTER TABLE OWB$WB_RT_AUDIT_FILES
ADD CONSTRAINT AF_FK_AR FOREIGN KEY
(
AUDIT_SCRIPT_RUN_ID
)
REFERENCES OWB$WB_RT_AUDIT_SCRIPT_RUNS
(
AUDIT_SCRIPT_RUN_ID
)
ON DELETE CASCADE ENABLE
;

ALTER TABLE OWB$WB_RT_AUDIT_MESSAGES
ADD CONSTRAINT AM_FK_AE FOREIGN KEY
(
AUDIT_EXECUTION_ID
)
REFERENCES OWB$WB_RT_AUDIT_EXECUTIONS
(
AUDIT_EXECUTION_ID
)
ON DELETE CASCADE ENABLE
;

ALTER TABLE OWB$WB_RT_AUDIT_MESSAGES
ADD CONSTRAINT AM_FK_AU FOREIGN KEY
(
AUDIT_UNIT_ID
)
REFERENCES OWB$WB_RT_AUDIT_UNITS
(
AUDIT_UNIT_ID
)
ON DELETE CASCADE ENABLE
;

ALTER TABLE OWB$WB_RT_AUDIT_MESSAGES
ADD CONSTRAINT AM_FK_AR FOREIGN KEY
(
AUDIT_SCRIPT_RUN_ID
)
REFERENCES OWB$WB_RT_AUDIT_SCRIPT_RUNS
(
AUDIT_SCRIPT_RUN_ID
)
ON DELETE CASCADE ENABLE
;

ALTER TABLE OWB$WB_RT_AUDIT_MESSAGE_LINES
ADD CONSTRAINT AML_FK_AM FOREIGN KEY
(
AUDIT_MESSAGE_ID
)
REFERENCES OWB$WB_RT_AUDIT_MESSAGES
(
AUDIT_MESSAGE_ID
)
ON DELETE CASCADE ENABLE
;

ALTER TABLE OWB$WB_RT_AUDIT_MESSAGE_PARAMS
ADD CONSTRAINT AMP_FK_AML FOREIGN KEY
(
AUDIT_MESSAGE_LINE_ID
)
REFERENCES OWB$WB_RT_AUDIT_MESSAGE_LINES
(
AUDIT_MESSAGE_LINE_ID
)
ON DELETE CASCADE ENABLE
;

ALTER TABLE OWB$WB_RT_AUDIT_OBJECTS
ADD CONSTRAINT AO_FK_PARENT_AO FOREIGN KEY
(
PARENT_AUDIT_OBJECT_ID
)
REFERENCES OWB$WB_RT_AUDIT_OBJECTS
(
AUDIT_OBJECT_ID
) ENABLE
;

ALTER TABLE OWB$WB_RT_AUDIT_OBJECTS
ADD CONSTRAINT AO_FK_AU FOREIGN KEY
(
AUDIT_UNIT_ID
)
REFERENCES OWB$WB_RT_AUDIT_UNITS
(
AUDIT_UNIT_ID
)
ON DELETE CASCADE ENABLE
;

ALTER TABLE OWB$WB_RT_AUDIT_PARAMS
ADD CONSTRAINT AP_FK_AE FOREIGN KEY
(
AUDIT_EXECUTION_ID
)
REFERENCES OWB$WB_RT_AUDIT_EXECUTIONS
(
AUDIT_EXECUTION_ID
)
ON DELETE CASCADE ENABLE
;

ALTER TABLE OWB$WB_RT_AUDIT_PARAM_DEFAULTS
ADD CONSTRAINT APD_FK_T FOREIGN KEY
(
AUDIT_TASK_ID
)
REFERENCES OWB$WB_RT_AUDIT_TASKS
(
AUDIT_TASK_ID
)
ON DELETE CASCADE ENABLE
;

ALTER TABLE OWB$WB_RT_AUDIT_PARAM_DEFAULTS
ADD CONSTRAINT APD_FK_ACP FOREIGN KEY
(
AUDIT_CUSTOM_PARAMETER_ID
)
REFERENCES OWB$WB_RT_AUDIT_CUSTOM_PARAMS
(
AUDIT_CUSTOM_PARAMETER_ID
) ENABLE
;

ALTER TABLE OWB$WB_RT_AUDIT_SCRIPTS
ADD CONSTRAINT AS_FK_AO FOREIGN KEY
(
AUDIT_OBJECT_ID
)
REFERENCES OWB$WB_RT_AUDIT_OBJECTS
(
AUDIT_OBJECT_ID
)
ON DELETE CASCADE ENABLE
;

ALTER TABLE OWB$WB_RT_AUDIT_SCRIPTS
ADD CONSTRAINT AS_FK_AU FOREIGN KEY
(
AUDIT_UNIT_ID
)
REFERENCES OWB$WB_RT_AUDIT_UNITS
(
AUDIT_UNIT_ID
)
ON DELETE CASCADE ENABLE
;

ALTER TABLE OWB$WB_RT_AUDIT_SCRIPTS
ADD CONSTRAINT AS_FK_CSR FOREIGN KEY
(
CURRENT_SCRIPT_RUN_ID
)
REFERENCES OWB$WB_RT_AUDIT_SCRIPT_RUNS
(
AUDIT_SCRIPT_RUN_ID
) ENABLE
;

ALTER TABLE OWB$WB_RT_AUDIT_SCRIPT_RUNS
ADD CONSTRAINT AR_FK_AS FOREIGN KEY
(
AUDIT_SCRIPT_ID
)
REFERENCES OWB$WB_RT_AUDIT_SCRIPTS
(
AUDIT_SCRIPT_ID
)
ON DELETE CASCADE ENABLE
;

ALTER TABLE OWB$WB_RT_AUDIT_TASKS
ADD CONSTRAINT AT_FK_AO FOREIGN KEY
(
AUDIT_OBJECT_ID
)
REFERENCES OWB$WB_RT_AUDIT_OBJECTS
(
AUDIT_OBJECT_ID
)
ON DELETE CASCADE ENABLE
;

ALTER TABLE OWB$WB_RT_AUDIT_UNITS
ADD CONSTRAINT AU_FK_AD FOREIGN KEY
(
AUDIT_DEPLOYMENT_ID
)
REFERENCES OWB$WB_RT_AUDIT_DEPLOYMENTS
(
AUDIT_DEPLOYMENT_ID
)
ON DELETE CASCADE ENABLE
;

CREATE INDEX WB_RT_IDX_ACP_AT ON OWB$WB_RT_AUDIT_CUSTOM_PARAMS (AUDIT_TASK_ID ASC) TABLESPACE %tndex;

CREATE INDEX WB_RT_IDX_AD_W_CRD ON OWB$WB_RT_AUDIT_DEPLOYMENTS (WORKSPACE_ID ASC, CREATION_DATE ASC) TABLESPACE %tndex;

CREATE INDEX WB_RT_IDX_EX_EK ON OWB$WB_RT_AUDIT_EXECUTIONS (WORKSPACE_ID ASC, EXTERNAL_AUDIT_ID ASC) TABLESPACE %tndex;
CREATE INDEX WB_RT_IDX_EX_PEK ON OWB$WB_RT_AUDIT_EXECUTIONS (EXTERNAL_AUDIT_ID ASC, PARENT_AUDIT_EXECUTION_ID ASC) TABLESPACE %tndex;
CREATE INDEX WB_RT_IDX_EX_PRK ON OWB$WB_RT_AUDIT_EXECUTIONS (REQUEST_AUDIT_ID ASC, PARENT_AUDIT_EXECUTION_ID ASC) TABLESPACE %tndex;
CREATE INDEX WB_RT_IDX_EX_W_CRD ON OWB$WB_RT_AUDIT_EXECUTIONS (WORKSPACE_ID ASC, CREATION_DATE ASC) TABLESPACE %tndex;
CREATE INDEX WB_RT_IDX_EX_PEX ON OWB$WB_RT_AUDIT_EXECUTIONS (PARENT_AUDIT_EXECUTION_ID ASC) TABLESPACE %tndex;
CREATE INDEX WB_RT_IDX_EX_TLEX ON OWB$WB_RT_AUDIT_EXECUTIONS (TOP_LEVEL_AUDIT_EXECUTION_ID ASC) TABLESPACE %tndex;
CREATE INDEX WB_RT_IDX_EX_WEX ON OWB$WB_RT_AUDIT_EXECUTIONS (WORKSPACE_ID ASC, AUDIT_EXECUTION_ID ASC) TABLESPACE %tndex;
CREATE INDEX WB_RT_IDX_EX_WPEX ON OWB$WB_RT_AUDIT_EXECUTIONS (WORKSPACE_ID ASC, PARENT_AUDIT_EXECUTION_ID ASC) TABLESPACE %tndex;
CREATE INDEX WB_RT_IDX_EX_WTLEX ON OWB$WB_RT_AUDIT_EXECUTIONS (WORKSPACE_ID ASC, TOP_LEVEL_AUDIT_EXECUTION_ID ASC) TABLESPACE %tndex;
CREATE INDEX WB_RT_IDX_EX_WEXPEX ON OWB$WB_RT_AUDIT_EXECUTIONS (WORKSPACE_ID ASC, AUDIT_EXECUTION_ID ASC, PARENT_AUDIT_EXECUTION_ID ASC) TABLESPACE %tndex;
CREATE INDEX WB_RT_IDX_EX_WEXTLEX ON OWB$WB_RT_AUDIT_EXECUTIONS (WORKSPACE_ID ASC, AUDIT_EXECUTION_ID ASC, TOP_LEVEL_AUDIT_EXECUTION_ID ASC) TABLESPACE %tndex;
CREATE INDEX WB_RT_IDX_EX_EOT ON OWB$WB_RT_AUDIT_EXECUTIONS (WORKSPACE_ID ASC, EXECUTION_OBJECT_TYPE_ID ASC) TABLESPACE %tndex;
CREATE INDEX WB_RT_IDX_EX_EOP ON OWB$WB_RT_AUDIT_EXECUTIONS (WORKSPACE_ID ASC, EXECUTION_OPERATOR_ID ASC) TABLESPACE %tndex;
CREATE INDEX WB_RT_IDX_EX_TOU ON OWB$WB_RT_AUDIT_EXECUTIONS (WORKSPACE_ID ASC, TASK_OBJECT_UOID ASC, TASK_OBJECT_TYPE_ID ASC, TASK_OBJECT_STORE_UOID ASC) TABLESPACE %tndex;

CREATE INDEX WB_RT_IDX_AF_ASR ON OWB$WB_RT_AUDIT_FILES (AUDIT_SCRIPT_RUN_ID ASC) TABLESPACE %tndex;

CREATE INDEX WB_RT_IDX_AF_AE ON OWB$WB_RT_AUDIT_FILES (AUDIT_EXECUTION_ID ASC) TABLESPACE %tndex;

CREATE INDEX WB_RT_IDX_AF_AU ON OWB$WB_RT_AUDIT_FILES (AUDIT_UNIT_ID ASC) TABLESPACE %tndex;

CREATE INDEX WB_RT_IDX_AM_AU ON OWB$WB_RT_AUDIT_MESSAGES (AUDIT_UNIT_ID ASC) TABLESPACE %tndex;

CREATE INDEX WB_RT_IDX_AM_ASR ON OWB$WB_RT_AUDIT_MESSAGES (AUDIT_SCRIPT_RUN_ID ASC) TABLESPACE %tndex;

CREATE INDEX WB_RT_IDX_AM_AE ON OWB$WB_RT_AUDIT_MESSAGES (AUDIT_EXECUTION_ID ASC) TABLESPACE %tndex;

CREATE INDEX WB_RT_IDX_AML_AM ON OWB$WB_RT_AUDIT_MESSAGE_LINES (AUDIT_MESSAGE_ID ASC) TABLESPACE %tndex;

CREATE INDEX WB_RT_IDX_AMP_AML ON OWB$WB_RT_AUDIT_MESSAGE_PARAMS (AUDIT_MESSAGE_LINE_ID ASC) TABLESPACE %tndex;

CREATE INDEX WB_RT_IDX_AO_AU ON OWB$WB_RT_AUDIT_OBJECTS (AUDIT_UNIT_ID ASC) TABLESPACE %tndex;

CREATE INDEX WB_RT_IDX_AO_OU ON OWB$WB_RT_AUDIT_OBJECTS (OBJECT_UOID ASC) TABLESPACE %tndex;

CREATE INDEX WB_RT_IDX_AO_PA ON OWB$WB_RT_AUDIT_OBJECTS (PARENT_AUDIT_OBJECT_ID ASC) TABLESPACE %tndex;

CREATE INDEX WB_RT_IDX_AP_AE ON OWB$WB_RT_AUDIT_PARAMS (AUDIT_EXECUTION_ID ASC) TABLESPACE %tndex;

CREATE INDEX WB_RT_IDX_APD_AT ON OWB$WB_RT_AUDIT_PARAM_DEFAULTS (AUDIT_TASK_ID ASC) TABLESPACE %tndex;

CREATE INDEX WB_RT_IDX_APD_ACP ON OWB$WB_RT_AUDIT_PARAM_DEFAULTS (AUDIT_CUSTOM_PARAMETER_ID ASC) TABLESPACE %tndex;

CREATE INDEX WB_RT_IDX_AS_AO ON OWB$WB_RT_AUDIT_SCRIPTS (AUDIT_OBJECT_ID ASC) TABLESPACE %tndex;

CREATE INDEX WB_RT_IDX_AS_AU ON OWB$WB_RT_AUDIT_SCRIPTS (AUDIT_UNIT_ID ASC) TABLESPACE %tndex;

CREATE INDEX WB_RT_IDX_ASR_AS ON OWB$WB_RT_AUDIT_SCRIPT_RUNS (AUDIT_SCRIPT_ID ASC) TABLESPACE %tndex;

CREATE INDEX WB_RT_IDX_AT_AO ON OWB$WB_RT_AUDIT_TASKS (AUDIT_OBJECT_ID ASC) TABLESPACE %tndex;

CREATE INDEX WB_RT_IDX_AU_AD ON OWB$WB_RT_AUDIT_UNITS (AUDIT_DEPLOYMENT_ID ASC) TABLESPACE %tndex;

